/*
 *  pwd.h passwd structure and prototypes
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _PWD_H_INCLUDED
#define _PWD_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef _SYS_TYPES_H_INCLUDED
 #include <sys/types.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 8 )

struct passwd {
    char        *pw_name;       /* user's login name */
    char        *pw_passwd;     /* user's password   */
    uid_t       pw_uid;         /* user ID number    */
    gid_t       pw_gid;         /* group ID number   */
    char        *pw_gecos;      /* real name         */
    char        *pw_dir;        /* home directory    */
    char        *pw_shell;      /* initial program   */
};

#pragma pack( __pop )

/*
 *  POSIX 1003.1 Prototypes.
 */
_WCRTLINK extern struct passwd *getpwnam( const char *__name );
_WCRTLINK extern struct passwd *getpwuid( uid_t __uid );
_WCRTLINK extern struct passwd *getpwent( void );
_WCRTLINK extern void          setpwent( void );
_WCRTLINK extern void          endpwent( void );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
