/*
 *  semaphore.h for Linux
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _SEMAPHORE_H_INCLUDED
#define _SEMAPHORE_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
 #ifndef _STDTIME_T_DEFINED
 #define _STDTIME_T_DEFINED
  namespace std {
    typedef signed long time_t;
  }
  typedef std::time_t __w_time_t;
 #endif
 #ifndef _TIME_T_DEFINED
 #define _TIME_T_DEFINED
  #define _TIME_T_DEFINED_
  using std::time_t;
 #endif
#else  /* __cplusplus not defined */
 #ifndef _TIME_T_DEFINED
 #define _TIME_T_DEFINED
  #define _TIME_T_DEFINED_
  typedef signed long time_t;
  typedef time_t __w_time_t;
 #endif
#endif /* __cplusplus not defined */

#ifndef _TIMESPEC_DEFINED
 #define _TIMESPEC_DEFINED
 struct timespec {
     __w_time_t tv_sec;
     long       tv_nsec;
 };
#endif /* _TIMESPEC_DEFINED */

#ifndef _SEM_T_DEFINED_
 #define _SEM_T_DEFINED_
 typedef struct {
     volatile int futex;
     volatile int value;
 } sem_t;
#endif

_WCRTLINK extern int sem_init( sem_t *__sem, int __pshared, unsigned int __value );
_WCRTLINK extern int sem_destroy( sem_t *__sem );
_WCRTLINK extern int sem_getvalue( sem_t *__sem, int *__value );
_WCRTLINK extern int sem_post( sem_t *__sem );
_WCRTLINK extern int sem_trywait( sem_t *__sem );
_WCRTLINK extern int sem_wait( sem_t *__sem );
_WCRTLINK extern int sem_timedwait( sem_t *__sem, const struct timespec *__abstime );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _SEMAPHORE_H_INCLUDED */
