/***************************************************************************
 * FILE: stdarg.h/cstdarg (Macros for use with variable argument lists)
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 *
 * Description: This header is part of the C/C++ standard library. It
 *              contains macros for use in variable length argument
 *              lists.
 ***************************************************************************/
#ifndef _STDARG_H_INCLUDED
#define _STDARG_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus

#include <cstdarg>

using std::va_list;

#else /* __cplusplus not defined */

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef ___VA_LIST_DEFINED
#define ___VA_LIST_DEFINED
 #ifdef __PPC__
   typedef struct {
       char  __gpr;
       char  __fpr;
       char  __reserved[2];
       char  *__input_arg_area;
       char  *__reg_save_area;
   } __va_list;
 #elif defined(__AXP__)
  typedef struct {
      char  *__base;
      int   __offset;
  } __va_list;
 #elif defined(__MIPS__)
  typedef struct {
      char  *__base;
      int   __offset;
  } __va_list;
 #elif defined(_M_IX86)
  #if defined(__SW_ZU)
   typedef char _WCFAR *__va_list;
  #else
   typedef char    *__va_list;
  #endif
 #endif
#endif

#ifndef _VA_LIST_DEFINED
#define _VA_LIST_DEFINED
  typedef __va_list va_list;
#endif

#ifdef __AXP__
 #define _AXP_WORD_SIZE     8
 #define _AXP_FLOAT_SIZE    8
 #define _AXP_FLOAT_REGS    6
 extern void *__builtin_va_start(__va_list*, ...);
 #pragma intrinsic(__builtin_va_start)
 #define va_start(__ap,__pn)    (__builtin_va_start(&__ap,__pn,1))
 #define va_arg(__ap,__type)    ((__ap).__offset+=\
     ((sizeof(__type)+_AXP_WORD_SIZE-1)&~(_AXP_WORD_SIZE-1)),\
     (*(__type *)((__ap).__base+(__ap).__offset-\
       ((__builtin_isfloat(__type)&&(__ap).__offset <=\
         (_AXP_FLOAT_REGS*_AXP_FLOAT_SIZE)) ?\
           (_AXP_FLOAT_REGS*_AXP_FLOAT_SIZE)+_AXP_FLOAT_SIZE :\
             ((sizeof(__type)+_AXP_WORD_SIZE-1)&~(_AXP_WORD_SIZE-1))))))
 #define va_end(__ap)           ((void)0)
#elif defined(__PPC__)
  extern void *__builtin_va_start( __va_list *, ...);
  #pragma intrinsic(__builtin_va_start)
  #define va_start(__ap,__pn)   (__builtin_va_start(&__ap,__pn,1))
  #define va_arg(__ap,__type)   (__builtin_va_arg(&__ap,__type))
#elif defined(__MIPS__)
 #define _MIPS_WORD_SIZE     4
 extern void *__builtin_va_start(__va_list*, ...);
 #pragma intrinsic(__builtin_va_start)
 #define va_start(__ap,__pn)    (__builtin_va_start(&__ap,__pn,1))
 #define va_arg(__ap,__type)    ((__ap).__offset+=\
     ((sizeof(__type)+_MIPS_WORD_SIZE-1)&~(_MIPS_WORD_SIZE-1)),\
     (*(__type *)((__ap).__base+(__ap).__offset-\
       (((sizeof(__type)+_MIPS_WORD_SIZE-1)&~(_MIPS_WORD_SIZE-1))))))
 #define va_end(__ap)           ((void)0)
#elif defined(_M_IX86)
 #ifdef __SW_ZU
  #define va_start(__ap,__pn)   (__ap=(char _WCFAR*)&__pn+\
      ((sizeof(__pn)+sizeof(int)-1)&~(sizeof(int)-1)),(void)0)
  #define va_arg(__ap,__type)   (__ap+=\
      ((sizeof(__type)+sizeof(int)-1)&~(sizeof(int)-1)),\
      (*(__type _WCFAR*)(__ap-((sizeof(__type)+sizeof(int)-1)&~(sizeof(int)-1)))))
  #define va_end(__ap)          (__ap=0,(void)0)
 #else
  #define va_start(__ap,__pn)   (__ap=(char *)&__pn+\
      ((sizeof(__pn)+sizeof(int)-1)&~(sizeof(int)-1)),(void)0)
  #define va_arg(__ap,__type)   (__ap+=\
      ((sizeof(__type)+sizeof(int)-1)&~(sizeof(int)-1)),\
      (*(__type *)(__ap-((sizeof(__type)+sizeof(int)-1)&~(sizeof(int)-1)))))
  #define va_end(__ap)          (__ap=0,(void)0)
 #endif
#endif

#define __va_copy(__dest,__src)    ((__dest)=(__src),(void)0)

#if !defined( _NO_EXT_KEYS ) || __STDC_VERSION__ >= 199901L /* extensions enabled or C99 */
#define va_copy(__dest,__src)   __va_copy(__dest,__src)
#endif /* extensions enabled */

#endif /* __cplusplus not defined */

#endif
