/*
 *  sys/socket.h      Socket functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _SYS_SOCKET_H_INCLUDED
#define _SYS_SOCKET_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 4 )

#ifndef _UNISTD_H_INCLUDED
 #include <unistd.h>
#endif

#ifndef _ARCH_DIR
 #ifdef __386__
  #define _ARCH_DIR i386
 #elif defined(__MIPS__)
  #define _ARCH_DIR mips
 #elif defined(__PPC__)
  #define _ARCH_DIR ppc
 #else
  #error unknown platform
  #define _ARCH_DIR
 #endif
 #define _ARCH_INCLUDE(hdr) <arch/ ## _ARCH_DIR ## / ## hdr ## >
#endif /* !_ARCH_DIR */

#ifndef _SA_FAMILY_T_DEFINED_
#define _SA_FAMILY_T_DEFINED_
typedef unsigned short sa_family_t;
#endif

struct sockaddr {
    sa_family_t sa_family;
    char sa_data[14];
};

struct linger {
    int l_onoff;
    int l_linger;
};

/* Supported address families. */
#define AF_UNSPEC       0
#define AF_UNIX         1       /* Unix domain sockets          */
#define AF_LOCAL        1       /* POSIX name for AF_UNIX       */
#define AF_INET         2       /* Internet IP Protocol         */
#define AF_AX25         3       /* Amateur Radio AX.25          */
#define AF_IPX          4       /* Novell IPX                   */
#define AF_APPLETALK    5       /* AppleTalk DDP                */
#define AF_NETROM       6       /* Amateur Radio NET/ROM        */
#define AF_BRIDGE       7       /* Multiprotocol bridge         */
#define AF_ATMPVC       8       /* ATM PVCs                     */
#define AF_X25          9       /* Reserved for X.25 project    */
#define AF_INET6        10      /* IP version 6                 */
#define AF_ROSE         11      /* Amateur Radio X.25 PLP       */
#define AF_DECnet       12      /* Reserved for DECnet project  */
#define AF_NETBEUI      13      /* Reserved for 802.2LLC project*/
#define AF_SECURITY     14      /* Security callback pseudo AF */
#define AF_KEY          15      /* PF_KEY key management API */
#define AF_NETLINK      16
#define AF_ROUTE        16      /* Alias to emulate 4.4BSD */
#define AF_PACKET       17      /* Packet family                */
#define AF_ASH          18      /* Ash                          */
#define AF_ECONET       19      /* Acorn Econet                 */
#define AF_ATMSVC       20      /* ATM SVCs                     */
#define AF_SNA          22      /* Linux SNA Project (nutters!) */
#define AF_IRDA         23      /* IRDA sockets                 */
#define AF_PPPOX        24      /* PPPoX sockets                */
#define AF_WANPIPE      25      /* Wanpipe API Sockets */
#define AF_MAX          32      /* For now.. */


/* Protocol families, same as address families. */
#define PF_UNSPEC       AF_UNSPEC
#define PF_UNIX         AF_UNIX
#define PF_LOCAL        AF_LOCAL
#define PF_INET         AF_INET
#define PF_AX25         AF_AX25
#define PF_IPX          AF_IPX
#define PF_APPLETALK    AF_APPLETALK
#define PF_NETROM       AF_NETROM
#define PF_BRIDGE       AF_BRIDGE
#define PF_ATMPVC       AF_ATMPVC
#define PF_X25          AF_X25
#define PF_INET6        AF_INET6
#define PF_ROSE         AF_ROSE
#define PF_DECnet       AF_DECnet
#define PF_NETBEUI      AF_NETBEUI
#define PF_SECURITY     AF_SECURITY
#define PF_KEY          AF_KEY
#define PF_NETLINK      AF_NETLINK
#define PF_ROUTE        AF_ROUTE
#define PF_PACKET       AF_PACKET
#define PF_ASH          AF_ASH
#define PF_ECONET       AF_ECONET
#define PF_ATMSVC       AF_ATMSVC
#define PF_SNA          AF_SNA
#define PF_IRDA         AF_IRDA
#define PF_PPPOX        AF_PPPOX
#define PF_WANPIPE      AF_WANPIPE
#define PF_MAX          AF_MAX


/* Maximum backlog for the listen( ) function - system-configurable */
#define SOMAXCONN sysconf(_SC_SOMAXCONN)

#include _ARCH_INCLUDE(sys/socket.h)



typedef unsigned int socklen_t;

_WCRTLINK extern int socket( int __domain, int __type, int __protocol );
_WCRTLINK extern int bind( int __sockfd, const struct sockaddr *__my_addr, socklen_t __addrlen );
_WCRTLINK extern int getsockopt( int __s, int __level, int __optname, void *__optval, socklen_t *__optlen );
_WCRTLINK extern int setsockopt( int __s, int __level, int __optname, const void *__optval, socklen_t __optlen );
_WCRTLINK extern int recv(int __s, void *__buf, size_t __len, int __flags);
_WCRTLINK extern int recvfrom(int __s, void *__buf, size_t __len, int __flags, struct sockaddr *__from, socklen_t *__fromlen);
_WCRTLINK extern int recvmsg(int s, struct msghdr *__msg, int __flags);
_WCRTLINK extern int send( int __s, const void *__msg, size_t __len, int __flags );
_WCRTLINK extern int sendto( int __s, const void *__msg, size_t __len, int __flags, const struct sockaddr *__to, socklen_t __tolen );
_WCRTLINK extern int sendmsg( int __s, const struct msghdr *__msg, int __flags );
_WCRTLINK extern int accept( int __s, struct sockaddr *__addr, socklen_t *__addrlen );
_WCRTLINK extern int listen( int __s, int __backlog );
_WCRTLINK extern int getpeername( int __s, struct sockaddr *__name, socklen_t *__namelen );
_WCRTLINK extern int getsockname( int __s , struct sockaddr *__name, socklen_t *__namelen );
_WCRTLINK extern int connect( int __sockfd, const struct sockaddr *__serv_addr, socklen_t __addrlen );
_WCRTLINK extern int shutdown( int __s, int __how );


#pragma pack( __pop )

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* !_SYS_SOCKET_H_INCLUDED */
