/*
 *  sys/stat.h  Equates and prototype for fstat, stat functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _SYS_STAT_H_INCLUDED
#define _SYS_STAT_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#if defined( _POSIX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 4 )

/*
 *  ISO C types
 */
#ifdef __cplusplus
 #ifndef _STDTIME_T_DEFINED
 #define _STDTIME_T_DEFINED
  namespace std {
    typedef signed long time_t;
  }
  typedef std::time_t __w_time_t;
 #endif
 #ifndef _TIME_T_DEFINED
 #define _TIME_T_DEFINED
  #define _TIME_T_DEFINED_
  using std::time_t;
 #endif
#else  /* __cplusplus not defined */
 #ifndef _TIME_T_DEFINED
 #define _TIME_T_DEFINED
  #define _TIME_T_DEFINED_
  typedef signed long time_t;
  typedef time_t __w_time_t;
 #endif
#endif /* __cplusplus not defined */
#if defined( _LINUX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */
#ifndef __cplusplus
 #ifndef _WCHAR_T_DEFINED
 #define _WCHAR_T_DEFINED
  #define _WCHAR_T_DEFINED_
  typedef unsigned short wchar_t;
 #endif
#endif
#endif /* extensions enabled */

/*
 *  POSIX 1003.1 types
 */
#ifndef _OFF_T_DEFINED_
 #define _OFF_T_DEFINED_
 typedef long           off_t;  /* Used for file sizes, offsets     */
#endif

/* Versions of the 'struct stat' data structure.  */
#define _STAT_VER_LINUX_OLD 1
#define _STAT_VER_KERNEL    1
#define _STAT_VER_SVR4      2
#define _STAT_VER_LINUX     3
#define _STAT_VER           _STAT_VER_LINUX /* The one defined below.  */

#ifndef _ARCH_DIR
 #ifdef __386__
  #define _ARCH_DIR i386
 #elif defined(__MIPS__)
  #define _ARCH_DIR mips
 #elif defined(__PPC__)
  #define _ARCH_DIR ppc
 #else
  #error unknown platform
  #define _ARCH_DIR
 #endif
 #define _ARCH_INCLUDE(hdr) <arch/ ## _ARCH_DIR ## / ## hdr ## >
#endif /* !_ARCH_DIR */

#include _ARCH_INCLUDE(sys/stat.h)

/*
 *  Common filetype macros
 */
#define S_ISUID     004000      /* set user id on execution         */
#define S_ISGID     002000      /* set group id on execution        */
#define S_ISVTX     001000      /* sticky bit (does nothing yet)    */

#define S_ENFMT     002000      /* enforcement mode locking         */

/*
 *  Owner permissions
 */
#define S_IRWXU     000700      /* Read, write, execute/search      */
#define S_IRUSR     000400      /* Read permission                  */
#define S_IWUSR     000200      /* Write permission                 */
#define S_IXUSR     000100      /* Execute/search permission        */

#define S_IREAD     S_IRUSR     /* Read permission                  */
#define S_IWRITE    S_IWUSR     /* Write permission                 */
#define S_IEXEC     S_IXUSR     /* Execute/search permission        */

#if defined( _LINUX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */
#define _S_IREAD    S_IREAD
#define _S_IWRITE   S_IWRITE
#define _S_IEXEC    S_IEXEC
#endif /* extensions enabled */

/*
 *  Group permissions
 */
#define S_IRWXG     000070      /* Read, write, execute/search      */
#define S_IRGRP     000040      /* Read permission                  */
#define S_IWGRP     000020      /* Write permission                 */
#define S_IXGRP     000010      /* Execute/search permission        */

/*
 *  Other permissions
 */
#define S_IRWXO     000007      /* Read, write, execute/search      */
#define S_IROTH     000004      /* Read permission                  */
#define S_IWOTH     000002      /* Write permission                 */
#define S_IXOTH     000001      /* Execute/search permission        */

/*
 *  Encoding of the file mode
 */
#define S_IFMT      0xF000          /* Type of file mask    */
#define S_IFIFO     0x1000          /* FIFO (pipe)          */
#define S_IFCHR     0x2000          /* Character special    */
#define S_IFDIR     0x4000          /* Directory            */
#define S_IFNAM     0x5000          /* Special named file   */
#define S_IFBLK     0x6000          /* Block special        */
#define S_IFREG     0x8000          /* Regular              */
#define S_IFLNK     0xA000          /* Symbolic link        */
#define S_IFSOCK    0xC000          /* Socket               */

#if defined( _LINUX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */
#define _S_IFMT     S_IFMT
#define _S_IFIFO    S_IFIFO
#define _S_IFCHR    S_IFCHR
#define _S_IFDIR    S_IFDIR
#define _S_IFNAM    S_IFNAM
#define _S_IFBLK    S_IFBLK
#define _S_IFREG    S_IFREG
#define _S_IFLNK    S_IFLNK
#define _S_IFSOCK   S_IFSOCK
#endif /* extensions enabled */

#define S_ISFIFO(__m) (((__m)&S_IFMT)==S_IFIFO)    /* Test for FIFO (pipe)        */
#define S_ISCHR(__m)  (((__m)&S_IFMT)==S_IFCHR)    /* Test for char special file  */
#define S_ISDIR(__m)  (((__m)&S_IFMT)==S_IFDIR)    /* Test for directory file     */
#define S_ISBLK(__m)  (((__m)&S_IFMT)==S_IFBLK)    /* Test for block specl file   */
#define S_ISREG(__m)  (((__m)&S_IFMT)==S_IFREG)    /* Test for regular file       */
#define S_ISLNK(__m)  (((__m)&S_IFMT)==S_IFLNK)    /* Test for symbolic link      */
#define S_ISNAM(__m)  (((__m)&S_IFMT)==S_IFNAM)    /* Test for special named file */
#define S_ISSOCK(__m) (((__m)&S_IFMT)==S_IFSOCK)   /* Test for socket             */

/*
 *  POSIX 1003.1 Prototypes.
 */
_WCRTLINK extern int        chmod( const char *__path, mode_t __pmode );
_WCRTLINK extern mode_t     umask( mode_t __cmask );
_WCRTLINK extern int        mkdir( const char *__path, mode_t mode );
_WCRTLINK extern int        fchmod( int __fildes, mode_t __mode );
_WCRTLINK extern int        mkfifo( const char *__path, mode_t __mode );
_WCRTLINK extern int        mknod( const char *__path, mode_t __mode, int __dev );
_WCRTLINK extern int        stat( const char *__path, struct stat *__buf );
_WCRTLINK extern int        stat64( const char *__path, struct stat64 *__buf );
_WCRTLINK extern int        fstat( int __fildes, struct stat *__buf );
_WCRTLINK extern int        fstat64( int __fildes, struct stat64 *__buf );
_WCRTLINK extern int        lstat( const char *__path, struct stat *__buf );
_WCRTLINK extern int        lstat64( const char *__path, struct stat64 *__buf );
#if defined( _LINUX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */
_WCRTLINK extern int        _stat( const char *__path, struct stat *__buf );
_WCRTLINK extern int        _fstat( int __fildes, struct stat *__buf );
#endif /* extensions enabled */

#pragma pack( __pop )

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* extensions enabled */

#endif
