/*
 *  dirent.h    Portable directory entry definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _DIRENT_H_INCLUDED
#define _DIRENT_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NAME_MAX
 #define NAME_MAX       255     /* maximum filename for RDOS          */
#endif

#pragma pack( __push, 1 )

struct dirent {
    int                 d_handle;                   /* directory handle */
    int                 d_entry_count;              /* directory entry count */
    int                 d_header_size;              /* internal header size */
    char *              d_entry_head;               /* internal entry head */
    char *              d_entry_chain;              /* internal entry chain */
    char                d_match_mask[NAME_MAX+1];   /* mask for matching files */
    int                 d_entry_nr;                 /* current entry number (first = 0) */
    long long           d_ino;                      /* inode */
    int                 d_attr;                     /* file's attribute */
    unsigned long long  d_create_time;              /* create timestamp, rdos formatted */
    unsigned long long  d_modify_time;              /* modify timestamp, rdos formatted */
    unsigned long long  d_access_time;              /* access timestamp, rdos formatted */
    long long           d_size;                     /* file's size */
    char                d_name[NAME_MAX+1];         /* file's name */
};
typedef struct dirent   DIR;

#pragma pack( __pop )

/* File attribute constants for attribute field */

#define _A_NORMAL       0x00    /* Normal file - read/write permitted */
#define _A_RDONLY       0x01    /* Read-only file */
#define _A_HIDDEN       0x02    /* Hidden file */
#define _A_SYSTEM       0x04    /* System file */
#define _A_VOLID        0x08    /* Volume-ID entry */
#define _A_SUBDIR       0x10    /* Subdirectory */
#define _A_ARCH         0x20    /* Archive file */

/*
 *  POSIX 1003.1 Prototypes.
 */
_WCRTLINK extern DIR        *opendir( const char * );
_WCRTLINK extern struct dirent *readdir( DIR * );
_WCRTLINK extern void       rewinddir( DIR * );
_WCRTLINK extern int        closedir( DIR * );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
