/*
 *  io.h        Low level I/O routines that work with file handles
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _IO_H_INCLUDED
#define _IO_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef _SYS_TYPES_H_INCLUDED
 #include <sys/types.h>
#endif

#ifndef _SYS_STAT_H_INCLUDED
 #include <sys/stat.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 1 )

/*
 *  ISO C types
 */
/* Signed integer type able to hold pointers. */
#ifdef __cplusplus
 #ifndef _STDINTPTR_T_DEFINED
 #define _STDINTPTR_T_DEFINED
  namespace std {
  #if defined(__COMPACT__) || defined(__LARGE__)
   typedef long long intptr_t;
  #else
   typedef long intptr_t;
  #endif
  }
  typedef std::intptr_t __w_intptr_t;
 #endif
 #ifndef _INTPTR_T_DEFINED
 #define _INTPTR_T_DEFINED
  using std::intptr_t;
 #endif
#else  /* __cplusplus not defined */
 #ifndef _INTPTR_T_DEFINED
 #define _INTPTR_T_DEFINED
  #if defined(__COMPACT__) || defined(__LARGE__)
   typedef long long intptr_t;
  #else
   typedef long intptr_t;
  #endif
  typedef intptr_t  __w_intptr_t;
 #endif
#endif /* __cplusplus not defined */

#ifndef _MAX_PATH
 #define _MAX_PATH      260     /* maximum length of full pathname */
#endif

/* Symbolic constants for the access() function */

#define R_OK    4       /*  Test for read permission    */
#define W_OK    2       /*  Test for write permission   */
#define X_OK    1       /*  Test for execute permission */
#define F_OK    0       /*  Test for existence of file  */

#define ACCESS_WR       0x0002
#define ACCESS_RD       0x0004

/* Symbolic constants for the lseek() function */

#define SEEK_SET    0           /* Seek relative to the start of file   */
#define SEEK_CUR    1           /* Seek relative to current position    */
#define SEEK_END    2           /* Seek relative to the end of the file */

/* Symbolic constants for stream I/O */

#define STDIN_FILENO    0
#define STDOUT_FILENO   1
#define STDERR_FILENO   2

typedef long long       _fsize_t;

struct _finddata_t {
    unsigned    attrib;
    time_t      time_create;
    time_t      time_access;
    time_t      time_write;
    _fsize_t    size;
    char        name[_MAX_PATH];
};

/* File attribute constants for attribute field */

#define _A_NORMAL       0x00    /* Normal file - read/write permitted */
#define _A_RDONLY       0x01    /* Read-only file */
#define _A_HIDDEN       0x02    /* Hidden file */
#define _A_SYSTEM       0x04    /* System file */
#define _A_VOLID        0x08    /* Volume-ID entry */
#define _A_SUBDIR       0x10    /* Subdirectory */
#define _A_ARCH         0x20    /* Archive file */

_WCRTLINK extern ssize_t    read( int fildes, void *buf, __w_size_t nbyte );
_WCRTLINK extern ssize_t    write( int fildes, const void *buf, __w_size_t nbyte );
_WCRTLINK extern int        access( const char *__path, int __mode );
_WCRTLINK extern int        dup( int __handle );
_WCRTLINK extern int        dup2( int __handle1, int __handle2 );
_WCRTLINK extern int        close( int __fildes );
_WCRTLINK extern off_t      lseek( int __handle, off_t __offset, int __origin );
_WCRTLINK extern int        unlink( const char *__path );
_WCRTLINK extern int        isatty( int __handle );
_WCRTLINK extern int        fsync( int __handle );
_WCRTLINK extern int        chmod( const char *__path, mode_t __pmode );
_WCRTLINK extern int        locking( int __handle, int __mode, unsigned long __nbyte );
_WCRTLINK extern int        eof( int __handle );
_WCRTLINK extern long long  filelength( int __handle );
_WCRTLINK extern off_t      tell( int __handle );
_WCRTLINK extern int        chsize( int __handle, long long __size );
_WCRTLINK extern int        setmode( int __handle, int __mode );
_WCRTLINK extern int        open( const char *__path, int __oflag, ... );
_WCRTLINK extern int        creat( const char *__path, mode_t __mode );
_WCRTLINK extern int        sopen( const char *__path, int __oflag, int __share, ... );
_WCRTLINK extern mode_t     umask( mode_t __cmask );
_WCRTLINK extern int        lock( int __handle, unsigned long __offset, unsigned long __nbytes );
_WCRTLINK extern int        unlock( int __handle, unsigned long __offset, unsigned long __nbytes );

_WCRTLINK extern int        _read( int fildes, void *buf, unsigned nbyte );
_WCRTLINK extern int        _write( int fildes, const void *buf, unsigned nbyte );
_WCRTLINK extern int        _access( const char *__path, int __mode );
_WCRTLINK extern int        _dup( int __handle );
_WCRTLINK extern int        _dup2( int __handle1, int __handle2 );
_WCRTLINK extern int        _close( int __handle );
_WCRTLINK extern off_t      _lseek( int __handle, off_t __offset, int __origin );
_WCRTLINK extern int        _unlink( const char *__path );
_WCRTLINK extern int        _isatty( int __handle );
_WCRTLINK extern int        _commit( int __handle );
_WCRTLINK extern int        _pipe( int *__phandles, unsigned __psize, int __textmode );
_WCRTLINK extern long       _get_osfhandle( int __posixhandle );
_WCRTLINK extern int        _hdopen( int __handle,int __mode );
_WCRTLINK extern int        _open_osfhandle( long __osfhandle, int __flags );
_WCRTLINK extern int        _os_handle( int __handle );
_WCRTLINK extern int        _chmod( const char *__path, mode_t __pmode );
_WCRTLINK extern int        _locking( int __handle, int __mode, unsigned long __nbyte );
_WCRTLINK extern int        _eof( int __handle );
_WCRTLINK extern long long  _filelength( int __handle );
_WCRTLINK extern off_t      _tell( int __handle );
_WCRTLINK extern int        _chsize( int __handle, long long __size );
_WCRTLINK extern int        _setmode( int __handle, int __mode );
_WCRTLINK extern int        _open( const char *__path, int __oflag, ... );
_WCRTLINK extern int        _creat( const char *__path, mode_t __mode );
_WCRTLINK extern int        _sopen( const char *__path, int __oflag, int __share, ... );
_WCRTLINK extern char       *_mktemp( char *__template );
_WCRTLINK extern mode_t     _umask( mode_t __cmask );
_WCRTLINK extern __w_intptr_t _findfirst( const char *__filespec, struct _finddata_t *__fileinfo );
_WCRTLINK extern int        _findnext( __w_intptr_t __handle, struct _finddata_t *__fileinfo );
_WCRTLINK extern int        _findclose( __w_intptr_t __handle );

#pragma pack( __pop )

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
