/***************************************************************************
 * FILE: stdarg.h/cstdarg (Macros for use with variable argument lists)
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 *
 * Description: This header is part of the C/C++ standard library. It
 *              contains macros for use in variable length argument
 *              lists.
 ***************************************************************************/
#ifndef _STDARG_H_INCLUDED
#define _STDARG_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus

#include <cstdarg>

using std::va_list;

#else /* __cplusplus not defined */

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef ___VA_LIST_DEFINED
#define ___VA_LIST_DEFINED
  #if defined(__SW_ZU)
   typedef char _WCFAR *__va_list;
  #else
   typedef char    *__va_list;
  #endif
#endif

#ifndef _VA_LIST_DEFINED
#define _VA_LIST_DEFINED
  typedef __va_list va_list;
#endif

 #ifdef __SW_ZU
  #define va_start(__ap,__pn)   (__ap=(char _WCFAR*)&__pn+\
      ((sizeof(__pn)+sizeof(int)-1)&~(sizeof(int)-1)),(void)0)
  #define va_arg(__ap,__type)   (__ap+=\
      ((sizeof(__type)+sizeof(int)-1)&~(sizeof(int)-1)),\
      (*(__type _WCFAR*)(__ap-((sizeof(__type)+sizeof(int)-1)&~(sizeof(int)-1)))))
  #define va_end(__ap)          (__ap=0,(void)0)
 #else
  #define va_start(__ap,__pn)   (__ap=(char *)&__pn+\
      ((sizeof(__pn)+sizeof(int)-1)&~(sizeof(int)-1)),(void)0)
  #define va_arg(__ap,__type)   (__ap+=\
      ((sizeof(__type)+sizeof(int)-1)&~(sizeof(int)-1)),\
      (*(__type *)(__ap-((sizeof(__type)+sizeof(int)-1)&~(sizeof(int)-1)))))
  #define va_end(__ap)          (__ap=0,(void)0)
 #endif

#define __va_copy(__dest,__src)    ((__dest)=(__src),(void)0)

#if !defined( _NO_EXT_KEYS ) || __STDC_VERSION__ >= 199901L /* extensions enabled or C99 */
#define va_copy(__dest,__src)   __va_copy(__dest,__src)
#endif /* extensions enabled */

#endif /* __cplusplus not defined */

#endif
