/*
 *  sys/wait.h  POSIX Standard: Wait for Process Termination
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _SYS_WAIT_H_INCLUDED
#define _SYS_WAIT_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef _SIGNAL_H_INCLUDED
 #include <signal.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _PID_T_DEFINED_
 #define _PID_T_DEFINED_
 typedef int            pid_t;  /* Used for process IDs & group IDs */
#endif
#ifndef _ID_T_DEFINED_
 #define _ID_T_DEFINED_
 typedef long           id_t;   /* Generic ID, may be uid, gid, pid */
#endif

typedef enum {
    P_ALL,          /* Wait for any child. */
    P_PID,          /* Wait for specified process. */
    P_PGID          /* Wait for members of process group. */
} idtype_t;

/*
 * Defined system wait types
 * Bits in the third argument to `waitpid'.
 */
#define WNOHANG             1           /* Don't block waiting.  */
#define WUNTRACED           0

#define WIFEXITED(__s)      (((__s) & 0x7f) == 0)
#define WIFSIGNALED(__s)    (((__s) & 0x7f) != 0)
#define WIFSTOPPED(__s)     (0)
#define WEXITSTATUS(__s)    (((__s) >> 8) & 0xff)
#define WTERMSIG(__s)       (((__s) & 0x7f))
#define WSTOPSIG(__s)       (0)

_WCRTLINK extern pid_t      wait( int *__stat_loc );
_WCRTLINK extern pid_t      waitpid( pid_t __pid, int *__stat_loc, int __options );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* !_SYS_WAIT_H_INCLUDED */
