"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var message_handler_exports = {};
__export(message_handler_exports, {
  ConfigManagerMessageHandler: () => ConfigManagerMessageHandler
});
module.exports = __toCommonJS(message_handler_exports);
var import_error = require("../error.js");
var import_command = require("./command.js");
class ConfigManagerMessageHandler {
  driver;
  constructor(driver) {
    this.driver = driver;
  }
  async handle(message) {
    const { command } = message;
    switch (message.command) {
      case import_command.ConfigManagerCommand.lookupDevice: {
        const config = await this.driver.configManager.lookupDevice(message.manufacturerId, message.productType, message.productId, message.firmwareVersion);
        return { config };
      }
      case import_command.ConfigManagerCommand.loadManufacturers: {
        await this.driver.configManager.loadManufacturers();
        return {};
      }
      case import_command.ConfigManagerCommand.lookupManufacturer: {
        const name = this.driver.configManager.lookupManufacturer(message.manufacturerId);
        return { name };
      }
      case import_command.ConfigManagerCommand.loadDeviceIndex: {
        await this.driver.configManager.loadDeviceIndex();
        return {};
      }
      case import_command.ConfigManagerCommand.getIndex: {
        const index = this.driver.configManager.getIndex();
        return { index };
      }
      case import_command.ConfigManagerCommand.loadFulltextDeviceIndex: {
        await this.driver.configManager.loadFulltextDeviceIndex();
        return {};
      }
      case import_command.ConfigManagerCommand.getFulltextIndex: {
        const index = this.driver.configManager.getFulltextIndex();
        return { index };
      }
      case import_command.ConfigManagerCommand.lookupDevicePreserveConditions: {
        const config = await this.driver.configManager.lookupDevicePreserveConditions(message.manufacturerId, message.productType, message.productId, message.firmwareVersion);
        return { config };
      }
      case import_command.ConfigManagerCommand.manufacturers: {
        const manufacturers = this.driver.configManager.manufacturers;
        return { manufacturers };
      }
      case import_command.ConfigManagerCommand.loadAll: {
        await this.driver.configManager.loadAll();
        return {};
      }
      case import_command.ConfigManagerCommand.configVersion: {
        return { configVersion: this.driver.configManager.configVersion };
      }
      default: {
        throw new import_error.UnknownCommandError(command);
      }
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConfigManagerMessageHandler
});
//# sourceMappingURL=message_handler.js.map
