"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var message_handler_exports = {};
__export(message_handler_exports, {
  UtilsMessageHandler: () => UtilsMessageHandler
});
module.exports = __toCommonJS(message_handler_exports);
var import_zwave_js = require("zwave-js");
var import_core = require("@zwave-js/core");
var import_error = require("../error.js");
var import_command = require("./command.js");
class UtilsMessageHandler {
  async handle(message) {
    const { command } = message;
    switch (message.command) {
      case import_command.UtilsCommand.parseQRCodeString: {
        const qrProvisioningInformation = await (0, import_core.parseQRCodeString)(message.qr);
        return { qrProvisioningInformation };
      }
      case import_command.UtilsCommand.tryParseDSKFromQRCodeString: {
        const dsk = (0, import_core.tryParseDSKFromQRCodeString)(message.qr);
        return { dsk };
      }
      case import_command.UtilsCommand.num2hex: {
        const hex = (0, import_zwave_js.num2hex)(message.val, message.uppercase);
        return { hex };
      }
      case import_command.UtilsCommand.formatId: {
        const id = (0, import_zwave_js.formatId)(message.id);
        return { id };
      }
      case import_command.UtilsCommand.buffer2hex: {
        const hex = (0, import_zwave_js.buffer2hex)(message.buffer, message.uppercase);
        return { hex };
      }
      case import_command.UtilsCommand.getEnumMemberName: {
        const name = (0, import_zwave_js.getEnumMemberName)(message.enumeration, message.value);
        return { name };
      }
      case import_command.UtilsCommand.rssiToString: {
        const rssi = (0, import_zwave_js.rssiToString)(message.rssi);
        return { rssi };
      }
      default: {
        throw new import_error.UnknownCommandError(command);
      }
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  UtilsMessageHandler
});
//# sourceMappingURL=message_handler.js.map
