"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __import_meta_url = typeof document === "undefined" ? new (require("url".replace("", ""))).URL("file:" + __filename).href : document.currentScript && document.currentScript.src || new URL("main.js", document.baseURI).href;
var assert = __toESM(require("assert"), 1);
var import_node_dns = __toESM(require("node:dns"), 1);
var import_ws = __toESM(require("ws"), 1);
var import_zwave_js = require("zwave-js");
var import_server = require("../lib/server.js");
var import_mock = require("../mock/index.js");
var import_const = require("../lib/const.js");
var import_node_module = require("node:module");
const require2 = (0, import_node_module.createRequire)(__import_meta_url);
import_node_dns.default.setDefaultResultOrder("ipv4first");
const PORT = 45001;
const createNextMessage = (socket) => {
  let waitingListener;
  const pendingMessages = [];
  socket.on("message", (data) => {
    const msg = JSON.parse(data);
    if (!waitingListener) {
      pendingMessages.push(msg);
      return;
    }
    const listener = waitingListener;
    waitingListener = void 0;
    listener(msg);
  });
  return () => {
    if (pendingMessages.length) {
      return pendingMessages.splice(0, 1)[0];
    }
    return new Promise((resolve) => {
      waitingListener = resolve;
    });
  };
};
const runTest = async () => {
  const server = new import_server.ZwavejsServer((0, import_mock.createMockDriver)(), { port: PORT });
  await server.start(true);
  let socket = void 0;
  try {
    socket = new import_ws.default(`ws://localhost:${PORT}`);
    const nextMessage = createNextMessage(socket);
    await new Promise((resolve) => socket.once("open", resolve));
    assert.deepEqual(await nextMessage(), {
      driverVersion: import_zwave_js.libVersion,
      homeId: 1,
      serverVersion: require2("../../package.json").version,
      minSchemaVersion: import_const.minSchemaVersion,
      maxSchemaVersion: import_const.maxSchemaVersion,
      type: "version"
    });
    socket.send(JSON.stringify({
      command: "initialize",
      messageId: "initialize",
      schemaVersion: import_const.maxSchemaVersion
    }));
    assert.deepEqual(await nextMessage(), {
      type: "result",
      success: true,
      messageId: "initialize",
      result: {}
    });
    socket.send(JSON.stringify({
      messageId: "my-msg-id!",
      command: "start_listening"
    }));
    assert.deepEqual(await nextMessage(), {
      type: "result",
      success: true,
      messageId: "my-msg-id!",
      result: {
        state: {
          driver: {
            logConfig: { enabled: true, level: "debug" },
            statisticsEnabled: true
          },
          controller: { homeId: 1 },
          nodes: []
        }
      }
    });
    console.log("Integration tests passed :)");
  } finally {
    if (socket) {
      socket.close();
    }
    await server.destroy();
  }
};
runTest();
//# sourceMappingURL=integration.js.map
