import { ZWaveNode } from "zwave-js";
import { OutgoingEvent } from "./outgoing_message.js";
import { Client, ClientsController } from "./server.js";
export declare class EventForwarder {
    private clientsController;
    /**
     * Only load this once the driver is ready.
     *
     * @param clientsController
     */
    constructor(clientsController: ClientsController);
    start(): void;
    forwardEvent(data: OutgoingEvent, minSchemaVersion?: number): void;
    sendEvent(client: Client, data: OutgoingEvent, minSchemaVersion?: number): void;
    setupControllerAndNodes(): void;
    setupNode(node: ZWaveNode): void;
}
