import { ControllerStatus, Driver, ZWaveNode, Endpoint, TranslatedValueID, ValueMetadata, DeviceClass, CommandClass, InterviewStage, ZWaveLibraryTypes, FunctionType, ValueType, NodeStatus, DataRate, ZWavePlusNodeType, ZWavePlusRoleType, FLiRS, ProtocolVersion, Protocols, NodeType, NodeStatistics, ControllerStatistics, InclusionState, FoundNode, RebuildRoutesStatus } from "zwave-js";
import { DeviceConfig } from "@zwave-js/config";
import { CommandClasses, ConfigurationMetadata, ConfigValue, ConfigValueFormat, LogConfig, LongRangeChannel, MaybeNotKnown, RFRegion, SecurityClass, ValueChangeOptions, ValueMetadataAny, ValueMetadataBoolean, ValueMetadataBuffer, ValueMetadataDuration, ValueMetadataNumeric, ValueMetadataString } from "@zwave-js/core";
type Modify<T, R> = Omit<T, keyof R> & R;
type LogConfigState = Omit<LogConfig, "transports">;
export interface DriverState {
    logConfig: LogConfigState;
    statisticsEnabled: boolean;
}
export interface ControllerStateSchema0 {
    libraryVersion?: string;
    type?: ZWaveLibraryTypes;
    homeId?: number;
    ownNodeId?: number;
    isSecondary?: boolean;
    isUsingHomeIdFromOtherNetwork?: boolean;
    isSISPresent?: boolean;
    wasRealPrimary?: boolean;
    isStaticUpdateController?: boolean;
    isSlave?: boolean;
    serialApiVersion?: string;
    manufacturerId?: number;
    productType?: number;
    productId?: number;
    supportedFunctionTypes?: readonly FunctionType[];
    sucNodeId?: number;
    supportsTimers?: boolean;
    isHealNetworkActive: boolean;
    statistics: ControllerStatistics;
    inclusionState: InclusionState;
}
export type ControllerStateSchema16 = Omit<Modify<ControllerStateSchema0, {
    sdkVersion?: string;
    firmwareVersion?: string;
}>, "libraryVersion" | "serialApiVersion">;
export type ControllerStateSchema22 = Omit<Modify<ControllerStateSchema16, {
    isPrimary?: boolean;
    isSUC?: boolean;
    nodeType?: NodeType;
}>, "isSlave" | "isSecondary" | "isStaticUpdateController">;
export interface ControllerStateSchema25 extends ControllerStateSchema22 {
    rfRegion?: RFRegion;
}
export interface ControllerStateSchema31 extends ControllerStateSchema25 {
    status: ControllerStatus;
}
export type ControllerStateSchema32 = Omit<Modify<ControllerStateSchema31, {
    isRebuildingRoutes: boolean;
}>, "isHealNetworkActive">;
export type ControllerStateSchema34 = ControllerStateSchema32 & {
    rebuildRoutesProgress?: ReadonlyMap<number, RebuildRoutesStatus>;
};
export type ControllerStateSchema35 = ControllerStateSchema34 & {
    supportsLongRange: MaybeNotKnown<boolean>;
};
export type ControllerStateSchema36 = ControllerStateSchema35 & {
    maxLongRangePowerlevel: MaybeNotKnown<number>;
    longRangeChannel: MaybeNotKnown<LongRangeChannel>;
    supportsLongRangeAutoChannelSelection: MaybeNotKnown<boolean>;
};
export type ControllerState = ControllerStateSchema0 | ControllerStateSchema16 | ControllerStateSchema22 | ControllerStateSchema25 | ControllerStateSchema31 | ControllerStateSchema32 | ControllerStateSchema34 | ControllerStateSchema35 | ControllerStateSchema36;
export interface ZwaveState {
    driver: DriverState;
    controller: ControllerState;
    nodes: NodeState[];
}
export interface CommandClassState {
    id: number;
    name: string;
    version: number;
    isSecure: boolean;
}
export interface EndpointStateSchema0 {
    nodeId: number;
    index: number;
    installerIcon?: number;
    userIcon?: number;
}
export type EndpointStateSchema3 = Modify<EndpointStateSchema0, {
    deviceClass: DeviceClassState | null;
}>;
export type EndpointStateSchema15 = Modify<EndpointStateSchema3, {
    commandClasses: CommandClassState[];
}>;
export type EndpointStateSchema26 = Modify<EndpointStateSchema15, {
    endpointLabel?: string;
}>;
export type EndpointState = EndpointStateSchema0 | EndpointStateSchema3 | EndpointStateSchema15 | EndpointStateSchema26;
export interface DeviceClassState0 {
    basic: {
        key: number;
        label: string;
    };
    generic: {
        key: number;
        label: string;
    };
    specific: {
        key: number;
        label: string;
    };
    mandatorySupportedCCs: readonly CommandClasses[];
    mandatoryControlledCCs: readonly CommandClasses[];
}
export type DeviceClassState36 = Omit<DeviceClassState0, "mandatorySupportedCCs" | "mandatoryControlledCCs">;
export type DeviceClassState = DeviceClassState0 | DeviceClassState36;
export interface ValueState extends TranslatedValueID {
    metadata: ValueMetadata;
    ccVersion: number;
    value?: any;
}
export interface ValueMetadataStateSchema0 {
    type: ValueType;
    default?: any;
    readable: boolean;
    writeable: boolean;
    description?: string;
    label?: string;
    ccSpecific?: Record<string, any>;
    valueChangeOptions?: readonly (keyof ValueChangeOptions)[];
    min?: number;
    max?: number;
    minLength?: number;
    maxLength?: number;
    steps?: number;
    states?: Record<number, string>;
    unit?: string;
}
export interface ValueMetadataStateSchema28 extends ValueMetadataStateSchema0 {
    stateful?: boolean;
    secret?: boolean;
}
export type ValueMetadataState = ValueMetadataStateSchema0 | ValueMetadataStateSchema28;
export interface ConfigurationMetadataStateSchema0 {
    type: ValueType;
    readable: boolean;
    writeable: boolean;
    description?: string;
    label?: string;
    ccSpecific?: Record<string, any>;
    valueChangeOptions?: readonly (keyof ValueChangeOptions)[];
    min?: ConfigValue;
    max?: ConfigValue;
    default?: ConfigValue;
    unit?: string;
    valueSize?: number;
    format?: ConfigValueFormat;
    name?: string;
    info?: string;
    noBulkSupport?: boolean;
    isAdvanced?: boolean;
    requiresReInclusion?: boolean;
    states?: Record<number, string>;
    allowManualEntry?: boolean;
    isFromConfig?: boolean;
}
export type ConfigurationMetadataStateSchema29 = Omit<ConfigurationMetadataStateSchema0, "name" | "info">;
export type ConfigurationMetadataState = ConfigurationMetadataStateSchema0 | ConfigurationMetadataStateSchema29;
export interface NodeStateSchema0 extends EndpointStateSchema0 {
    status: NodeStatus;
    ready: boolean;
    isListening?: boolean;
    isFrequentListening: boolean | null;
    isRouting?: boolean;
    maxBaudRate?: DataRate;
    isSecure?: MaybeNotKnown<boolean>;
    version: number | null;
    isBeaming?: boolean;
    manufacturerId?: number;
    productId?: number;
    productType?: number;
    firmwareVersion?: string;
    zwavePlusVersion?: number;
    nodeType?: ZWavePlusNodeType;
    roleType?: ZWavePlusRoleType;
    name?: string;
    location?: string;
    deviceConfig?: DeviceConfig;
    label?: string;
    endpointCountIsDynamic?: boolean;
    endpointsHaveIdenticalCapabilities?: boolean;
    individualEndpointCount?: number;
    aggregatedEndpointCount?: number;
    interviewAttempts: number;
    interviewStage: InterviewStage;
    deviceClass: DeviceClass | null;
    endpoints: EndpointState[];
    values: ValueState[];
}
export type NodeStateSchema1 = Modify<NodeStateSchema0, {
    deviceClass: DeviceClassState | null;
    commandClasses: CommandClassState[];
}>;
export type NodeStateSchema3 = Omit<Modify<NodeStateSchema1, {
    isFrequentListening?: FLiRS;
    maxDataRate?: DataRate;
    supportedDataRates?: readonly DataRate[];
    protocolVersion?: ProtocolVersion;
    supportsBeaming?: boolean;
    supportsSecurity?: boolean;
    zwavePlusNodeType?: ZWavePlusNodeType;
    zwavePlusRoleType?: ZWavePlusRoleType;
    nodeType?: NodeType;
}>, "maxBaudRate" | "version" | "isBeaming" | "roleType">;
export type NodeStateSchema4 = Modify<NodeStateSchema3, {
    interviewStage?: string;
}>;
export interface NodeStateSchema5 extends NodeStateSchema4 {
    deviceDatabaseUrl?: string;
}
export interface NodeStateSchema7 extends NodeStateSchema5 {
    statistics: NodeStatistics;
}
export interface NodeStateSchema10 extends NodeStateSchema7 {
    highestSecurityClass: SecurityClass | undefined;
}
export interface NodeStateSchema14 extends NodeStateSchema10 {
    isControllerNode: boolean;
    keepAwake: boolean;
}
export type NodeStateSchema29 = Omit<NodeStateSchema14, "commandClasses">;
export interface NodeStateSchema30 extends NodeStateSchema29 {
    lastSeen: MaybeNotKnown<Date>;
}
export interface NodeStateSchema31 extends NodeStateSchema30 {
    defaultVolume?: number;
    defaultTransitionDuration?: string;
}
export interface NodeStateSchema35 extends NodeStateSchema31 {
    protocol: Protocols;
}
export interface NodeStateSchema42 extends NodeStateSchema35 {
    sdkVersion?: string;
}
export type NodeState = NodeStateSchema0 | NodeStateSchema1 | NodeStateSchema3 | NodeStateSchema4 | NodeStateSchema5 | NodeStateSchema7 | NodeStateSchema10 | NodeStateSchema14 | NodeStateSchema29 | NodeStateSchema30 | NodeStateSchema31 | NodeStateSchema35 | NodeStateSchema42;
export interface FoundNodeStateSchema19 {
    nodeId: number;
    deviceClass: DeviceClassState | null;
    status: NodeStatus;
}
export type FoundNodeStateSchema22 = Omit<FoundNodeStateSchema19, "status">;
export type FoundNodeStateSchema23 = Modify<FoundNodeStateSchema22, {
    supportedCCs?: CommandClasses[];
    controlledCCs?: CommandClasses[];
}>;
export type FoundNodeState = FoundNodeStateSchema19 | FoundNodeStateSchema22 | FoundNodeStateSchema23;
export declare function getNodeValues(node: ZWaveNode, schemaVersion: number): ValueState[];
export declare const dumpValue: (node: ZWaveNode, valueArgs: TranslatedValueID, schemaVersion: number) => ValueState;
export declare const dumpConfigurationMetadata: (metadata: ConfigurationMetadata, schemaVersion: number) => ConfigurationMetadataState;
export declare const dumpMetadata: (metadata: ValueMetadataAny | ValueMetadataBoolean | ValueMetadataBuffer | ValueMetadataDuration | ValueMetadataNumeric | ValueMetadataString, schemaVersion: number) => ValueMetadataState;
export declare const dumpNode: (node: ZWaveNode, schemaVersion: number) => NodeState;
export declare const dumpFoundNode: (foundNode: FoundNode, schemaVersion: number) => FoundNodeState;
export declare const dumpEndpoint: (endpoint: Endpoint, schemaVersion: number) => EndpointState;
export declare const dumpDeviceClass: (deviceClass: DeviceClass, schemaVersion: number) => DeviceClassState;
export declare const dumpCommandClass: (endpoint: Endpoint, commandClass: CommandClass) => CommandClassState;
export declare const dumpLogConfig: (driver: Driver, schemaVersion: number) => LogConfigState;
export declare const dumpDriver: (driver: Driver, schemaVersion: number) => DriverState;
export declare const dumpController: (driver: Driver, schemaVersion: number) => ControllerState;
export declare const dumpState: (driver: Driver, schemaVersion: number) => ZwaveState;
export {};
