"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Signal = void 0;
const deferred_promise_1 = require("alcalzone-shared/deferred-promise");
/** Can be used to asynchronously signal a single listener */
class Signal {
    constructor() {
        this._status = false;
    }
    get isSet() {
        return this._status;
    }
    set() {
        if (this._status)
            return;
        this._status = true;
        if (this._listener) {
            this._listener.resolve(undefined);
        }
    }
    reset() {
        this._status = false;
        this._listener = undefined;
    }
    then(onfulfilled) {
        if (this._status) {
            return Promise.resolve(onfulfilled());
        }
        else {
            const p = (0, deferred_promise_1.createDeferredPromise)();
            this._listener = p;
            return p.then(onfulfilled);
        }
    }
}
exports.Signal = Signal;
//# sourceMappingURL=signal.js.map