"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BasicCC_exports = {};
__export(BasicCC_exports, {
  BasicCC: () => BasicCC,
  BasicCCAPI: () => BasicCCAPI,
  BasicCCGet: () => BasicCCGet,
  BasicCCReport: () => BasicCCReport,
  BasicCCSet: () => BasicCCSet,
  BasicCCValues: () => import_CCValues_generated.BasicCCValues
});
module.exports = __toCommonJS(BasicCC_exports);
var __validateArgs = __toESM(require("./BasicCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_BasicCCAPI_set } = __validateArgs;
let BasicCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Basic)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  var BasicCCAPI2 = class extends _classSuper {
    static {
      __name(this, "BasicCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_BasicCCAPI_set()];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BasicCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.BasicCommand.Get:
          return this.isSinglecast();
        case import_Types.BasicCommand.Set:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property }, value) {
        if (property === "restorePrevious") {
          property = "targetValue";
          value = 255;
        }
        if (property !== "targetValue") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (typeof value !== "number") {
          (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
        }
        return this.set(value);
      };
    }
    [import_API.SET_VALUE_HOOKS] = (__runInitializers(this, _instanceExtraInitializers), ({ property }, value, _options) => {
      if (property === "restorePrevious") {
        property = "targetValue";
        value = 255;
      }
      if (property === "targetValue") {
        const currentValueValueId = import_CCValues_generated.BasicCCValues.currentValue.endpoint(this.endpoint.index);
        return {
          optimisticallyUpdateRelatedValues: /* @__PURE__ */ __name((_supervisedAndSuccessful) => {
            if (typeof value === "number" && value >= 0 && value <= 99) {
              if (this.isSinglecast()) {
                this.tryGetValueDB()?.setValue(currentValueValueId, value);
              } else if (this.isMulticast()) {
                const affectedNodes = this.endpoint.node.physicalNodes.filter((node) => node.getEndpoint(this.endpoint.index)?.supportsCC(this.ccId));
                for (const node of affectedNodes) {
                  this.host.tryGetValueDB(node.id)?.setValue(currentValueValueId, value);
                }
              }
            }
          }, "optimisticallyUpdateRelatedValues"),
          forceVerifyChanges: /* @__PURE__ */ __name(() => {
            return value === 255;
          }, "forceVerifyChanges"),
          verifyChanges: /* @__PURE__ */ __name(() => {
            if (this.isSinglecast() || this.isMulticast() && value === 255) {
              this.schedulePoll(currentValueValueId, value === 255 ? void 0 : value);
            }
          }, "verifyChanges")
        };
      }
    });
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "currentValue":
          case "targetValue":
          case "duration":
            return (await this.get())?.[property];
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.BasicCommand, import_Types.BasicCommand.Get);
      const cc = new BasicCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        this.tryGetValueDB()?.setValue(import_CCValues_generated.BasicCCValues.currentValue.endpoint(this.endpoint.index), response.currentValue);
        return (0, import_shared.pick)(response, ["currentValue", "targetValue", "duration"]);
      }
    }
    async set(targetValue) {
      this.assertSupportsCommand(import_Types.BasicCommand, import_Types.BasicCommand.Set);
      const cc = new BasicCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        targetValue
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
  };
  return BasicCCAPI2 = _classThis;
})();
let BasicCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Basic), (0, import_CommandClassDecorators.implementedVersion)(2), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.BasicCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var BasicCC2 = class extends _classSuper {
    static {
      __name(this, "BasicCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BasicCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      endpoint.addCC(import_core.CommandClasses.Basic, { isSupported: true });
      await this.refreshValues(ctx);
      if (this.getValue(ctx, import_CCValues_generated.BasicCCValues.currentValue) == void 0) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "No response to Basic Get command, assuming Basic CC is unsupported..."
        });
        endpoint.addCC(import_core.CommandClasses.Basic, { isSupported: false });
        if (!endpoint.controlsCC(import_core.CommandClasses.Basic)) {
          endpoint.removeCC(import_core.CommandClasses.Basic);
        }
      }
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Basic, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying Basic CC state...",
        direction: "outbound"
      });
      const basicResponse = await api.get();
      if (basicResponse) {
        let logMessage = `received Basic CC state:
current value:      ${basicResponse.currentValue}`;
        if (basicResponse.targetValue != void 0) {
          logMessage += `
target value:       ${basicResponse.targetValue}
remaining duration: ${basicResponse.duration?.toString() ?? "undefined"}`;
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      }
    }
    getDefinedValueIDs(ctx) {
      const ret = [];
      const endpoint = this.getEndpoint(ctx);
      const compat = ctx.getDeviceConfig?.(endpoint.nodeId)?.compat;
      if (compat?.mapBasicSet === "event") {
        ret.push(import_CCValues_generated.BasicCCValues.compatEvent.endpoint(endpoint.index));
      }
      if (endpoint.supportsCC(this.ccId)) {
        ret.push(...super.getDefinedValueIDs(ctx));
      } else if (endpoint.controlsCC(import_core.CommandClasses.Basic)) {
        ret.push(import_CCValues_generated.BasicCCValues.currentValue.endpoint(endpoint.index));
      }
      return ret;
    }
  };
  return BasicCC2 = _classThis;
})();
let BasicCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BasicCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BasicCC;
  var BasicCCSet2 = class extends _classSuper {
    static {
      __name(this, "BasicCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BasicCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.targetValue = options.targetValue;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const targetValue = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        targetValue
      });
    }
    targetValue;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.targetValue]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "target value": this.targetValue }
      };
    }
  };
  return BasicCCSet2 = _classThis;
})();
let BasicCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BasicCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("currentValue", import_CCValues_generated.BasicCCValues.currentValue), (0, import_CommandClassDecorators.ccValueProperty)("targetValue", import_CCValues_generated.BasicCCValues.targetValue), (0, import_CommandClassDecorators.ccValueProperty)("duration", import_CCValues_generated.BasicCCValues.duration)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BasicCC;
  var BasicCCReport2 = class extends _classSuper {
    static {
      __name(this, "BasicCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BasicCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    // @noCCValues See comment in the constructor
    constructor(options) {
      super(options);
      this.currentValue = options.currentValue;
      this.targetValue = options.targetValue;
      this.duration = options.duration;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const currentValue = (
        // 0xff is a legacy value for 100% (99)
        raw.payload[0] === 255 ? 99 : (0, import_core.parseMaybeNumber)(raw.payload[0])
      );
      (0, import_core.validatePayload)(currentValue !== void 0);
      let targetValue;
      let duration;
      if (raw.payload.length >= 3) {
        targetValue = (0, import_core.parseMaybeNumber)(raw.payload[1]);
        duration = import_core.Duration.parseReport(raw.payload[2]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        currentValue,
        targetValue,
        duration
      });
    }
    currentValue;
    targetValue;
    duration;
    persistValues(ctx) {
      const definedValueIDs = this.getDefinedValueIDs(ctx);
      const shouldPersistCurrentValue = definedValueIDs.some((vid) => import_CCValues_generated.BasicCCValues.currentValue.is(vid));
      const shouldPersistTargetValue = definedValueIDs.some((vid) => import_CCValues_generated.BasicCCValues.targetValue.is(vid));
      const shouldPersistDuration = definedValueIDs.some((vid) => import_CCValues_generated.BasicCCValues.duration.is(vid));
      if (this.currentValue !== void 0 && shouldPersistCurrentValue) {
        this.setValue(ctx, import_CCValues_generated.BasicCCValues.currentValue, this.currentValue);
      }
      if (this.targetValue !== void 0 && shouldPersistTargetValue) {
        this.setValue(ctx, import_CCValues_generated.BasicCCValues.targetValue, this.targetValue);
      }
      if (this.duration !== void 0 && shouldPersistDuration) {
        this.setValue(ctx, import_CCValues_generated.BasicCCValues.duration, this.duration);
      }
      return true;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.currentValue ?? 254,
        this.targetValue ?? 254,
        (this.duration ?? import_core.Duration.unknown()).serializeReport()
      ]);
      const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
      if (ccVersion < 2 && ctx.getDeviceConfig?.(this.nodeId)?.compat?.encodeCCsUsingTargetVersion) {
        this.payload = this.payload.subarray(0, 1);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "current value": (0, import_core.maybeUnknownToString)(this.currentValue)
      };
      if (this.targetValue !== void 0) {
        message["target value"] = (0, import_core.maybeUnknownToString)(this.targetValue);
      }
      if (this.duration != void 0) {
        message.duration = this.duration.toString();
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return BasicCCReport2 = _classThis;
})();
let BasicCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BasicCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(BasicCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BasicCC;
  var BasicCCGet2 = class extends _classSuper {
    static {
      __name(this, "BasicCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BasicCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return BasicCCGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BasicCC,
  BasicCCAPI,
  BasicCCGet,
  BasicCCReport,
  BasicCCSet,
  BasicCCValues
});
//# sourceMappingURL=BasicCC.js.map
