"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var PowerlevelCC_exports = {};
__export(PowerlevelCC_exports, {
  PowerlevelCC: () => PowerlevelCC,
  PowerlevelCCAPI: () => PowerlevelCCAPI,
  PowerlevelCCGet: () => PowerlevelCCGet,
  PowerlevelCCReport: () => PowerlevelCCReport,
  PowerlevelCCSet: () => PowerlevelCCSet,
  PowerlevelCCTestNodeGet: () => PowerlevelCCTestNodeGet,
  PowerlevelCCTestNodeReport: () => PowerlevelCCTestNodeReport,
  PowerlevelCCTestNodeSet: () => PowerlevelCCTestNodeSet
});
module.exports = __toCommonJS(PowerlevelCC_exports);
var __validateArgs = __toESM(require("./PowerlevelCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_PowerlevelCCAPI_setCustomPowerlevel, validateArgs_PowerlevelCCAPI_reportPowerlevel, validateArgs_PowerlevelCCAPI_startNodeTest, validateArgs_PowerlevelCCAPI_sendNodeTestReport } = __validateArgs;
let PowerlevelCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Powerlevel)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _setCustomPowerlevel_decorators;
  let _reportPowerlevel_decorators;
  let _startNodeTest_decorators;
  let _sendNodeTestReport_decorators;
  var PowerlevelCCAPI2 = class extends _classSuper {
    static {
      __name(this, "PowerlevelCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _setCustomPowerlevel_decorators = [validateArgs_PowerlevelCCAPI_setCustomPowerlevel({ strictEnums: true })];
      _reportPowerlevel_decorators = [validateArgs_PowerlevelCCAPI_reportPowerlevel()];
      _startNodeTest_decorators = [validateArgs_PowerlevelCCAPI_startNodeTest({ strictEnums: true })];
      _sendNodeTestReport_decorators = [validateArgs_PowerlevelCCAPI_sendNodeTestReport()];
      __esDecorate(this, null, _setCustomPowerlevel_decorators, { kind: "method", name: "setCustomPowerlevel", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setCustomPowerlevel" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setCustomPowerlevel, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reportPowerlevel_decorators, { kind: "method", name: "reportPowerlevel", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportPowerlevel" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportPowerlevel, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _startNodeTest_decorators, { kind: "method", name: "startNodeTest", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "startNodeTest" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.startNodeTest, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _sendNodeTestReport_decorators, { kind: "method", name: "sendNodeTestReport", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendNodeTestReport" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendNodeTestReport, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      PowerlevelCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.PowerlevelCommand.Get:
        case import_Types.PowerlevelCommand.Report:
        case import_Types.PowerlevelCommand.TestNodeGet:
        case import_Types.PowerlevelCommand.TestNodeReport:
          return this.isSinglecast();
        case import_Types.PowerlevelCommand.Set:
        case import_Types.PowerlevelCommand.TestNodeSet:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    async setNormalPowerlevel() {
      this.assertSupportsCommand(import_Types.PowerlevelCommand, import_Types.PowerlevelCommand.Set);
      const cc = new PowerlevelCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        powerlevel: import_Types.Powerlevel["Normal Power"]
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async setCustomPowerlevel(powerlevel, timeout) {
      this.assertSupportsCommand(import_Types.PowerlevelCommand, import_Types.PowerlevelCommand.Set);
      const cc = new PowerlevelCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        powerlevel,
        timeout
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getPowerlevel() {
      this.assertSupportsCommand(import_Types.PowerlevelCommand, import_Types.PowerlevelCommand.Get);
      const cc = new PowerlevelCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["powerlevel", "timeout"]);
      }
    }
    async reportPowerlevel(options) {
      this.assertSupportsCommand(import_Types.PowerlevelCommand, import_Types.PowerlevelCommand.Report);
      const cc = new PowerlevelCCReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async startNodeTest(testNodeId, powerlevel, testFrameCount) {
      this.assertSupportsCommand(import_Types.PowerlevelCommand, import_Types.PowerlevelCommand.TestNodeSet);
      if (testNodeId === this.endpoint.nodeId) {
        throw new import_core.ZWaveError(`For a powerlevel test, the test node ID must different from the source node ID.`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const testNode = this.host.getNodeOrThrow(testNodeId);
      if (testNode.isFrequentListening) {
        throw new import_core.ZWaveError(`Node ${testNodeId} is FLiRS and therefore cannot be used for a powerlevel test.`, import_core.ZWaveErrorCodes.PowerlevelCC_UnsupportedTestNode);
      }
      if (testNode.canSleep && testNode.status !== import_core.NodeStatus.Awake) {
        throw new import_core.ZWaveError(`Node ${testNodeId} is not awake and therefore cannot be used for a powerlevel test.`, import_core.ZWaveErrorCodes.PowerlevelCC_UnsupportedTestNode);
      }
      const cc = new PowerlevelCCTestNodeSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        testNodeId,
        powerlevel,
        testFrameCount
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getNodeTestStatus() {
      this.assertSupportsCommand(import_Types.PowerlevelCommand, import_Types.PowerlevelCommand.TestNodeGet);
      const cc = new PowerlevelCCTestNodeGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "testNodeId",
          "status",
          "acknowledgedFrames"
        ]);
      }
    }
    async sendNodeTestReport(options) {
      this.assertSupportsCommand(import_Types.PowerlevelCommand, import_Types.PowerlevelCommand.TestNodeReport);
      const cc = new PowerlevelCCTestNodeReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return PowerlevelCCAPI2 = _classThis;
})();
let PowerlevelCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Powerlevel), (0, import_CommandClassDecorators.implementedVersion)(1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var PowerlevelCC2 = class extends _classSuper {
    static {
      __name(this, "PowerlevelCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      PowerlevelCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return PowerlevelCC2 = _classThis;
})();
let PowerlevelCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.PowerlevelCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = PowerlevelCC;
  var PowerlevelCCSet2 = class extends _classSuper {
    static {
      __name(this, "PowerlevelCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      PowerlevelCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.powerlevel = options.powerlevel;
      if (options.powerlevel !== import_Types.Powerlevel["Normal Power"]) {
        if (options.timeout < 1 || options.timeout > 255) {
          throw new import_core.ZWaveError(`The timeout parameter must be between 1 and 255.`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        this.timeout = options.timeout;
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const powerlevel = raw.payload[0];
      if (powerlevel === import_Types.Powerlevel["Normal Power"]) {
        return new this({
          nodeId: ctx.sourceNodeId,
          powerlevel
        });
      } else {
        (0, import_core.validatePayload)(raw.payload.length >= 2);
        const timeout = raw.payload[1];
        return new this({
          nodeId: ctx.sourceNodeId,
          powerlevel,
          timeout
        });
      }
    }
    powerlevel;
    timeout;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.powerlevel, this.timeout ?? 0]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "power level": (0, import_shared.getEnumMemberName)(import_Types.Powerlevel, this.powerlevel)
      };
      if (this.timeout != void 0) {
        message.timeout = `${this.timeout} s`;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return PowerlevelCCSet2 = _classThis;
})();
let PowerlevelCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.PowerlevelCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = PowerlevelCC;
  var PowerlevelCCReport2 = class extends _classSuper {
    static {
      __name(this, "PowerlevelCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      PowerlevelCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.powerlevel = options.powerlevel;
      this.timeout = options.timeout;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const powerlevel = raw.payload[0];
      if (powerlevel === import_Types.Powerlevel["Normal Power"]) {
        return new this({
          nodeId: ctx.sourceNodeId,
          powerlevel
        });
      } else {
        (0, import_core.validatePayload)(raw.payload.length >= 2);
        const timeout = raw.payload[1];
        return new this({
          nodeId: ctx.sourceNodeId,
          powerlevel,
          timeout
        });
      }
    }
    powerlevel;
    timeout;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.powerlevel, this.timeout ?? 0]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "power level": (0, import_shared.getEnumMemberName)(import_Types.Powerlevel, this.powerlevel)
      };
      if (this.timeout != void 0) {
        message.timeout = `${this.timeout} s`;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return PowerlevelCCReport2 = _classThis;
})();
let PowerlevelCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.PowerlevelCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(PowerlevelCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = PowerlevelCC;
  var PowerlevelCCGet2 = class extends _classSuper {
    static {
      __name(this, "PowerlevelCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      PowerlevelCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return PowerlevelCCGet2 = _classThis;
})();
let PowerlevelCCTestNodeSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.PowerlevelCommand.TestNodeSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = PowerlevelCC;
  var PowerlevelCCTestNodeSet2 = class extends _classSuper {
    static {
      __name(this, "PowerlevelCCTestNodeSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      PowerlevelCCTestNodeSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.testNodeId = options.testNodeId;
      this.powerlevel = options.powerlevel;
      this.testFrameCount = options.testFrameCount;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const testNodeId = raw.payload[0];
      const powerlevel = raw.payload[1];
      const testFrameCount = raw.payload.readUInt16BE(2);
      return new this({
        nodeId: ctx.sourceNodeId,
        testNodeId,
        powerlevel,
        testFrameCount
      });
    }
    testNodeId;
    powerlevel;
    testFrameCount;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.testNodeId, this.powerlevel, 0, 0]);
      this.payload.writeUInt16BE(this.testFrameCount, 2);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "test node id": this.testNodeId,
          "power level": (0, import_shared.getEnumMemberName)(import_Types.Powerlevel, this.powerlevel),
          "test frame count": this.testFrameCount
        }
      };
    }
  };
  return PowerlevelCCTestNodeSet2 = _classThis;
})();
let PowerlevelCCTestNodeReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.PowerlevelCommand.TestNodeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = PowerlevelCC;
  var PowerlevelCCTestNodeReport2 = class extends _classSuper {
    static {
      __name(this, "PowerlevelCCTestNodeReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      PowerlevelCCTestNodeReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.testNodeId = options.testNodeId;
      this.status = options.status;
      this.acknowledgedFrames = options.acknowledgedFrames;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const testNodeId = raw.payload[0];
      const status = raw.payload[1];
      const acknowledgedFrames = raw.payload.readUInt16BE(2);
      return new this({
        nodeId: ctx.sourceNodeId,
        testNodeId,
        status,
        acknowledgedFrames
      });
    }
    testNodeId;
    status;
    acknowledgedFrames;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.testNodeId,
        this.status,
        // Placeholder for acknowledged frames
        0,
        0
      ]);
      this.payload.writeUInt16BE(this.acknowledgedFrames, 2);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "test node id": this.testNodeId,
          status: (0, import_shared.getEnumMemberName)(import_Types.PowerlevelTestStatus, this.status),
          "acknowledged frames": this.acknowledgedFrames
        }
      };
    }
  };
  return PowerlevelCCTestNodeReport2 = _classThis;
})();
let PowerlevelCCTestNodeGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.PowerlevelCommand.TestNodeGet), (0, import_CommandClassDecorators.expectedCCResponse)(PowerlevelCCTestNodeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = PowerlevelCC;
  var PowerlevelCCTestNodeGet2 = class extends _classSuper {
    static {
      __name(this, "PowerlevelCCTestNodeGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      PowerlevelCCTestNodeGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return PowerlevelCCTestNodeGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  PowerlevelCC,
  PowerlevelCCAPI,
  PowerlevelCCGet,
  PowerlevelCCReport,
  PowerlevelCCSet,
  PowerlevelCCTestNodeGet,
  PowerlevelCCTestNodeReport,
  PowerlevelCCTestNodeSet
});
//# sourceMappingURL=PowerlevelCC.js.map
