"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZWavePlusCC_exports = {};
__export(ZWavePlusCC_exports, {
  ZWavePlusCC: () => ZWavePlusCC,
  ZWavePlusCCAPI: () => ZWavePlusCCAPI,
  ZWavePlusCCGet: () => ZWavePlusCCGet,
  ZWavePlusCCReport: () => ZWavePlusCCReport,
  ZWavePlusCCValues: () => import_CCValues_generated.ZWavePlusCCValues
});
module.exports = __toCommonJS(ZWavePlusCC_exports);
var __validateArgs = __toESM(require("./ZWavePlusCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ZWavePlusCCAPI_sendReport } = __validateArgs;
let ZWavePlusCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Z-Wave Plus Info"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _sendReport_decorators;
  var ZWavePlusCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ZWavePlusCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _sendReport_decorators = [validateArgs_ZWavePlusCCAPI_sendReport()];
      __esDecorate(this, null, _sendReport_decorators, { kind: "method", name: "sendReport", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "sendReport" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.sendReport, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWavePlusCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ZWavePlusCommand.Get:
        case import_Types.ZWavePlusCommand.Report:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.ZWavePlusCommand, import_Types.ZWavePlusCommand.Get);
      const cc = new ZWavePlusCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "zwavePlusVersion",
          "nodeType",
          "roleType",
          "installerIcon",
          "userIcon"
        ]);
      }
    }
    async sendReport(options) {
      this.assertSupportsCommand(import_Types.ZWavePlusCommand, import_Types.ZWavePlusCommand.Report);
      const cc = new ZWavePlusCCReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ZWavePlusCCAPI2 = _classThis;
})();
let ZWavePlusCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Z-Wave Plus Info"]), (0, import_CommandClassDecorators.implementedVersion)(2), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.ZWavePlusCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ZWavePlusCC2 = class extends _classSuper {
    static {
      __name(this, "ZWavePlusCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWavePlusCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Z-Wave Plus Info"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying Z-Wave+ information...",
        direction: "outbound"
      });
      const zwavePlusResponse = await api.get();
      if (zwavePlusResponse) {
        const logMessage = `received response for Z-Wave+ information:
Z-Wave+ version: ${zwavePlusResponse.zwavePlusVersion}
role type:       ${import_Types.ZWavePlusRoleType[zwavePlusResponse.roleType]}
node type:       ${import_Types.ZWavePlusNodeType[zwavePlusResponse.nodeType]}
installer icon:  ${(0, import_shared.num2hex)(zwavePlusResponse.installerIcon)}
user icon:       ${(0, import_shared.num2hex)(zwavePlusResponse.userIcon)}`;
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      }
      this.setInterviewComplete(ctx, true);
    }
  };
  return ZWavePlusCC2 = _classThis;
})();
let ZWavePlusCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWavePlusCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("zwavePlusVersion", import_CCValues_generated.ZWavePlusCCValues.zwavePlusVersion), (0, import_CommandClassDecorators.ccValueProperty)("nodeType", import_CCValues_generated.ZWavePlusCCValues.nodeType), (0, import_CommandClassDecorators.ccValueProperty)("roleType", import_CCValues_generated.ZWavePlusCCValues.roleType), (0, import_CommandClassDecorators.ccValueProperty)("installerIcon", import_CCValues_generated.ZWavePlusCCValues.installerIcon), (0, import_CommandClassDecorators.ccValueProperty)("userIcon", import_CCValues_generated.ZWavePlusCCValues.userIcon)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWavePlusCC;
  var ZWavePlusCCReport2 = class extends _classSuper {
    static {
      __name(this, "ZWavePlusCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWavePlusCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.zwavePlusVersion = options.zwavePlusVersion;
      this.roleType = options.roleType;
      this.nodeType = options.nodeType;
      this.installerIcon = options.installerIcon;
      this.userIcon = options.userIcon;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 7);
      const zwavePlusVersion = raw.payload[0];
      const roleType = raw.payload[1];
      const nodeType = raw.payload[2];
      const installerIcon = raw.payload.readUInt16BE(3);
      const userIcon = raw.payload.readUInt16BE(5);
      return new this({
        nodeId: ctx.sourceNodeId,
        zwavePlusVersion,
        roleType,
        nodeType,
        installerIcon,
        userIcon
      });
    }
    zwavePlusVersion;
    nodeType;
    roleType;
    installerIcon;
    userIcon;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.zwavePlusVersion,
        this.roleType,
        this.nodeType,
        // placeholder for icons
        0,
        0,
        0,
        0
      ]);
      this.payload.writeUInt16BE(this.installerIcon, 3);
      this.payload.writeUInt16BE(this.userIcon, 5);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          version: this.zwavePlusVersion,
          "node type": (0, import_shared.getEnumMemberName)(import_Types.ZWavePlusNodeType, this.nodeType),
          "role type": (0, import_shared.getEnumMemberName)(import_Types.ZWavePlusRoleType, this.roleType),
          "icon (mgmt.)": (0, import_shared.num2hex)(this.installerIcon),
          "icon (user)": (0, import_shared.num2hex)(this.userIcon)
        }
      };
    }
  };
  return ZWavePlusCCReport2 = _classThis;
})();
let ZWavePlusCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWavePlusCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ZWavePlusCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWavePlusCC;
  var ZWavePlusCCGet2 = class extends _classSuper {
    static {
      __name(this, "ZWavePlusCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWavePlusCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ZWavePlusCCGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZWavePlusCC,
  ZWavePlusCCAPI,
  ZWavePlusCCGet,
  ZWavePlusCCReport,
  ZWavePlusCCValues
});
//# sourceMappingURL=ZWavePlusCC.js.map
