"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CCValues_generated_exports = {};
__export(CCValues_generated_exports, {
  AlarmSensorCCValues: () => AlarmSensorCCValues,
  AssociationCCValues: () => AssociationCCValues,
  AssociationGroupInfoCCValues: () => AssociationGroupInfoCCValues,
  BarrierOperatorCCValues: () => BarrierOperatorCCValues,
  BasicCCValues: () => BasicCCValues,
  BasicWindowCoveringCCValues: () => BasicWindowCoveringCCValues,
  BatteryCCValues: () => BatteryCCValues,
  BinarySensorCCValues: () => BinarySensorCCValues,
  BinarySwitchCCValues: () => BinarySwitchCCValues,
  CCValues: () => CCValues,
  CentralSceneCCValues: () => CentralSceneCCValues,
  ClimateControlScheduleCCValues: () => ClimateControlScheduleCCValues,
  ColorSwitchCCValues: () => ColorSwitchCCValues,
  ConfigurationCCValues: () => ConfigurationCCValues,
  DoorLockCCValues: () => DoorLockCCValues,
  DoorLockLoggingCCValues: () => DoorLockLoggingCCValues,
  EnergyProductionCCValues: () => EnergyProductionCCValues,
  EntryControlCCValues: () => EntryControlCCValues,
  FirmwareUpdateMetaDataCCValues: () => FirmwareUpdateMetaDataCCValues,
  HumidityControlModeCCValues: () => HumidityControlModeCCValues,
  HumidityControlOperatingStateCCValues: () => HumidityControlOperatingStateCCValues,
  HumidityControlSetpointCCValues: () => HumidityControlSetpointCCValues,
  IndicatorCCValues: () => IndicatorCCValues,
  IrrigationCCValues: () => IrrigationCCValues,
  LanguageCCValues: () => LanguageCCValues,
  LockCCValues: () => LockCCValues,
  ManufacturerSpecificCCValues: () => ManufacturerSpecificCCValues,
  MeterCCValues: () => MeterCCValues,
  MultiChannelAssociationCCValues: () => MultiChannelAssociationCCValues,
  MultiChannelCCValues: () => MultiChannelCCValues,
  MultilevelSensorCCValues: () => MultilevelSensorCCValues,
  MultilevelSwitchCCValues: () => MultilevelSwitchCCValues,
  NodeNamingAndLocationCCValues: () => NodeNamingAndLocationCCValues,
  NotificationCCValues: () => NotificationCCValues,
  ProtectionCCValues: () => ProtectionCCValues,
  SceneActivationCCValues: () => SceneActivationCCValues,
  SceneActuatorConfigurationCCValues: () => SceneActuatorConfigurationCCValues,
  SceneControllerConfigurationCCValues: () => SceneControllerConfigurationCCValues,
  ScheduleEntryLockCCValues: () => ScheduleEntryLockCCValues,
  SoundSwitchCCValues: () => SoundSwitchCCValues,
  SupervisionCCValues: () => SupervisionCCValues,
  ThermostatFanModeCCValues: () => ThermostatFanModeCCValues,
  ThermostatFanStateCCValues: () => ThermostatFanStateCCValues,
  ThermostatModeCCValues: () => ThermostatModeCCValues,
  ThermostatOperatingStateCCValues: () => ThermostatOperatingStateCCValues,
  ThermostatSetpointCCValues: () => ThermostatSetpointCCValues,
  TimeParametersCCValues: () => TimeParametersCCValues,
  UserCodeCCValues: () => UserCodeCCValues,
  VersionCCValues: () => VersionCCValues,
  WakeUpCCValues: () => WakeUpCCValues,
  WindowCoveringCCValues: () => WindowCoveringCCValues,
  ZWavePlusCCValues: () => ZWavePlusCCValues
});
module.exports = __toCommonJS(CCValues_generated_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_CCValueUtils = require("../lib/CCValueUtils.js");
var import_Types = require("../lib/_Types.js");
const AlarmSensorCCValues = Object.freeze({
  state: Object.assign((sensorType) => {
    const property = "state";
    const propertyKey = sensorType;
    return {
      id: {
        commandClass: import_core.CommandClasses["Alarm Sensor"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Alarm Sensor"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        const alarmName = (0, import_shared.getEnumMemberName)(import_Types.AlarmSensorType, sensorType);
        return {
          ...import_core.ValueMetadata.ReadOnlyBoolean,
          label: `${alarmName} state`,
          description: "Whether the alarm is active",
          ccSpecific: { sensorType }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Alarm Sensor"] && (({ property, propertyKey }) => property === "state" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  severity: Object.assign((sensorType) => {
    const property = "severity";
    const propertyKey = sensorType;
    return {
      id: {
        commandClass: import_core.CommandClasses["Alarm Sensor"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Alarm Sensor"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        const alarmName = (0, import_shared.getEnumMemberName)(import_Types.AlarmSensorType, sensorType);
        return {
          ...import_core.ValueMetadata.ReadOnlyNumber,
          min: 1,
          max: 100,
          unit: "%",
          label: `${alarmName} severity`,
          ccSpecific: { sensorType }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Alarm Sensor"] && (({ property, propertyKey }) => property === "severity" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  duration: Object.assign((sensorType) => {
    const property = "duration";
    const propertyKey = sensorType;
    return {
      id: {
        commandClass: import_core.CommandClasses["Alarm Sensor"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Alarm Sensor"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        const alarmName = (0, import_shared.getEnumMemberName)(import_Types.AlarmSensorType, sensorType);
        return {
          ...import_core.ValueMetadata.ReadOnlyNumber,
          unit: "s",
          label: `${alarmName} duration`,
          description: "For how long the alarm should be active",
          ccSpecific: { sensorType }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Alarm Sensor"] && (({ property, propertyKey }) => property === "duration" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  supportedSensorTypes: {
    id: {
      commandClass: import_core.CommandClasses["Alarm Sensor"],
      property: "supportedSensorTypes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Alarm Sensor"],
      endpoint,
      property: "supportedSensorTypes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Alarm Sensor"] && valueId.property === "supportedSensorTypes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const AssociationCCValues = Object.freeze({
  hasLifeline: {
    id: {
      commandClass: import_core.CommandClasses.Association,
      property: "hasLifeline"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Association,
      endpoint,
      property: "hasLifeline"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Association && valueId.property === "hasLifeline" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  groupCount: {
    id: {
      commandClass: import_core.CommandClasses.Association,
      property: "groupCount"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Association,
      endpoint,
      property: "groupCount"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Association && valueId.property === "groupCount" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  maxNodes: Object.assign((groupId) => {
    const property = "maxNodes";
    const propertyKey = groupId;
    return {
      id: {
        commandClass: import_core.CommandClasses.Association,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Association,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Association && (({ property, propertyKey }) => property === "maxNodes" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  nodeIds: Object.assign((groupId) => {
    const property = "nodeIds";
    const propertyKey = groupId;
    return {
      id: {
        commandClass: import_core.CommandClasses.Association,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Association,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Association && (({ property, propertyKey }) => property === "nodeIds" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const AssociationGroupInfoCCValues = Object.freeze({
  hasDynamicInfo: {
    id: {
      commandClass: import_core.CommandClasses["Association Group Information"],
      property: "hasDynamicInfo"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Association Group Information"],
      endpoint,
      property: "hasDynamicInfo"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Association Group Information"] && valueId.property === "hasDynamicInfo" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  groupName: Object.assign((groupId) => {
    const property = "name";
    const propertyKey = groupId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Association Group Information"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Association Group Information"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Association Group Information"] && (({ property, propertyKey }) => property === "name" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  groupInfo: Object.assign((groupId) => {
    const property = "info";
    const propertyKey = groupId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Association Group Information"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Association Group Information"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Association Group Information"] && (({ property, propertyKey }) => property === "info" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  commands: Object.assign((groupId) => {
    const property = "issuedCommands";
    const propertyKey = groupId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Association Group Information"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Association Group Information"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Association Group Information"] && (({ property, propertyKey }) => property === "issuedCommands" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const BarrierOperatorCCValues = Object.freeze({
  supportedSubsystemTypes: {
    id: {
      commandClass: import_core.CommandClasses["Barrier Operator"],
      property: "supportedSubsystemTypes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Barrier Operator"],
      endpoint,
      property: "supportedSubsystemTypes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Barrier Operator"] && valueId.property === "supportedSubsystemTypes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  position: {
    id: {
      commandClass: import_core.CommandClasses["Barrier Operator"],
      property: "position"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Barrier Operator"],
      endpoint,
      property: "position"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Barrier Operator"] && valueId.property === "position" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Barrier Position",
        unit: "%",
        max: 100
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  targetState: {
    id: {
      commandClass: import_core.CommandClasses["Barrier Operator"],
      property: "targetState"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Barrier Operator"],
      endpoint,
      property: "targetState"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Barrier Operator"] && valueId.property === "targetState" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        label: "Target Barrier State",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.BarrierState, [
          import_Types.BarrierState.Open,
          import_Types.BarrierState.Closed
        ])
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  currentState: {
    id: {
      commandClass: import_core.CommandClasses["Barrier Operator"],
      property: "currentState"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Barrier Operator"],
      endpoint,
      property: "currentState"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Barrier Operator"] && valueId.property === "currentState" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Current Barrier State",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.BarrierState)
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  signalingState: Object.assign((subsystemType) => {
    const property = "signalingState";
    const propertyKey = subsystemType;
    return {
      id: {
        commandClass: import_core.CommandClasses["Barrier Operator"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Barrier Operator"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.UInt8,
          label: `Signaling State (${(0, import_shared.getEnumMemberName)(import_Types.SubsystemType, subsystemType)})`,
          states: (0, import_core.enumValuesToMetadataStates)(import_Types.SubsystemState)
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Barrier Operator"] && (({ property, propertyKey }) => property === "signalingState" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const BasicCCValues = Object.freeze({
  currentValue: {
    id: {
      commandClass: import_core.CommandClasses.Basic,
      property: "currentValue"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Basic,
      endpoint,
      property: "currentValue"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Basic && valueId.property === "currentValue" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyLevel,
        label: "Current value"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  targetValue: {
    id: {
      commandClass: import_core.CommandClasses.Basic,
      property: "targetValue"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Basic,
      endpoint,
      property: "targetValue"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Basic && valueId.property === "targetValue" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        label: "Target value"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  duration: {
    id: {
      commandClass: import_core.CommandClasses.Basic,
      property: "duration"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Basic,
      endpoint,
      property: "duration"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Basic && valueId.property === "duration" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyDuration,
        label: "Remaining duration"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  restorePrevious: {
    id: {
      commandClass: import_core.CommandClasses.Basic,
      property: "restorePrevious"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Basic,
      endpoint,
      property: "restorePrevious"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Basic && valueId.property === "restorePrevious" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.WriteOnlyBoolean,
        label: "Restore previous value",
        states: {
          true: "Restore"
        }
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  compatEvent: {
    id: {
      commandClass: import_core.CommandClasses.Basic,
      property: "event"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Basic,
      endpoint,
      property: "event"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Basic && valueId.property === "event" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Event value"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: false,
      supportsEndpoints: true,
      autoCreate: false
    }
  }
});
const BasicWindowCoveringCCValues = Object.freeze({
  levelChangeUp: {
    id: {
      commandClass: import_core.CommandClasses["Basic Window Covering"],
      property: "levelChangeUp"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Basic Window Covering"],
      endpoint,
      property: "levelChangeUp"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Basic Window Covering"] && valueId.property === "levelChangeUp" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.WriteOnlyBoolean,
        label: "Open",
        states: {
          true: "Start",
          false: "Stop"
        }
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  levelChangeDown: {
    id: {
      commandClass: import_core.CommandClasses["Basic Window Covering"],
      property: "levelChangeDown"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Basic Window Covering"],
      endpoint,
      property: "levelChangeDown"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Basic Window Covering"] && valueId.property === "levelChangeDown" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.WriteOnlyBoolean,
        label: "Close",
        states: {
          true: "Start",
          false: "Stop"
        }
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const BatteryCCValues = Object.freeze({
  level: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "level"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "level"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "level" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        max: 100,
        unit: "%",
        label: "Battery level"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  maximumCapacity: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "maximumCapacity"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "maximumCapacity"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "maximumCapacity" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        max: 100,
        unit: "%",
        label: "Maximum capacity"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  temperature: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "temperature"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "temperature"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "temperature" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyInt8,
        label: "Temperature",
        // For now, only °C is specified as a valid unit
        // If this ever changes, update the unit in persistValues on the fly
        unit: "\xB0C"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  chargingStatus: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "chargingStatus"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "chargingStatus"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "chargingStatus" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Charging status",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.BatteryChargingStatus)
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  rechargeable: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "rechargeable"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "rechargeable"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "rechargeable" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Rechargeable"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  backup: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "backup"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "backup"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "backup" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Used as backup"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  overheating: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "overheating"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "overheating"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "overheating" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Overheating"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  lowFluid: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "lowFluid"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "lowFluid"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "lowFluid" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Fluid is low"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  rechargeOrReplace: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "rechargeOrReplace"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "rechargeOrReplace"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "rechargeOrReplace" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Recharge or replace",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.BatteryReplacementStatus)
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  disconnected: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "disconnected"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "disconnected"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "disconnected" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Battery is disconnected"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  lowTemperatureStatus: {
    id: {
      commandClass: import_core.CommandClasses.Battery,
      property: "lowTemperatureStatus"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Battery,
      endpoint,
      property: "lowTemperatureStatus"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Battery && valueId.property === "lowTemperatureStatus" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Battery temperature is low"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const BinarySensorCCValues = Object.freeze({
  supportedSensorTypes: {
    id: {
      commandClass: import_core.CommandClasses["Binary Sensor"],
      property: "supportedSensorTypes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Binary Sensor"],
      endpoint,
      property: "supportedSensorTypes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Binary Sensor"] && valueId.property === "supportedSensorTypes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  state: Object.assign((sensorType) => {
    const property = (0, import_shared.getEnumMemberName)(import_Types.BinarySensorType, sensorType);
    return {
      id: {
        commandClass: import_core.CommandClasses["Binary Sensor"],
        property
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Binary Sensor"],
        endpoint,
        property
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyBoolean,
          label: `Sensor state (${(0, import_shared.getEnumMemberName)(import_Types.BinarySensorType, sensorType)})`,
          ccSpecific: { sensorType }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Binary Sensor"] && (({ property }) => typeof property === "string" && property in import_Types.BinarySensorType)(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const BinarySwitchCCValues = Object.freeze({
  currentValue: {
    id: {
      commandClass: import_core.CommandClasses["Binary Switch"],
      property: "currentValue"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Binary Switch"],
      endpoint,
      property: "currentValue"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Binary Switch"] && valueId.property === "currentValue" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Current value"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  targetValue: {
    id: {
      commandClass: import_core.CommandClasses["Binary Switch"],
      property: "targetValue"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Binary Switch"],
      endpoint,
      property: "targetValue"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Binary Switch"] && valueId.property === "targetValue" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Boolean,
        label: "Target value",
        valueChangeOptions: ["transitionDuration"]
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  duration: {
    id: {
      commandClass: import_core.CommandClasses["Binary Switch"],
      property: "duration"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Binary Switch"],
      endpoint,
      property: "duration"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Binary Switch"] && valueId.property === "duration" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyDuration,
        label: "Remaining duration"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const CentralSceneCCValues = Object.freeze({
  sceneCount: {
    id: {
      commandClass: import_core.CommandClasses["Central Scene"],
      property: "sceneCount"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Central Scene"],
      endpoint,
      property: "sceneCount"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Central Scene"] && valueId.property === "sceneCount" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsSlowRefresh: {
    id: {
      commandClass: import_core.CommandClasses["Central Scene"],
      property: "supportsSlowRefresh"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Central Scene"],
      endpoint,
      property: "supportsSlowRefresh"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Central Scene"] && valueId.property === "supportsSlowRefresh" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedKeyAttributes: {
    id: {
      commandClass: import_core.CommandClasses["Central Scene"],
      property: "supportedKeyAttributes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Central Scene"],
      endpoint,
      property: "supportedKeyAttributes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Central Scene"] && valueId.property === "supportedKeyAttributes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  slowRefresh: {
    id: {
      commandClass: import_core.CommandClasses["Central Scene"],
      property: "slowRefresh"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Central Scene"],
      endpoint,
      property: "slowRefresh"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Central Scene"] && valueId.property === "slowRefresh" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Boolean,
        label: "Send held down notifications at a slow rate",
        description: "When this is true, KeyHeldDown notifications are sent every 55s. When this is false, the notifications are sent every 200ms."
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  scene: Object.assign((sceneNumber) => {
    const property = "scene";
    const propertyKey = sceneNumber.toString().padStart(3, "0");
    return {
      id: {
        commandClass: import_core.CommandClasses["Central Scene"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Central Scene"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyUInt8,
          label: `Scene ${sceneNumber.toString().padStart(3, "0")}`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Central Scene"] && (({ property, propertyKey }) => property === "scene" && typeof propertyKey === "string" && /^\d{3}$/.test(propertyKey))(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: false,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const ClimateControlScheduleCCValues = Object.freeze({
  overrideType: {
    id: {
      commandClass: import_core.CommandClasses["Climate Control Schedule"],
      property: "overrideType"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Climate Control Schedule"],
      endpoint,
      property: "overrideType"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Climate Control Schedule"] && valueId.property === "overrideType" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Number,
        label: "Override type",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.ScheduleOverrideType)
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  overrideState: {
    id: {
      commandClass: import_core.CommandClasses["Climate Control Schedule"],
      property: "overrideState"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Climate Control Schedule"],
      endpoint,
      property: "overrideState"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Climate Control Schedule"] && valueId.property === "overrideState" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Number,
        label: "Override state",
        min: -12.8
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  schedule: Object.assign((weekday) => {
    const property = "schedule";
    const propertyKey = weekday;
    return {
      id: {
        commandClass: import_core.CommandClasses["Climate Control Schedule"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Climate Control Schedule"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Any,
          label: `Schedule (${(0, import_shared.getEnumMemberName)(import_Types.Weekday, weekday)})`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Climate Control Schedule"] && (({ property, propertyKey }) => property === "switchPoints" && typeof propertyKey === "number" && propertyKey >= import_Types.Weekday.Monday && propertyKey <= import_Types.Weekday.Sunday)(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const ColorSwitchCCValues = Object.freeze({
  supportedColorComponents: {
    id: {
      commandClass: import_core.CommandClasses["Color Switch"],
      property: "supportedColorComponents"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Color Switch"],
      endpoint,
      property: "supportedColorComponents"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Color Switch"] && valueId.property === "supportedColorComponents" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsHexColor: {
    id: {
      commandClass: import_core.CommandClasses["Color Switch"],
      property: "supportsHexColor"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Color Switch"],
      endpoint,
      property: "supportsHexColor"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Color Switch"] && valueId.property === "supportsHexColor" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  currentColor: {
    id: {
      commandClass: import_core.CommandClasses["Color Switch"],
      property: "currentColor"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Color Switch"],
      endpoint,
      property: "currentColor"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Color Switch"] && valueId.property === "currentColor" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnly,
        label: `Current color`
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  targetColor: {
    id: {
      commandClass: import_core.CommandClasses["Color Switch"],
      property: "targetColor"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Color Switch"],
      endpoint,
      property: "targetColor"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Color Switch"] && valueId.property === "targetColor" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Any,
        label: `Target color`,
        valueChangeOptions: ["transitionDuration"]
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  duration: {
    id: {
      commandClass: import_core.CommandClasses["Color Switch"],
      property: "duration"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Color Switch"],
      endpoint,
      property: "duration"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Color Switch"] && valueId.property === "duration" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyDuration,
        label: "Remaining duration"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  hexColor: {
    id: {
      commandClass: import_core.CommandClasses["Color Switch"],
      property: "hexColor"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Color Switch"],
      endpoint,
      property: "hexColor"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Color Switch"] && valueId.property === "hexColor" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Color,
        minLength: 6,
        maxLength: 7,
        // to allow #rrggbb
        label: `RGB Color`,
        valueChangeOptions: ["transitionDuration"]
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  currentColorChannel: Object.assign((component) => {
    const property = "currentColor";
    const propertyKey = component;
    return {
      id: {
        commandClass: import_core.CommandClasses["Color Switch"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Color Switch"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        const colorName = (0, import_shared.getEnumMemberName)(import_Types.ColorComponent, component);
        return {
          ...import_core.ValueMetadata.ReadOnlyUInt8,
          label: `Current value (${colorName})`,
          description: `The current value of the ${colorName} channel.`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Color Switch"] && (({ property, propertyKey }) => property === "currentColor" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  targetColorChannel: Object.assign((component) => {
    const property = "targetColor";
    const propertyKey = component;
    return {
      id: {
        commandClass: import_core.CommandClasses["Color Switch"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Color Switch"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        const colorName = (0, import_shared.getEnumMemberName)(import_Types.ColorComponent, component);
        return {
          ...import_core.ValueMetadata.UInt8,
          label: `Target value (${colorName})`,
          description: `The target value of the ${colorName} channel.`,
          valueChangeOptions: ["transitionDuration"]
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Color Switch"] && (({ property, propertyKey }) => property === "targetColor" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const ConfigurationCCValues = Object.freeze({
  isParamInformationFromConfig: {
    id: {
      commandClass: import_core.CommandClasses.Configuration,
      property: "isParamInformationFromConfig"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Configuration,
      endpoint: 0,
      // no endpoint support!
      property: "isParamInformationFromConfig"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Configuration && valueId.property === "isParamInformationFromConfig" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  paramInformation: Object.assign((parameter, bitMask) => {
    const property = parameter;
    const propertyKey = bitMask;
    return {
      id: {
        commandClass: import_core.CommandClasses.Configuration,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Configuration,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Configuration && (({ property, propertyKey }) => typeof property === "number" && (typeof propertyKey === "number" || propertyKey == void 0))(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const DoorLockCCValues = Object.freeze({
  targetMode: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "targetMode"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "targetMode"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "targetMode" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        label: "Target lock mode",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.DoorLockMode)
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  currentMode: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "currentMode"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "currentMode"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "currentMode" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Current lock mode",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.DoorLockMode)
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  duration: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "duration"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "duration"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "duration" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyDuration,
        label: "Remaining duration until target lock mode"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedOutsideHandles: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "supportedOutsideHandles"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "supportedOutsideHandles"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "supportedOutsideHandles" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  outsideHandlesCanOpenDoorConfiguration: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "outsideHandlesCanOpenDoorConfiguration"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "outsideHandlesCanOpenDoorConfiguration"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "outsideHandlesCanOpenDoorConfiguration" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Any,
        label: "Which outside handles can open the door (configuration)"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  outsideHandlesCanOpenDoor: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "outsideHandlesCanOpenDoor"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "outsideHandlesCanOpenDoor"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "outsideHandlesCanOpenDoor" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnly,
        label: "Which outside handles can open the door (actual status)"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedInsideHandles: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "supportedInsideHandles"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "supportedInsideHandles"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "supportedInsideHandles" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  insideHandlesCanOpenDoorConfiguration: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "insideHandlesCanOpenDoorConfiguration"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "insideHandlesCanOpenDoorConfiguration"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "insideHandlesCanOpenDoorConfiguration" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Any,
        label: "Which inside handles can open the door (configuration)"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  insideHandlesCanOpenDoor: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "insideHandlesCanOpenDoor"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "insideHandlesCanOpenDoor"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "insideHandlesCanOpenDoor" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnly,
        label: "Which inside handles can open the door (actual status)"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  operationType: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "operationType"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "operationType"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "operationType" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        label: "Lock operation type",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.DoorLockOperationType)
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  lockTimeoutConfiguration: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "lockTimeoutConfiguration"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "lockTimeoutConfiguration"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "lockTimeoutConfiguration" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt16,
        label: "Duration of timed mode in seconds"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  lockTimeout: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "lockTimeout"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "lockTimeout"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "lockTimeout" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt16,
        label: "Seconds until lock mode times out"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  autoRelockSupported: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "autoRelockSupported"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "autoRelockSupported"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "autoRelockSupported" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  autoRelockTime: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "autoRelockTime"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "autoRelockTime"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "autoRelockTime" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt16,
        label: "Duration in seconds until lock returns to secure state"
      };
    },
    options: {
      internal: false,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: shouldAutoCreateAutoRelockConfigValue
    }
  },
  holdAndReleaseSupported: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "holdAndReleaseSupported"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "holdAndReleaseSupported"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "holdAndReleaseSupported" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  holdAndReleaseTime: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "holdAndReleaseTime"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "holdAndReleaseTime"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "holdAndReleaseTime" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt16,
        label: "Duration in seconds the latch stays retracted"
      };
    },
    options: {
      internal: false,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: shouldAutoCreateHoldAndReleaseConfigValue
    }
  },
  twistAssistSupported: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "twistAssistSupported"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "twistAssistSupported"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "twistAssistSupported" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  twistAssist: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "twistAssist"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "twistAssist"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "twistAssist" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Boolean,
        label: "Twist Assist enabled"
      };
    },
    options: {
      internal: false,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: shouldAutoCreateTwistAssistConfigValue
    }
  },
  blockToBlockSupported: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "blockToBlockSupported"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "blockToBlockSupported"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "blockToBlockSupported" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  blockToBlock: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "blockToBlock"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "blockToBlock"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "blockToBlock" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Boolean,
        label: "Block-to-block functionality enabled"
      };
    },
    options: {
      internal: false,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: shouldAutoCreateBlockToBlockConfigValue
    }
  },
  latchSupported: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "latchSupported"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "latchSupported"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "latchSupported" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  latchStatus: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "latchStatus"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "latchStatus"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "latchStatus" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnly,
        label: "Current status of the latch"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: shouldAutoCreateLatchStatusValue
    }
  },
  boltSupported: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "boltSupported"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "boltSupported"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "boltSupported" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  boltStatus: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "boltStatus"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "boltStatus"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "boltStatus" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnly,
        label: "Current status of the bolt"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: shouldAutoCreateBoltStatusValue
    }
  },
  doorSupported: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "doorSupported"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "doorSupported"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "doorSupported" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  doorStatus: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock"],
      property: "doorStatus"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock"],
      endpoint,
      property: "doorStatus"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock"] && valueId.property === "doorStatus" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnly,
        label: "Current status of the door"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: shouldAutoCreateDoorStatusValue
    }
  }
});
function shouldAutoCreateAutoRelockConfigValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(DoorLockCCValues.autoRelockSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateAutoRelockConfigValue, "shouldAutoCreateAutoRelockConfigValue");
function shouldAutoCreateHoldAndReleaseConfigValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(DoorLockCCValues.holdAndReleaseSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateHoldAndReleaseConfigValue, "shouldAutoCreateHoldAndReleaseConfigValue");
function shouldAutoCreateTwistAssistConfigValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(DoorLockCCValues.twistAssistSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateTwistAssistConfigValue, "shouldAutoCreateTwistAssistConfigValue");
function shouldAutoCreateBlockToBlockConfigValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(DoorLockCCValues.blockToBlockSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateBlockToBlockConfigValue, "shouldAutoCreateBlockToBlockConfigValue");
function shouldAutoCreateLatchStatusValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(DoorLockCCValues.latchSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateLatchStatusValue, "shouldAutoCreateLatchStatusValue");
function shouldAutoCreateBoltStatusValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(DoorLockCCValues.boltSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateBoltStatusValue, "shouldAutoCreateBoltStatusValue");
function shouldAutoCreateDoorStatusValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(DoorLockCCValues.doorSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateDoorStatusValue, "shouldAutoCreateDoorStatusValue");
const DoorLockLoggingCCValues = Object.freeze({
  recordsCount: {
    id: {
      commandClass: import_core.CommandClasses["Door Lock Logging"],
      property: "recordsCount"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Door Lock Logging"],
      endpoint,
      property: "recordsCount"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Door Lock Logging"] && valueId.property === "recordsCount" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const EnergyProductionCCValues = Object.freeze({
  value: Object.assign((parameter) => {
    const property = "value";
    const propertyKey = parameter;
    return {
      id: {
        commandClass: import_core.CommandClasses["Energy Production"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Energy Production"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyNumber,
          label: (0, import_shared.getEnumMemberName)(import_Types.EnergyProductionParameter, parameter)
          // unit and ccSpecific are set dynamically
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Energy Production"] && (({ property, propertyKey }) => property === "value" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const EntryControlCCValues = Object.freeze({
  keyCacheSize: {
    id: {
      commandClass: import_core.CommandClasses["Entry Control"],
      property: "keyCacheSize"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Entry Control"],
      endpoint,
      property: "keyCacheSize"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Entry Control"] && valueId.property === "keyCacheSize" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        label: "Key cache size",
        description: "Number of character that must be stored before sending",
        min: 1,
        max: 32
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  keyCacheTimeout: {
    id: {
      commandClass: import_core.CommandClasses["Entry Control"],
      property: "keyCacheTimeout"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Entry Control"],
      endpoint,
      property: "keyCacheTimeout"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Entry Control"] && valueId.property === "keyCacheTimeout" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        label: "Key cache timeout",
        unit: "seconds",
        description: "How long the key cache must wait for additional characters",
        min: 1,
        max: 10
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedDataTypes: {
    id: {
      commandClass: import_core.CommandClasses["Entry Control"],
      property: "supportedDataTypes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Entry Control"],
      endpoint,
      property: "supportedDataTypes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Entry Control"] && valueId.property === "supportedDataTypes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedEventTypes: {
    id: {
      commandClass: import_core.CommandClasses["Entry Control"],
      property: "supportedEventTypes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Entry Control"],
      endpoint,
      property: "supportedEventTypes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Entry Control"] && valueId.property === "supportedEventTypes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedKeys: {
    id: {
      commandClass: import_core.CommandClasses["Entry Control"],
      property: "supportedKeys"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Entry Control"],
      endpoint,
      property: "supportedKeys"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Entry Control"] && valueId.property === "supportedKeys" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const FirmwareUpdateMetaDataCCValues = Object.freeze({
  supportsActivation: {
    id: {
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      property: "supportsActivation"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      endpoint,
      property: "supportsActivation"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Firmware Update Meta Data"] && valueId.property === "supportsActivation" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  firmwareUpgradable: {
    id: {
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      property: "firmwareUpgradable"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      endpoint,
      property: "firmwareUpgradable"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Firmware Update Meta Data"] && valueId.property === "firmwareUpgradable" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  additionalFirmwareIDs: {
    id: {
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      property: "additionalFirmwareIDs"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      endpoint,
      property: "additionalFirmwareIDs"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Firmware Update Meta Data"] && valueId.property === "additionalFirmwareIDs" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  continuesToFunction: {
    id: {
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      property: "continuesToFunction"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      endpoint,
      property: "continuesToFunction"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Firmware Update Meta Data"] && valueId.property === "continuesToFunction" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsResuming: {
    id: {
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      property: "supportsResuming"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      endpoint,
      property: "supportsResuming"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Firmware Update Meta Data"] && valueId.property === "supportsResuming" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsNonSecureTransfer: {
    id: {
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      property: "supportsNonSecureTransfer"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Firmware Update Meta Data"],
      endpoint,
      property: "supportsNonSecureTransfer"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Firmware Update Meta Data"] && valueId.property === "supportsNonSecureTransfer" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const HumidityControlModeCCValues = Object.freeze({
  mode: {
    id: {
      commandClass: import_core.CommandClasses["Humidity Control Mode"],
      property: "mode"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Humidity Control Mode"],
      endpoint,
      property: "mode"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Humidity Control Mode"] && valueId.property === "mode" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.HumidityControlMode),
        label: "Humidity control mode"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedModes: {
    id: {
      commandClass: import_core.CommandClasses["Humidity Control Mode"],
      property: "supportedModes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Humidity Control Mode"],
      endpoint,
      property: "supportedModes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Humidity Control Mode"] && valueId.property === "supportedModes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const HumidityControlOperatingStateCCValues = Object.freeze({
  state: {
    id: {
      commandClass: import_core.CommandClasses["Humidity Control Operating State"],
      property: "state"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Humidity Control Operating State"],
      endpoint,
      property: "state"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Humidity Control Operating State"] && valueId.property === "state" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.HumidityControlOperatingState),
        label: "Humidity control operating state"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const HumidityControlSetpointCCValues = Object.freeze({
  supportedSetpointTypes: {
    id: {
      commandClass: import_core.CommandClasses["Humidity Control Setpoint"],
      property: "supportedSetpointTypes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Humidity Control Setpoint"],
      endpoint,
      property: "supportedSetpointTypes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Humidity Control Setpoint"] && valueId.property === "supportedSetpointTypes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  setpoint: Object.assign((setpointType) => {
    const property = "setpoint";
    const propertyKey = setpointType;
    return {
      id: {
        commandClass: import_core.CommandClasses["Humidity Control Setpoint"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Humidity Control Setpoint"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          // This is the base metadata that will be extended on the fly
          ...import_core.ValueMetadata.Number,
          label: `Setpoint (${(0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, setpointType)})`,
          ccSpecific: { setpointType }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Humidity Control Setpoint"] && (({ property, propertyKey }) => property === "setpoint" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  setpointScale: Object.assign((setpointType) => {
    const property = "setpointScale";
    const propertyKey = setpointType;
    return {
      id: {
        commandClass: import_core.CommandClasses["Humidity Control Setpoint"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Humidity Control Setpoint"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyUInt8,
          label: `Setpoint scale (${(0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, setpointType)})`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Humidity Control Setpoint"] && (({ property, propertyKey }) => property === "setpointScale" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const IndicatorCCValues = Object.freeze({
  supportedIndicatorIds: {
    id: {
      commandClass: import_core.CommandClasses.Indicator,
      property: "supportedIndicatorIds"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Indicator,
      endpoint,
      property: "supportedIndicatorIds"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Indicator && valueId.property === "supportedIndicatorIds" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  valueV1: {
    id: {
      commandClass: import_core.CommandClasses.Indicator,
      property: "value"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Indicator,
      endpoint,
      property: "value"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Indicator && valueId.property === "value" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        label: "Indicator value",
        ccSpecific: {
          indicatorId: 0
        }
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  identify: {
    id: {
      commandClass: import_core.CommandClasses.Indicator,
      property: "identify"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Indicator,
      endpoint,
      property: "identify"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Indicator && valueId.property === "identify" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.WriteOnlyBoolean,
        label: "Identify",
        states: {
          true: "Identify"
        }
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedPropertyIDs: Object.assign((indicatorId) => {
    const property = "supportedPropertyIDs";
    const propertyKey = indicatorId;
    return {
      id: {
        commandClass: import_core.CommandClasses.Indicator,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Indicator,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Indicator && (({ property, propertyKey }) => property === "supportedPropertyIDs" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  valueV2: Object.assign((indicatorId, propertyId) => {
    const property = indicatorId;
    const propertyKey = propertyId;
    return {
      id: {
        commandClass: import_core.CommandClasses.Indicator,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Indicator,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Any,
          ccSpecific: {
            indicatorId,
            propertyId
          }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Indicator && (({ property, propertyKey }) => typeof property === "number" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  timeout: Object.assign((indicatorId) => {
    const property = indicatorId;
    const propertyKey = "timeout";
    return {
      id: {
        commandClass: import_core.CommandClasses.Indicator,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Indicator,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.String,
          label: "Timeout",
          ccSpecific: {
            indicatorId
          }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Indicator && (({ property, propertyKey }) => typeof property === "number" && propertyKey === "timeout")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  indicatorDescription: Object.assign((indicatorId) => {
    const property = indicatorId;
    return {
      id: {
        commandClass: import_core.CommandClasses.Indicator,
        property
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Indicator,
        endpoint,
        property
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Indicator && (({ property }) => typeof property === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 4,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const IrrigationCCValues = Object.freeze({
  numValves: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "numValves"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "numValves"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "numValves" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  numValveTables: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "numValveTables"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "numValveTables"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "numValveTables" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsMasterValve: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "supportsMasterValve"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "supportsMasterValve"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "supportsMasterValve" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  maxValveTableSize: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "maxValveTableSize"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "maxValveTableSize"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "maxValveTableSize" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  systemVoltage: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "systemVoltage"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "systemVoltage"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "systemVoltage" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "System voltage",
        unit: "V"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  masterValveDelay: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "masterValveDelay"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "masterValveDelay"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "masterValveDelay" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        label: "Master valve delay",
        description: "The delay between turning on the master valve and turning on any zone valve",
        unit: "seconds"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  flowSensorActive: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "flowSensorActive"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "flowSensorActive"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "flowSensorActive" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Flow sensor active"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  pressureSensorActive: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "pressureSensorActive"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "pressureSensorActive"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "pressureSensorActive" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Pressure sensor active"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  rainSensorActive: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "rainSensorActive"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "rainSensorActive"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "rainSensorActive" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Rain sensor attached and active"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  rainSensorPolarity: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "rainSensorPolarity"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "rainSensorPolarity"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "rainSensorPolarity" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Number,
        label: "Rain sensor polarity",
        min: 0,
        max: 1,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.IrrigationSensorPolarity)
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  moistureSensorActive: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "moistureSensorActive"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "moistureSensorActive"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "moistureSensorActive" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Moisture sensor attached and active"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  moistureSensorPolarity: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "moistureSensorPolarity"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "moistureSensorPolarity"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "moistureSensorPolarity" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Number,
        label: "Moisture sensor polarity",
        min: 0,
        max: 1,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.IrrigationSensorPolarity)
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  flow: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "flow"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "flow"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "flow" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyNumber,
        label: "Flow",
        unit: "l/h"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  pressure: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "pressure"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "pressure"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "pressure" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyNumber,
        label: "Pressure",
        unit: "kPa"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  shutoffDuration: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "shutoffDuration"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "shutoffDuration"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "shutoffDuration" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Remaining shutoff duration",
        unit: "hours"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  errorNotProgrammed: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "errorNotProgrammed"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "errorNotProgrammed"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "errorNotProgrammed" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Error: device not programmed"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  errorEmergencyShutdown: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "errorEmergencyShutdown"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "errorEmergencyShutdown"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "errorEmergencyShutdown" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Error: emergency shutdown"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  errorHighPressure: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "errorHighPressure"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "errorHighPressure"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "errorHighPressure" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Error: high pressure"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  highPressureThreshold: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "highPressureThreshold"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "highPressureThreshold"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "highPressureThreshold" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Number,
        label: "High pressure threshold",
        unit: "kPa"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  errorLowPressure: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "errorLowPressure"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "errorLowPressure"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "errorLowPressure" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Error: low pressure"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  lowPressureThreshold: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "lowPressureThreshold"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "lowPressureThreshold"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "lowPressureThreshold" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Number,
        label: "Low pressure threshold",
        unit: "kPa"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  errorValve: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "errorValve"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "errorValve"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "errorValve" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Error: valve reporting error"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  masterValveOpen: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "masterValveOpen"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "masterValveOpen"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "masterValveOpen" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBoolean,
        label: "Master valve is open"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  firstOpenZoneId: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "firstOpenZoneId"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "firstOpenZoneId"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "firstOpenZoneId" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyNumber,
        label: "First open zone valve ID"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  shutoffSystem: {
    id: {
      commandClass: import_core.CommandClasses.Irrigation,
      property: "shutoff"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Irrigation,
      endpoint,
      property: "shutoff"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && valueId.property === "shutoff" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.WriteOnlyBoolean,
        label: `Shutoff system`,
        states: {
          true: "Shutoff"
        }
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  valveConnected: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "valveConnected";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyBoolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Connected`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "valveConnected")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  nominalCurrent: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "nominalCurrent";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyBoolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Nominal current`,
          unit: "mA"
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "nominalCurrent")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  nominalCurrentHighThreshold: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "nominalCurrentHighThreshold";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Number,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Nominal current - high threshold`,
          min: 0,
          max: 2550,
          unit: "mA"
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "nominalCurrentHighThreshold")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  nominalCurrentLowThreshold: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "nominalCurrentLowThreshold";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Number,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Nominal current - low threshold`,
          min: 0,
          max: 2550,
          unit: "mA"
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "nominalCurrentLowThreshold")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  errorShortCircuit: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "errorShortCircuit";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyBoolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Error - Short circuit detected`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "errorShortCircuit")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  errorHighCurrent: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "errorHighCurrent";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyBoolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Error - Current above high threshold`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "errorHighCurrent")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  errorLowCurrent: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "errorLowCurrent";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyBoolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Error - Current below low threshold`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "errorLowCurrent")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  maximumFlow: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "maximumFlow";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Number,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Maximum flow`,
          min: 0,
          unit: "l/h"
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "maximumFlow")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  errorMaximumFlow: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "errorMaximumFlow";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyBoolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Error - Maximum flow detected`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "errorMaximumFlow")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  highFlowThreshold: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "highFlowThreshold";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Number,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: High flow threshold`,
          min: 0,
          unit: "l/h"
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "highFlowThreshold")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  errorHighFlow: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "errorHighFlow";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyBoolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Error - Flow above high threshold`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "errorHighFlow")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  lowFlowThreshold: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "lowFlowThreshold";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Number,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Low flow threshold`,
          min: 0,
          unit: "l/h"
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "lowFlowThreshold")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  errorLowFlow: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "errorLowFlow";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyBoolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Error - Flow below high threshold`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "errorLowFlow")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  useRainSensor: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "useRainSensor";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Boolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Use rain sensor`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "useRainSensor")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  useMoistureSensor: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "useMoistureSensor";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Boolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Use moisture sensor`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "useMoistureSensor")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  valveRunDuration: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "duration";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.UInt16,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Run duration`,
          min: 1,
          unit: "s"
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "duration")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  valveRunStartStop: Object.assign((valveId) => {
    const property = valveId;
    const propertyKey = "startStop";
    return {
      id: {
        commandClass: import_core.CommandClasses.Irrigation,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Irrigation,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Boolean,
          label: `${(0, import_CCValueUtils.irrigationValveIdToMetadataPrefix)(valveId)}: Start/Stop`,
          states: {
            true: "Start",
            false: "Stop"
          }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Irrigation && (({ property, propertyKey }) => (typeof property === "number" || property === "master") && propertyKey === "startStop")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const LanguageCCValues = Object.freeze({
  language: {
    id: {
      commandClass: import_core.CommandClasses.Language,
      property: "language"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Language,
      endpoint,
      property: "language"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Language && valueId.property === "language" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Language code"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  country: {
    id: {
      commandClass: import_core.CommandClasses.Language,
      property: "country"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Language,
      endpoint,
      property: "country"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Language && valueId.property === "country" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Country code"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const LockCCValues = Object.freeze({
  locked: {
    id: {
      commandClass: import_core.CommandClasses.Lock,
      property: "locked"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Lock,
      endpoint,
      property: "locked"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Lock && valueId.property === "locked" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Boolean,
        label: "Locked",
        description: "Whether the lock is locked"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const ManufacturerSpecificCCValues = Object.freeze({
  manufacturerId: {
    id: {
      commandClass: import_core.CommandClasses["Manufacturer Specific"],
      property: "manufacturerId"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Manufacturer Specific"],
      endpoint: 0,
      // no endpoint support!
      property: "manufacturerId"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Manufacturer Specific"] && valueId.property === "manufacturerId" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt16,
        label: "Manufacturer ID"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  productType: {
    id: {
      commandClass: import_core.CommandClasses["Manufacturer Specific"],
      property: "productType"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Manufacturer Specific"],
      endpoint: 0,
      // no endpoint support!
      property: "productType"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Manufacturer Specific"] && valueId.property === "productType" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt16,
        label: "Product type"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  productId: {
    id: {
      commandClass: import_core.CommandClasses["Manufacturer Specific"],
      property: "productId"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Manufacturer Specific"],
      endpoint: 0,
      // no endpoint support!
      property: "productId"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Manufacturer Specific"] && valueId.property === "productId" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt16,
        label: "Product ID"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  deviceId: Object.assign((type) => {
    const property = "deviceId";
    const propertyKey = (0, import_shared.getEnumMemberName)(import_Types.DeviceIdType, type);
    return {
      id: {
        commandClass: import_core.CommandClasses["Manufacturer Specific"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Manufacturer Specific"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyString,
          label: `Device ID (${(0, import_shared.getEnumMemberName)(import_Types.DeviceIdType, type)})`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Manufacturer Specific"] && (({ property, propertyKey }) => property === "deviceId" && typeof propertyKey === "string" && propertyKey in import_Types.DeviceIdType)(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const MeterCCValues = Object.freeze({
  type: {
    id: {
      commandClass: import_core.CommandClasses.Meter,
      property: "type"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Meter,
      endpoint,
      property: "type"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Meter && valueId.property === "type" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsReset: {
    id: {
      commandClass: import_core.CommandClasses.Meter,
      property: "supportsReset"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Meter,
      endpoint,
      property: "supportsReset"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Meter && valueId.property === "supportsReset" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedScales: {
    id: {
      commandClass: import_core.CommandClasses.Meter,
      property: "supportedScales"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Meter,
      endpoint,
      property: "supportedScales"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Meter && valueId.property === "supportedScales" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedRateTypes: {
    id: {
      commandClass: import_core.CommandClasses.Meter,
      property: "supportedRateTypes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Meter,
      endpoint,
      property: "supportedRateTypes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Meter && valueId.property === "supportedRateTypes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  resetAll: {
    id: {
      commandClass: import_core.CommandClasses.Meter,
      property: "reset"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Meter,
      endpoint,
      property: "reset"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Meter && valueId.property === "reset" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.WriteOnlyBoolean,
        label: `Reset accumulated values`,
        states: {
          true: "Reset"
        }
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  resetSingle: Object.assign((meterType, rateType, scale) => {
    const property = "reset";
    const propertyKey = (0, import_CCValueUtils.meterTypesToPropertyKey)(meterType, rateType, scale);
    return {
      id: {
        commandClass: import_core.CommandClasses.Meter,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Meter,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.WriteOnlyBoolean,
          // This is only a placeholder label. A config manager is needed to
          // determine the actual label.
          label: `Reset (${rateType === import_Types.RateType.Consumed ? "Consumption, " : rateType === import_Types.RateType.Produced ? "Production, " : ""}${(0, import_shared.num2hex)(scale)})`,
          states: {
            true: "Reset"
          },
          ccSpecific: {
            meterType,
            rateType,
            scale
          }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Meter && (({ property, propertyKey }) => property === "reset" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  value: Object.assign((meterType, rateType, scale) => {
    const property = "value";
    const propertyKey = (0, import_CCValueUtils.meterTypesToPropertyKey)(meterType, rateType, scale);
    return {
      id: {
        commandClass: import_core.CommandClasses.Meter,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Meter,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyNumber,
          // Label and unit can only be determined with a config manager
          ccSpecific: {
            meterType,
            rateType,
            scale
          }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Meter && (({ property, propertyKey }) => property === "value" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const MultiChannelAssociationCCValues = Object.freeze({
  groupCount: {
    id: {
      commandClass: import_core.CommandClasses["Multi Channel Association"],
      property: "groupCount"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Multi Channel Association"],
      endpoint,
      property: "groupCount"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel Association"] && valueId.property === "groupCount" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  maxNodes: Object.assign((groupId) => {
    const property = "maxNodes";
    const propertyKey = groupId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Multi Channel Association"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Multi Channel Association"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel Association"] && (({ property, propertyKey }) => property === "maxNodes" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  nodeIds: Object.assign((groupId) => {
    const property = "nodeIds";
    const propertyKey = groupId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Multi Channel Association"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Multi Channel Association"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel Association"] && (({ property, propertyKey }) => property === "nodeIds" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  endpoints: Object.assign((groupId) => {
    const property = "endpoints";
    const propertyKey = groupId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Multi Channel Association"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Multi Channel Association"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel Association"] && (({ property, propertyKey }) => property === "endpoints" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const MultiChannelCCValues = Object.freeze({
  endpointIndizes: {
    id: {
      commandClass: import_core.CommandClasses["Multi Channel"],
      property: "endpointIndizes"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Multi Channel"],
      endpoint: 0,
      // no endpoint support!
      property: "endpointIndizes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel"] && valueId.property === "endpointIndizes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  individualEndpointCount: {
    id: {
      commandClass: import_core.CommandClasses["Multi Channel"],
      property: "individualCount"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Multi Channel"],
      endpoint: 0,
      // no endpoint support!
      property: "individualCount"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel"] && valueId.property === "individualCount" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  aggregatedEndpointCount: {
    id: {
      commandClass: import_core.CommandClasses["Multi Channel"],
      property: "aggregatedCount"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Multi Channel"],
      endpoint: 0,
      // no endpoint support!
      property: "aggregatedCount"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel"] && valueId.property === "aggregatedCount" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  endpointCountIsDynamic: {
    id: {
      commandClass: import_core.CommandClasses["Multi Channel"],
      property: "countIsDynamic"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Multi Channel"],
      endpoint: 0,
      // no endpoint support!
      property: "countIsDynamic"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel"] && valueId.property === "countIsDynamic" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  endpointsHaveIdenticalCapabilities: {
    id: {
      commandClass: import_core.CommandClasses["Multi Channel"],
      property: "identicalCapabilities"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Multi Channel"],
      endpoint: 0,
      // no endpoint support!
      property: "identicalCapabilities"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel"] && valueId.property === "identicalCapabilities" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  endpointCCs: {
    id: {
      commandClass: import_core.CommandClasses["Multi Channel"],
      property: "commandClasses"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Multi Channel"],
      endpoint,
      property: "commandClasses"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel"] && valueId.property === "commandClasses" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  endpointDeviceClass: {
    id: {
      commandClass: import_core.CommandClasses["Multi Channel"],
      property: "deviceClass"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Multi Channel"],
      endpoint,
      property: "deviceClass"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel"] && valueId.property === "deviceClass" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  aggregatedEndpointMembers: Object.assign((endpointIndex) => {
    const property = "members";
    const propertyKey = endpointIndex;
    return {
      id: {
        commandClass: import_core.CommandClasses["Multi Channel"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Multi Channel"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multi Channel"] && (({ property, propertyKey }) => property === "members" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const MultilevelSensorCCValues = Object.freeze({
  supportedSensorTypes: {
    id: {
      commandClass: import_core.CommandClasses["Multilevel Sensor"],
      property: "supportedSensorTypes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Multilevel Sensor"],
      endpoint,
      property: "supportedSensorTypes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Sensor"] && valueId.property === "supportedSensorTypes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedScales: Object.assign((sensorType) => {
    const property = "supportedScales";
    const propertyKey = sensorType;
    return {
      id: {
        commandClass: import_core.CommandClasses["Multilevel Sensor"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Multilevel Sensor"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Sensor"] && (({ property, propertyKey }) => property === "supportedScales" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  value: Object.assign((sensorTypeName) => {
    const property = sensorTypeName;
    return {
      id: {
        commandClass: import_core.CommandClasses["Multilevel Sensor"],
        property
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Multilevel Sensor"],
        endpoint,
        property
      }), "endpoint"),
      get meta() {
        return {
          // Just the base metadata, to be extended using a config manager
          ...import_core.ValueMetadata.ReadOnlyNumber,
          label: sensorTypeName
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Sensor"] && (({ property, propertyKey }) => typeof property === "string" && property !== "supportedSensorTypes" && property !== "supportedScales" && propertyKey == void 0)(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const MultilevelSwitchCCValues = Object.freeze({
  currentValue: {
    id: {
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      property: "currentValue"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      endpoint,
      property: "currentValue"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Switch"] && valueId.property === "currentValue" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyLevel,
        label: "Current value"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  targetValue: {
    id: {
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      property: "targetValue"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      endpoint,
      property: "targetValue"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Switch"] && valueId.property === "targetValue" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Level,
        label: "Target value",
        valueChangeOptions: ["transitionDuration"]
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  duration: {
    id: {
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      property: "duration"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      endpoint,
      property: "duration"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Switch"] && valueId.property === "duration" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyDuration,
        label: "Remaining duration"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  restorePrevious: {
    id: {
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      property: "restorePrevious"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      endpoint,
      property: "restorePrevious"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Switch"] && valueId.property === "restorePrevious" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.WriteOnlyBoolean,
        label: "Restore previous value",
        states: {
          true: "Restore"
        }
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  compatEvent: {
    id: {
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      property: "event"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      endpoint,
      property: "event"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Switch"] && valueId.property === "event" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Event value"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: false,
      supportsEndpoints: true,
      autoCreate: /* @__PURE__ */ __name((applHost, endpoint) => !!applHost.getDeviceConfig?.(endpoint.nodeId)?.compat?.treatMultilevelSwitchSetAsEvent, "autoCreate")
    }
  },
  switchType: {
    id: {
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      property: "switchType"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      endpoint,
      property: "switchType"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Switch"] && valueId.property === "switchType" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  superviseStartStopLevelChange: {
    id: {
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      property: "superviseStartStopLevelChange"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Multilevel Switch"],
      endpoint: 0,
      // no endpoint support!
      property: "superviseStartStopLevelChange"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Switch"] && valueId.property === "superviseStartStopLevelChange" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  levelChangeUp: Object.assign((switchType) => {
    const property = (() => {
      {
        const switchTypeName = (0, import_shared.getEnumMemberName)(import_Types.SwitchType, switchType);
        const [, up] = (0, import_CCValueUtils.multilevelSwitchTypeToActions)(switchTypeName);
        return up;
      }
    })();
    return {
      id: {
        commandClass: import_core.CommandClasses["Multilevel Switch"],
        property
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Multilevel Switch"],
        endpoint,
        property
      }), "endpoint"),
      get meta() {
        const switchTypeName = (0, import_shared.getEnumMemberName)(import_Types.SwitchType, switchType);
        const [, up] = (0, import_CCValueUtils.multilevelSwitchTypeToActions)(switchTypeName);
        return {
          ...import_core.ValueMetadata.WriteOnlyBoolean,
          label: `Perform a level change (${up})`,
          valueChangeOptions: ["transitionDuration"],
          states: {
            true: "Start",
            false: "Stop"
          },
          ccSpecific: { switchType }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Switch"] && (({ property }) => typeof property === "string" && import_CCValueUtils.multilevelSwitchTypeProperties.indexOf(property) % 2 === 1)(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  levelChangeDown: Object.assign((switchType) => {
    const property = (() => {
      {
        const switchTypeName = (0, import_shared.getEnumMemberName)(import_Types.SwitchType, switchType);
        const [down] = (0, import_CCValueUtils.multilevelSwitchTypeToActions)(switchTypeName);
        return down;
      }
    })();
    return {
      id: {
        commandClass: import_core.CommandClasses["Multilevel Switch"],
        property
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Multilevel Switch"],
        endpoint,
        property
      }), "endpoint"),
      get meta() {
        const switchTypeName = (0, import_shared.getEnumMemberName)(import_Types.SwitchType, switchType);
        const [down] = (0, import_CCValueUtils.multilevelSwitchTypeToActions)(switchTypeName);
        return {
          ...import_core.ValueMetadata.WriteOnlyBoolean,
          label: `Perform a level change (${down})`,
          valueChangeOptions: ["transitionDuration"],
          states: {
            true: "Start",
            false: "Stop"
          },
          ccSpecific: { switchType }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Multilevel Switch"] && (({ property }) => typeof property === "string" && import_CCValueUtils.multilevelSwitchTypeProperties.indexOf(property) % 2 === 0)(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const NodeNamingAndLocationCCValues = Object.freeze({
  name: {
    id: {
      commandClass: import_core.CommandClasses["Node Naming and Location"],
      property: "name"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Node Naming and Location"],
      endpoint: 0,
      // no endpoint support!
      property: "name"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Node Naming and Location"] && valueId.property === "name" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.String,
        label: "Node name"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  location: {
    id: {
      commandClass: import_core.CommandClasses["Node Naming and Location"],
      property: "location"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Node Naming and Location"],
      endpoint: 0,
      // no endpoint support!
      property: "location"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Node Naming and Location"] && valueId.property === "location" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.String,
        label: "Node location"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  }
});
const NotificationCCValues = Object.freeze({
  supportsV1Alarm: {
    id: {
      commandClass: import_core.CommandClasses.Notification,
      property: "supportsV1Alarm"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Notification,
      endpoint: 0,
      // no endpoint support!
      property: "supportsV1Alarm"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && valueId.property === "supportsV1Alarm" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  supportedNotificationTypes: {
    id: {
      commandClass: import_core.CommandClasses.Notification,
      property: "supportedNotificationTypes"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Notification,
      endpoint: 0,
      // no endpoint support!
      property: "supportedNotificationTypes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && valueId.property === "supportedNotificationTypes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  notificationMode: {
    id: {
      commandClass: import_core.CommandClasses.Notification,
      property: "notificationMode"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Notification,
      endpoint: 0,
      // no endpoint support!
      property: "notificationMode"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && valueId.property === "notificationMode" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  lastRefresh: {
    id: {
      commandClass: import_core.CommandClasses.Notification,
      property: "lastRefresh"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Notification,
      endpoint,
      property: "lastRefresh"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && valueId.property === "lastRefresh" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  alarmType: {
    id: {
      commandClass: import_core.CommandClasses.Notification,
      property: "alarmType"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Notification,
      endpoint,
      property: "alarmType"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && valueId.property === "alarmType" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Alarm Type"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  alarmLevel: {
    id: {
      commandClass: import_core.CommandClasses.Notification,
      property: "alarmLevel"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Notification,
      endpoint,
      property: "alarmLevel"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && valueId.property === "alarmLevel" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Alarm Level"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  doorStateSimple: {
    id: {
      commandClass: import_core.CommandClasses.Notification,
      property: "Access Control",
      propertyKey: "Door state (simple)"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Notification,
      endpoint,
      property: "Access Control",
      propertyKey: "Door state (simple)"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && valueId.property === "Access Control" && valueId.propertyKey == "Door state (simple)";
    }, "is"),
    get meta() {
      return {
        // Must be a number for compatibility reasons
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Door state (simple)",
        states: {
          [22]: "Window/door is open",
          [23]: "Window/door is closed"
        },
        ccSpecific: {
          notificationType: 6
        }
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: shouldAutoCreateSimpleDoorSensorValue
    }
  },
  doorTiltState: {
    id: {
      commandClass: import_core.CommandClasses.Notification,
      property: "Access Control",
      propertyKey: "Door tilt state"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Notification,
      endpoint,
      property: "Access Control",
      propertyKey: "Door tilt state"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && valueId.property === "Access Control" && valueId.propertyKey == "Door tilt state";
    }, "is"),
    get meta() {
      return {
        // Must be a number for compatibility reasons
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Door tilt state",
        states: {
          [0]: "Window/door is not tilted",
          [1]: "Window/door is tilted"
        },
        ccSpecific: {
          notificationType: 6
        }
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: false
    }
  },
  supportedNotificationEvents: Object.assign((notificationType) => {
    const property = "supportedNotificationEvents";
    const propertyKey = notificationType;
    return {
      id: {
        commandClass: import_core.CommandClasses.Notification,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((_endpoint) => ({
        commandClass: import_core.CommandClasses.Notification,
        endpoint: 0,
        // no endpoint support!
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && (({ property, propertyKey }) => property === "supportedNotificationEvents" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  }),
  unknownNotificationType: Object.assign((notificationType) => {
    const property = `UNKNOWN_${(0, import_shared.num2hex)(notificationType)}`;
    return {
      id: {
        commandClass: import_core.CommandClasses.Notification,
        property
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Notification,
        endpoint,
        property
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyUInt8,
          label: `Unknown notification (${(0, import_shared.num2hex)(notificationType)})`,
          ccSpecific: { notificationType }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && (({ property }) => typeof property === "string" && property.startsWith("UNKNOWN_0x"))(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  unknownNotificationVariable: Object.assign((notificationType, notificationName) => {
    const property = notificationName;
    const propertyKey = "unknown";
    return {
      id: {
        commandClass: import_core.CommandClasses.Notification,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Notification,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyUInt8,
          label: `${notificationName}: Unknown value`,
          ccSpecific: { notificationType }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && (({ property, propertyKey }) => typeof property === "string" && propertyKey === "unknown")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  notificationVariable: Object.assign((notificationName, variableName) => {
    const property = notificationName;
    const propertyKey = variableName;
    return {
      id: {
        commandClass: import_core.CommandClasses.Notification,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses.Notification,
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Notification && (({ property, propertyKey }) => typeof property === "string" && typeof propertyKey === "string")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
function shouldAutoCreateSimpleDoorSensorValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  const supportedACEvents = valueDB.getValue(NotificationCCValues.supportedNotificationEvents(
    // Access Control
    6
  ).endpoint(endpoint.index));
  if (!supportedACEvents)
    return false;
  return supportedACEvents.includes(
    // Window/door is open
    22
  ) && supportedACEvents.includes(
    // Window/door is closed
    23
  );
}
__name(shouldAutoCreateSimpleDoorSensorValue, "shouldAutoCreateSimpleDoorSensorValue");
const ProtectionCCValues = Object.freeze({
  exclusiveControlNodeId: {
    id: {
      commandClass: import_core.CommandClasses.Protection,
      property: "exclusiveControlNodeId"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Protection,
      endpoint,
      property: "exclusiveControlNodeId"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Protection && valueId.property === "exclusiveControlNodeId" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        min: 1,
        max: import_core.MAX_NODES,
        label: "Node ID with exclusive control"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  localProtectionState: {
    id: {
      commandClass: import_core.CommandClasses.Protection,
      property: "local"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Protection,
      endpoint,
      property: "local"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Protection && valueId.property === "local" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Number,
        label: "Local protection state",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.LocalProtectionState)
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  rfProtectionState: {
    id: {
      commandClass: import_core.CommandClasses.Protection,
      property: "rf"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Protection,
      endpoint,
      property: "rf"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Protection && valueId.property === "rf" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Number,
        label: "RF protection state",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.RFProtectionState)
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  timeout: {
    id: {
      commandClass: import_core.CommandClasses.Protection,
      property: "timeout"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Protection,
      endpoint,
      property: "timeout"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Protection && valueId.property === "timeout" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        label: "RF protection timeout"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsExclusiveControl: {
    id: {
      commandClass: import_core.CommandClasses.Protection,
      property: "supportsExclusiveControl"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Protection,
      endpoint,
      property: "supportsExclusiveControl"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Protection && valueId.property === "supportsExclusiveControl" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsTimeout: {
    id: {
      commandClass: import_core.CommandClasses.Protection,
      property: "supportsTimeout"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Protection,
      endpoint,
      property: "supportsTimeout"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Protection && valueId.property === "supportsTimeout" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedLocalStates: {
    id: {
      commandClass: import_core.CommandClasses.Protection,
      property: "supportedLocalStates"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Protection,
      endpoint,
      property: "supportedLocalStates"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Protection && valueId.property === "supportedLocalStates" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedRFStates: {
    id: {
      commandClass: import_core.CommandClasses.Protection,
      property: "supportedRFStates"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Protection,
      endpoint,
      property: "supportedRFStates"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Protection && valueId.property === "supportedRFStates" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const SceneActivationCCValues = Object.freeze({
  sceneId: {
    id: {
      commandClass: import_core.CommandClasses["Scene Activation"],
      property: "sceneId"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Scene Activation"],
      endpoint,
      property: "sceneId"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Scene Activation"] && valueId.property === "sceneId" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        min: 1,
        label: "Scene ID",
        valueChangeOptions: ["transitionDuration"]
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: false,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  dimmingDuration: {
    id: {
      commandClass: import_core.CommandClasses["Scene Activation"],
      property: "dimmingDuration"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Scene Activation"],
      endpoint,
      property: "dimmingDuration"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Scene Activation"] && valueId.property === "dimmingDuration" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Duration,
        label: "Dimming duration"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const SceneActuatorConfigurationCCValues = Object.freeze({
  level: Object.assign((sceneId) => {
    const property = "level";
    const propertyKey = sceneId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Scene Actuator Configuration"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Scene Actuator Configuration"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.UInt8,
          label: `Level (${sceneId})`,
          valueChangeOptions: ["transitionDuration"]
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Scene Actuator Configuration"] && (({ property, propertyKey }) => property === "level" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  dimmingDuration: Object.assign((sceneId) => {
    const property = "dimmingDuration";
    const propertyKey = sceneId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Scene Actuator Configuration"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Scene Actuator Configuration"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Duration,
          label: `Dimming duration (${sceneId})`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Scene Actuator Configuration"] && (({ property, propertyKey }) => property === "dimmingDuration" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const SceneControllerConfigurationCCValues = Object.freeze({
  sceneId: Object.assign((groupId) => {
    const property = "sceneId";
    const propertyKey = groupId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Scene Controller Configuration"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Scene Controller Configuration"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.UInt8,
          label: `Associated Scene ID (${groupId})`,
          valueChangeOptions: ["transitionDuration"]
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Scene Controller Configuration"] && (({ property, propertyKey }) => property === "sceneId" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  dimmingDuration: Object.assign((groupId) => {
    const property = "dimmingDuration";
    const propertyKey = groupId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Scene Controller Configuration"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Scene Controller Configuration"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Duration,
          label: `Dimming duration (${groupId})`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Scene Controller Configuration"] && (({ property, propertyKey }) => property === "dimmingDuration" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const ScheduleEntryLockCCValues = Object.freeze({
  numWeekDaySlots: {
    id: {
      commandClass: import_core.CommandClasses["Schedule Entry Lock"],
      property: "numWeekDaySlots"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Schedule Entry Lock"],
      endpoint,
      property: "numWeekDaySlots"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Schedule Entry Lock"] && valueId.property === "numWeekDaySlots" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  numYearDaySlots: {
    id: {
      commandClass: import_core.CommandClasses["Schedule Entry Lock"],
      property: "numYearDaySlots"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Schedule Entry Lock"],
      endpoint,
      property: "numYearDaySlots"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Schedule Entry Lock"] && valueId.property === "numYearDaySlots" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  numDailyRepeatingSlots: {
    id: {
      commandClass: import_core.CommandClasses["Schedule Entry Lock"],
      property: "numDailyRepeatingSlots"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Schedule Entry Lock"],
      endpoint,
      property: "numDailyRepeatingSlots"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Schedule Entry Lock"] && valueId.property === "numDailyRepeatingSlots" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  userEnabled: Object.assign((userId) => {
    const property = "userEnabled";
    const propertyKey = userId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Schedule Entry Lock"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Schedule Entry Lock"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Schedule Entry Lock"] && (({ property, propertyKey }) => property === "userEnabled" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  scheduleKind: Object.assign((userId) => {
    const property = "scheduleKind";
    const propertyKey = userId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Schedule Entry Lock"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Schedule Entry Lock"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Schedule Entry Lock"] && (({ property, propertyKey }) => property === "scheduleKind" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  schedule: Object.assign((scheduleKind, userId, slotId) => {
    const property = "schedule";
    const propertyKey = scheduleKind << 16 | userId << 8 | slotId;
    return {
      id: {
        commandClass: import_core.CommandClasses["Schedule Entry Lock"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Schedule Entry Lock"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Schedule Entry Lock"] && (({ property, propertyKey }) => property === "schedule" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const SoundSwitchCCValues = Object.freeze({
  volume: {
    id: {
      commandClass: import_core.CommandClasses["Sound Switch"],
      property: "volume"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Sound Switch"],
      endpoint,
      property: "volume"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Sound Switch"] && valueId.property === "volume" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        min: 0,
        max: 100,
        unit: "%",
        label: "Volume",
        allowManualEntry: true,
        states: {
          0: "default"
        }
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  toneId: {
    id: {
      commandClass: import_core.CommandClasses["Sound Switch"],
      property: "toneId"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Sound Switch"],
      endpoint,
      property: "toneId"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Sound Switch"] && valueId.property === "toneId" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        label: "Play Tone",
        valueChangeOptions: ["volume"]
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  defaultVolume: {
    id: {
      commandClass: import_core.CommandClasses["Sound Switch"],
      property: "defaultVolume"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Sound Switch"],
      endpoint,
      property: "defaultVolume"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Sound Switch"] && valueId.property === "defaultVolume" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Number,
        min: 0,
        max: 100,
        unit: "%",
        label: "Default volume"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  defaultToneId: {
    id: {
      commandClass: import_core.CommandClasses["Sound Switch"],
      property: "defaultToneId"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Sound Switch"],
      endpoint,
      property: "defaultToneId"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Sound Switch"] && valueId.property === "defaultToneId" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Number,
        min: 1,
        max: 254,
        label: "Default tone ID"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const SupervisionCCValues = Object.freeze({
  ccSupported: Object.assign((ccId) => {
    const property = "ccSupported";
    const propertyKey = ccId;
    return {
      id: {
        commandClass: import_core.CommandClasses.Supervision,
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((_endpoint) => ({
        commandClass: import_core.CommandClasses.Supervision,
        endpoint: 0,
        // no endpoint support!
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Supervision && (({ property, propertyKey }) => property === "commandSupported" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  })
});
const ThermostatFanModeCCValues = Object.freeze({
  turnedOff: {
    id: {
      commandClass: import_core.CommandClasses["Thermostat Fan Mode"],
      property: "off"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Thermostat Fan Mode"],
      endpoint,
      property: "off"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Fan Mode"] && valueId.property === "off" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Boolean,
        label: "Thermostat fan turned off"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  fanMode: {
    id: {
      commandClass: import_core.CommandClasses["Thermostat Fan Mode"],
      property: "mode"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Thermostat Fan Mode"],
      endpoint,
      property: "mode"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Fan Mode"] && valueId.property === "mode" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.ThermostatFanMode),
        label: "Thermostat fan mode"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedFanModes: {
    id: {
      commandClass: import_core.CommandClasses["Thermostat Fan Mode"],
      property: "supportedModes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Thermostat Fan Mode"],
      endpoint,
      property: "supportedModes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Fan Mode"] && valueId.property === "supportedModes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const ThermostatFanStateCCValues = Object.freeze({
  fanState: {
    id: {
      commandClass: import_core.CommandClasses["Thermostat Fan State"],
      property: "state"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Thermostat Fan State"],
      endpoint,
      property: "state"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Fan State"] && valueId.property === "state" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.ThermostatFanState),
        label: "Thermostat fan state"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const ThermostatModeCCValues = Object.freeze({
  thermostatMode: {
    id: {
      commandClass: import_core.CommandClasses["Thermostat Mode"],
      property: "mode"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Thermostat Mode"],
      endpoint,
      property: "mode"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Mode"] && valueId.property === "mode" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt8,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.ThermostatMode),
        label: "Thermostat mode"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  manufacturerData: {
    id: {
      commandClass: import_core.CommandClasses["Thermostat Mode"],
      property: "manufacturerData"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Thermostat Mode"],
      endpoint,
      property: "manufacturerData"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Mode"] && valueId.property === "manufacturerData" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyBuffer,
        label: "Manufacturer data"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedModes: {
    id: {
      commandClass: import_core.CommandClasses["Thermostat Mode"],
      property: "supportedModes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Thermostat Mode"],
      endpoint,
      property: "supportedModes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Mode"] && valueId.property === "supportedModes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const ThermostatOperatingStateCCValues = Object.freeze({
  operatingState: {
    id: {
      commandClass: import_core.CommandClasses["Thermostat Operating State"],
      property: "state"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Thermostat Operating State"],
      endpoint,
      property: "state"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Operating State"] && valueId.property === "state" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyUInt8,
        label: "Operating state",
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.ThermostatOperatingState)
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const ThermostatSetpointCCValues = Object.freeze({
  supportedSetpointTypes: {
    id: {
      commandClass: import_core.CommandClasses["Thermostat Setpoint"],
      property: "supportedSetpointTypes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Thermostat Setpoint"],
      endpoint,
      property: "supportedSetpointTypes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Setpoint"] && valueId.property === "supportedSetpointTypes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  setpoint: Object.assign((setpointType) => {
    const property = "setpoint";
    const propertyKey = setpointType;
    return {
      id: {
        commandClass: import_core.CommandClasses["Thermostat Setpoint"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Thermostat Setpoint"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Number,
          label: `Setpoint (${(0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, setpointType)})`,
          ccSpecific: { setpointType }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Setpoint"] && (({ property, propertyKey }) => property === "setpoint" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  setpointScale: Object.assign((setpointType) => {
    const property = "setpointScale";
    const propertyKey = setpointType;
    return {
      id: {
        commandClass: import_core.CommandClasses["Thermostat Setpoint"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Thermostat Setpoint"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Thermostat Setpoint"] && (({ property, propertyKey }) => property === "setpointScale" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const TimeParametersCCValues = Object.freeze({
  dateAndTime: {
    id: {
      commandClass: import_core.CommandClasses["Time Parameters"],
      property: "dateAndTime"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Time Parameters"],
      endpoint,
      property: "dateAndTime"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Time Parameters"] && valueId.property === "dateAndTime" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.Any,
        label: "Date and Time"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const UserCodeCCValues = Object.freeze({
  supportedUsers: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportedUsers"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportedUsers"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportedUsers" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsAdminCode: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportsAdminCode"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportsAdminCode"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportsAdminCode" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsAdminCodeDeactivation: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportsAdminCodeDeactivation"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportsAdminCodeDeactivation"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportsAdminCodeDeactivation" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  _deprecated_supportsMasterCode: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportsMasterCode"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportsMasterCode"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportsMasterCode" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  _deprecated_supportsMasterCodeDeactivation: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportsMasterCodeDeactivation"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportsMasterCodeDeactivation"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportsMasterCodeDeactivation" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsUserCodeChecksum: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportsUserCodeChecksum"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportsUserCodeChecksum"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportsUserCodeChecksum" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsMultipleUserCodeReport: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportsMultipleUserCodeReport"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportsMultipleUserCodeReport"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportsMultipleUserCodeReport" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportsMultipleUserCodeSet: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportsMultipleUserCodeSet"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportsMultipleUserCodeSet"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportsMultipleUserCodeSet" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedUserIDStatuses: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportedUserIDStatuses"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportedUserIDStatuses"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportedUserIDStatuses" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedKeypadModes: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportedKeypadModes"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportedKeypadModes"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportedKeypadModes" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  supportedASCIIChars: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "supportedASCIIChars"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "supportedASCIIChars"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "supportedASCIIChars" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  userCodeChecksum: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "userCodeChecksum"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "userCodeChecksum"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "userCodeChecksum" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  keypadMode: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "keypadMode"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "keypadMode"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "keypadMode" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyNumber,
        label: "Keypad Mode"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  adminCode: {
    id: {
      commandClass: import_core.CommandClasses["User Code"],
      property: "adminCode"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["User Code"],
      endpoint,
      property: "adminCode"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && valueId.property === "adminCode" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.String,
        label: "Admin Code",
        minLength: 4,
        maxLength: 10
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: true,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  userIdStatus: Object.assign((userId) => {
    const property = "userIdStatus";
    const propertyKey = userId;
    return {
      id: {
        commandClass: import_core.CommandClasses["User Code"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["User Code"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.Number,
          label: `User ID status (${userId})`
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && (({ property, propertyKey }) => property === "userIdStatus" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  userCode: Object.assign((userId) => {
    const property = "userCode";
    const propertyKey = userId;
    return {
      id: {
        commandClass: import_core.CommandClasses["User Code"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["User Code"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return import_core.ValueMetadata.Any;
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["User Code"] && (({ property, propertyKey }) => property === "userCode" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: true,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const VersionCCValues = Object.freeze({
  firmwareVersions: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "firmwareVersions"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "firmwareVersions"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "firmwareVersions" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnly,
        type: "string[]",
        label: "Z-Wave chip firmware versions"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  libraryType: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "libraryType"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "libraryType"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "libraryType" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyNumber,
        label: "Library type",
        states: (0, import_core.enumValuesToMetadataStates)(import_core.ZWaveLibraryTypes)
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  protocolVersion: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "protocolVersion"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "protocolVersion"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "protocolVersion" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Z-Wave protocol version"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  hardwareVersion: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "hardwareVersion"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "hardwareVersion"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "hardwareVersion" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyNumber,
        label: "Z-Wave chip hardware version"
      };
    },
    options: {
      internal: false,
      minVersion: 2,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  supportsZWaveSoftwareGet: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "supportsZWaveSoftwareGet"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint,
      property: "supportsZWaveSoftwareGet"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "supportsZWaveSoftwareGet" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  sdkVersion: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "sdkVersion"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "sdkVersion"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "sdkVersion" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "SDK version"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  applicationFrameworkAPIVersion: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "applicationFrameworkAPIVersion"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "applicationFrameworkAPIVersion"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "applicationFrameworkAPIVersion" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Z-Wave application framework API version"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  applicationFrameworkBuildNumber: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "applicationFrameworkBuildNumber"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "applicationFrameworkBuildNumber"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "applicationFrameworkBuildNumber" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Z-Wave application framework API build number"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  serialAPIVersion: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "hostInterfaceVersion"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "hostInterfaceVersion"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "hostInterfaceVersion" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Serial API version"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  serialAPIBuildNumber: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "hostInterfaceBuildNumber"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "hostInterfaceBuildNumber"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "hostInterfaceBuildNumber" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Serial API build number"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  zWaveProtocolVersion: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "zWaveProtocolVersion"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "zWaveProtocolVersion"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "zWaveProtocolVersion" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Z-Wave protocol version"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  zWaveProtocolBuildNumber: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "zWaveProtocolBuildNumber"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "zWaveProtocolBuildNumber"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "zWaveProtocolBuildNumber" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Z-Wave protocol build number"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  applicationVersion: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "applicationVersion"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "applicationVersion"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "applicationVersion" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Application version"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  applicationBuildNumber: {
    id: {
      commandClass: import_core.CommandClasses.Version,
      property: "applicationBuildNumber"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses.Version,
      endpoint: 0,
      // no endpoint support!
      property: "applicationBuildNumber"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses.Version && valueId.property === "applicationBuildNumber" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnlyString,
        label: "Application build number"
      };
    },
    options: {
      internal: false,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  }
});
const WakeUpCCValues = Object.freeze({
  controllerNodeId: {
    id: {
      commandClass: import_core.CommandClasses["Wake Up"],
      property: "controllerNodeId"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Wake Up"],
      endpoint: 0,
      // no endpoint support!
      property: "controllerNodeId"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Wake Up"] && valueId.property === "controllerNodeId" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.ReadOnly,
        label: "Node ID of the controller"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  wakeUpInterval: {
    id: {
      commandClass: import_core.CommandClasses["Wake Up"],
      property: "wakeUpInterval"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Wake Up"],
      endpoint: 0,
      // no endpoint support!
      property: "wakeUpInterval"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Wake Up"] && valueId.property === "wakeUpInterval" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return {
        ...import_core.ValueMetadata.UInt24,
        label: "Wake Up interval"
      };
    },
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  wakeUpOnDemandSupported: {
    id: {
      commandClass: import_core.CommandClasses["Wake Up"],
      property: "wakeUpOnDemandSupported"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Wake Up"],
      endpoint: 0,
      // no endpoint support!
      property: "wakeUpOnDemandSupported"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Wake Up"] && valueId.property === "wakeUpOnDemandSupported" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 3,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  }
});
const WindowCoveringCCValues = Object.freeze({
  supportedParameters: {
    id: {
      commandClass: import_core.CommandClasses["Window Covering"],
      property: "supportedParameters"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Window Covering"],
      endpoint,
      property: "supportedParameters"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Window Covering"] && valueId.property === "supportedParameters" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  currentValue: Object.assign((parameter) => {
    const property = "currentValue";
    const propertyKey = parameter;
    return {
      id: {
        commandClass: import_core.CommandClasses["Window Covering"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Window Covering"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyLevel,
          label: `Current value - ${(0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, parameter)}`,
          states: (0, import_CCValueUtils.windowCoveringParameterToMetadataStates)(parameter),
          ccSpecific: { parameter }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Window Covering"] && (({ property, propertyKey }) => property === "currentValue" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  targetValue: Object.assign((parameter) => {
    const property = "targetValue";
    const propertyKey = parameter;
    return {
      id: {
        commandClass: import_core.CommandClasses["Window Covering"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Window Covering"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        const writeable = parameter % 2 === 1;
        return {
          ...import_core.ValueMetadata.Level,
          label: `Target value - ${(0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, parameter)}`,
          // Only odd-numbered parameters have position support and are writable
          writeable: parameter % 2 === 1,
          states: (0, import_CCValueUtils.windowCoveringParameterToMetadataStates)(parameter),
          allowManualEntry: writeable,
          ccSpecific: { parameter },
          valueChangeOptions: ["transitionDuration"]
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Window Covering"] && (({ property, propertyKey }) => property === "targetValue" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  duration: Object.assign((parameter) => {
    const property = "duration";
    const propertyKey = parameter;
    return {
      id: {
        commandClass: import_core.CommandClasses["Window Covering"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Window Covering"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.ReadOnlyDuration,
          label: `Remaining duration - ${(0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, parameter)}`,
          ccSpecific: {
            parameter
          }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Window Covering"] && (({ property, propertyKey }) => property === "duration" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  levelChangeUp: Object.assign((parameter) => {
    const property = "levelChangeUp";
    const propertyKey = parameter;
    return {
      id: {
        commandClass: import_core.CommandClasses["Window Covering"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Window Covering"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.WriteOnlyBoolean,
          label: `${(0, import_CCValueUtils.windowCoveringParameterToLevelChangeLabel)(parameter, "up")} - ${(0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, parameter)}`,
          valueChangeOptions: ["transitionDuration"],
          states: {
            true: "Start",
            false: "Stop"
          },
          ccSpecific: { parameter }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Window Covering"] && (({ property, propertyKey }) => property === "levelChangeUp" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }),
  levelChangeDown: Object.assign((parameter) => {
    const property = "levelChangeDown";
    const propertyKey = parameter;
    return {
      id: {
        commandClass: import_core.CommandClasses["Window Covering"],
        property,
        propertyKey
      },
      endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
        commandClass: import_core.CommandClasses["Window Covering"],
        endpoint,
        property,
        propertyKey
      }), "endpoint"),
      get meta() {
        return {
          ...import_core.ValueMetadata.WriteOnlyBoolean,
          label: `${(0, import_CCValueUtils.windowCoveringParameterToLevelChangeLabel)(parameter, "down")} - ${(0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, parameter)}`,
          valueChangeOptions: ["transitionDuration"],
          states: {
            true: "Start",
            false: "Stop"
          },
          ccSpecific: { parameter }
        };
      }
    };
  }, {
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Window Covering"] && (({ property, propertyKey }) => property === "levelChangeDown" && typeof propertyKey === "number")(valueId);
    }, "is"),
    options: {
      internal: false,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  })
});
const ZWavePlusCCValues = Object.freeze({
  zwavePlusVersion: {
    id: {
      commandClass: import_core.CommandClasses["Z-Wave Plus Info"],
      property: "zwavePlusVersion"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Z-Wave Plus Info"],
      endpoint: 0,
      // no endpoint support!
      property: "zwavePlusVersion"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Z-Wave Plus Info"] && valueId.property === "zwavePlusVersion" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  nodeType: {
    id: {
      commandClass: import_core.CommandClasses["Z-Wave Plus Info"],
      property: "nodeType"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Z-Wave Plus Info"],
      endpoint: 0,
      // no endpoint support!
      property: "nodeType"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Z-Wave Plus Info"] && valueId.property === "nodeType" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  roleType: {
    id: {
      commandClass: import_core.CommandClasses["Z-Wave Plus Info"],
      property: "roleType"
    },
    endpoint: /* @__PURE__ */ __name((_endpoint) => ({
      commandClass: import_core.CommandClasses["Z-Wave Plus Info"],
      endpoint: 0,
      // no endpoint support!
      property: "roleType"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Z-Wave Plus Info"] && valueId.property === "roleType" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: false,
      autoCreate: true
    }
  },
  userIcon: {
    id: {
      commandClass: import_core.CommandClasses["Z-Wave Plus Info"],
      property: "userIcon"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Z-Wave Plus Info"],
      endpoint,
      property: "userIcon"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Z-Wave Plus Info"] && valueId.property === "userIcon" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  },
  installerIcon: {
    id: {
      commandClass: import_core.CommandClasses["Z-Wave Plus Info"],
      property: "installerIcon"
    },
    endpoint: /* @__PURE__ */ __name((endpoint = 0) => ({
      commandClass: import_core.CommandClasses["Z-Wave Plus Info"],
      endpoint,
      property: "installerIcon"
    }), "endpoint"),
    is: /* @__PURE__ */ __name((valueId) => {
      return valueId.commandClass === import_core.CommandClasses["Z-Wave Plus Info"] && valueId.property === "installerIcon" && valueId.propertyKey == void 0;
    }, "is"),
    get meta() {
      return import_core.ValueMetadata.Any;
    },
    options: {
      internal: true,
      minVersion: 1,
      secret: false,
      stateful: true,
      supportsEndpoints: true,
      autoCreate: true
    }
  }
});
const CCValues = {
  [import_core.CommandClasses["Alarm Sensor"]]: AlarmSensorCCValues,
  [import_core.CommandClasses.Association]: AssociationCCValues,
  [import_core.CommandClasses["Association Group Information"]]: AssociationGroupInfoCCValues,
  [import_core.CommandClasses["Barrier Operator"]]: BarrierOperatorCCValues,
  [import_core.CommandClasses.Basic]: BasicCCValues,
  [import_core.CommandClasses["Basic Window Covering"]]: BasicWindowCoveringCCValues,
  [import_core.CommandClasses.Battery]: BatteryCCValues,
  [import_core.CommandClasses["Binary Sensor"]]: BinarySensorCCValues,
  [import_core.CommandClasses["Binary Switch"]]: BinarySwitchCCValues,
  [import_core.CommandClasses["Central Scene"]]: CentralSceneCCValues,
  [import_core.CommandClasses["Climate Control Schedule"]]: ClimateControlScheduleCCValues,
  [import_core.CommandClasses["Color Switch"]]: ColorSwitchCCValues,
  [import_core.CommandClasses.Configuration]: ConfigurationCCValues,
  [import_core.CommandClasses["Door Lock"]]: DoorLockCCValues,
  [import_core.CommandClasses["Door Lock Logging"]]: DoorLockLoggingCCValues,
  [import_core.CommandClasses["Energy Production"]]: EnergyProductionCCValues,
  [import_core.CommandClasses["Entry Control"]]: EntryControlCCValues,
  [import_core.CommandClasses["Firmware Update Meta Data"]]: FirmwareUpdateMetaDataCCValues,
  [import_core.CommandClasses["Humidity Control Mode"]]: HumidityControlModeCCValues,
  [import_core.CommandClasses["Humidity Control Operating State"]]: HumidityControlOperatingStateCCValues,
  [import_core.CommandClasses["Humidity Control Setpoint"]]: HumidityControlSetpointCCValues,
  [import_core.CommandClasses.Indicator]: IndicatorCCValues,
  [import_core.CommandClasses.Irrigation]: IrrigationCCValues,
  [import_core.CommandClasses.Language]: LanguageCCValues,
  [import_core.CommandClasses.Lock]: LockCCValues,
  [import_core.CommandClasses["Manufacturer Specific"]]: ManufacturerSpecificCCValues,
  [import_core.CommandClasses.Meter]: MeterCCValues,
  [import_core.CommandClasses["Multi Channel Association"]]: MultiChannelAssociationCCValues,
  [import_core.CommandClasses["Multi Channel"]]: MultiChannelCCValues,
  [import_core.CommandClasses["Multilevel Sensor"]]: MultilevelSensorCCValues,
  [import_core.CommandClasses["Multilevel Switch"]]: MultilevelSwitchCCValues,
  [import_core.CommandClasses["Node Naming and Location"]]: NodeNamingAndLocationCCValues,
  [import_core.CommandClasses.Notification]: NotificationCCValues,
  [import_core.CommandClasses.Protection]: ProtectionCCValues,
  [import_core.CommandClasses["Scene Activation"]]: SceneActivationCCValues,
  [import_core.CommandClasses["Scene Actuator Configuration"]]: SceneActuatorConfigurationCCValues,
  [import_core.CommandClasses["Scene Controller Configuration"]]: SceneControllerConfigurationCCValues,
  [import_core.CommandClasses["Schedule Entry Lock"]]: ScheduleEntryLockCCValues,
  [import_core.CommandClasses["Sound Switch"]]: SoundSwitchCCValues,
  [import_core.CommandClasses.Supervision]: SupervisionCCValues,
  [import_core.CommandClasses["Thermostat Fan Mode"]]: ThermostatFanModeCCValues,
  [import_core.CommandClasses["Thermostat Fan State"]]: ThermostatFanStateCCValues,
  [import_core.CommandClasses["Thermostat Mode"]]: ThermostatModeCCValues,
  [import_core.CommandClasses["Thermostat Operating State"]]: ThermostatOperatingStateCCValues,
  [import_core.CommandClasses["Thermostat Setpoint"]]: ThermostatSetpointCCValues,
  [import_core.CommandClasses["Time Parameters"]]: TimeParametersCCValues,
  [import_core.CommandClasses["User Code"]]: UserCodeCCValues,
  [import_core.CommandClasses.Version]: VersionCCValues,
  [import_core.CommandClasses["Wake Up"]]: WakeUpCCValues,
  [import_core.CommandClasses["Window Covering"]]: WindowCoveringCCValues,
  [import_core.CommandClasses["Z-Wave Plus Info"]]: ZWavePlusCCValues
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AlarmSensorCCValues,
  AssociationCCValues,
  AssociationGroupInfoCCValues,
  BarrierOperatorCCValues,
  BasicCCValues,
  BasicWindowCoveringCCValues,
  BatteryCCValues,
  BinarySensorCCValues,
  BinarySwitchCCValues,
  CCValues,
  CentralSceneCCValues,
  ClimateControlScheduleCCValues,
  ColorSwitchCCValues,
  ConfigurationCCValues,
  DoorLockCCValues,
  DoorLockLoggingCCValues,
  EnergyProductionCCValues,
  EntryControlCCValues,
  FirmwareUpdateMetaDataCCValues,
  HumidityControlModeCCValues,
  HumidityControlOperatingStateCCValues,
  HumidityControlSetpointCCValues,
  IndicatorCCValues,
  IrrigationCCValues,
  LanguageCCValues,
  LockCCValues,
  ManufacturerSpecificCCValues,
  MeterCCValues,
  MultiChannelAssociationCCValues,
  MultiChannelCCValues,
  MultilevelSensorCCValues,
  MultilevelSwitchCCValues,
  NodeNamingAndLocationCCValues,
  NotificationCCValues,
  ProtectionCCValues,
  SceneActivationCCValues,
  SceneActuatorConfigurationCCValues,
  SceneControllerConfigurationCCValues,
  ScheduleEntryLockCCValues,
  SoundSwitchCCValues,
  SupervisionCCValues,
  ThermostatFanModeCCValues,
  ThermostatFanStateCCValues,
  ThermostatModeCCValues,
  ThermostatOperatingStateCCValues,
  ThermostatSetpointCCValues,
  TimeParametersCCValues,
  UserCodeCCValues,
  VersionCCValues,
  WakeUpCCValues,
  WindowCoveringCCValues,
  ZWavePlusCCValues
});
//# sourceMappingURL=_CCValues.generated.js.map
