"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CommandClass_exports = {};
__export(CommandClass_exports, {
  CCRaw: () => CCRaw,
  CommandClass: () => CommandClass,
  InvalidCC: () => InvalidCC,
  getEffectiveCCVersion: () => getEffectiveCCVersion
});
module.exports = __toCommonJS(CommandClass_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_CommandClassDecorators = require("./CommandClassDecorators.js");
var import_EncapsulatingCommandClass = require("./EncapsulatingCommandClass.js");
var import_Values = require("./Values.js");
function getEffectiveCCVersion(ctx, cc, defaultVersion) {
  if (typeof cc.nodeId !== "number" || cc.nodeId === import_core.NODE_ID_BROADCAST || cc.nodeId === import_core.NODE_ID_BROADCAST_LR) {
    return (0, import_CommandClassDecorators.getImplementedVersion)(cc.ccId);
  }
  return ctx.getSupportedCCVersion(cc.ccId, cc.nodeId, cc.endpointIndex) || (defaultVersion ?? (0, import_CommandClassDecorators.getImplementedVersion)(cc.ccId));
}
__name(getEffectiveCCVersion, "getEffectiveCCVersion");
class CCRaw {
  static {
    __name(this, "CCRaw");
  }
  ccId;
  ccCommand;
  payload;
  constructor(ccId, ccCommand, payload) {
    this.ccId = ccId;
    this.ccCommand = ccCommand;
    this.payload = payload;
  }
  static parse(data) {
    const { ccId, bytesRead: ccIdLength } = (0, import_core.parseCCId)(data);
    if (ccId === import_core.CommandClasses["No Operation"]) {
      return new CCRaw(ccId, void 0, new import_shared.Bytes());
    }
    let ccCommand = data[ccIdLength];
    let payload = import_shared.Bytes.view(data.subarray(ccIdLength + 1));
    if (ccId === import_core.CommandClasses["Transport Service"]) {
      payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([ccCommand & 7]),
        payload
      ]);
      ccCommand = ccCommand & 248;
    } else if (ccId === import_core.CommandClasses["Manufacturer Proprietary"]) {
      payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([ccCommand]),
        payload
      ]);
      ccCommand = void 0;
    }
    return new CCRaw(ccId, ccCommand, payload);
  }
  withPayload(payload) {
    return new CCRaw(this.ccId, this.ccCommand, payload);
  }
}
class CommandClass {
  static {
    __name(this, "CommandClass");
  }
  // empty constructor to parse messages
  constructor(options) {
    const { nodeId, endpointIndex = 0, ccId = (0, import_CommandClassDecorators.getCommandClass)(this), ccCommand = (0, import_CommandClassDecorators.getCCCommand)(this), payload = new Uint8Array() } = options;
    this.nodeId = nodeId;
    this.endpointIndex = endpointIndex;
    this.ccId = ccId;
    this.ccCommand = ccCommand;
    this.payload = import_shared.Bytes.view(payload);
  }
  static async parse(data, ctx) {
    const raw = CCRaw.parse(data);
    const CCConstructor = (0, import_CommandClassDecorators.getCCConstructor)(raw.ccId);
    if (!CCConstructor) {
      return await CommandClass.from(raw, ctx);
    }
    let CommandConstructor;
    if (raw.ccCommand != void 0) {
      CommandConstructor = (0, import_CommandClassDecorators.getCCCommandConstructor)(raw.ccId, raw.ccCommand);
    }
    try {
      return await (CommandConstructor ?? CCConstructor).from(raw, ctx);
    } catch (e) {
      if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.PacketFormat_InvalidPayload) {
        const ccName = CommandConstructor?.name ?? `${(0, import_core.getCCName)(raw.ccId)} CC`;
        let reason;
        if (typeof e.context === "string" || typeof e.context === "number" && import_core.ZWaveErrorCodes[e.context] != void 0) {
          reason = e.context;
        }
        const ret = new InvalidCC({
          nodeId: ctx.sourceNodeId,
          ccId: raw.ccId,
          ccCommand: raw.ccCommand,
          ccName,
          reason
        });
        return ret;
      }
      throw e;
    }
  }
  static from(raw, ctx) {
    return new this({
      nodeId: ctx.sourceNodeId,
      ccId: raw.ccId,
      ccCommand: raw.ccCommand,
      payload: raw.payload
    });
  }
  /** This CC's identifier */
  ccId;
  ccCommand;
  get ccName() {
    return (0, import_core.getCCName)(this.ccId);
  }
  /** The ID of the target node(s) */
  nodeId;
  payload;
  /** Which endpoint of the node this CC belongs to. 0 for the root device. */
  endpointIndex;
  /**
   * Which encapsulation CCs this CC is/was/should be encapsulated with.
   *
   * Don't use this directly, this is used internally.
   */
  encapsulationFlags = import_core.EncapsulationFlags.None;
  /** Activates or deactivates the given encapsulation flag(s) */
  toggleEncapsulationFlag(flag, active) {
    if (active) {
      this.encapsulationFlags |= flag;
    } else {
      this.encapsulationFlags &= ~flag;
    }
  }
  /** Contains a reference to the encapsulating CC if this CC is encapsulated */
  encapsulatingCC;
  /** The type of Z-Wave frame this CC was sent with */
  frameType;
  /** Returns true if this CC is an extended CC (0xF100..0xFFFF) */
  isExtended() {
    return this.ccId >= 61696;
  }
  /** Whether the interview for this CC was previously completed */
  isInterviewComplete(host) {
    return !!this.getValueDB(host).getValue({
      commandClass: this.ccId,
      endpoint: this.endpointIndex,
      property: "interviewComplete"
    });
  }
  /** Marks the interview for this CC as complete or not */
  setInterviewComplete(host, complete) {
    this.getValueDB(host).setValue({
      commandClass: this.ccId,
      endpoint: this.endpointIndex,
      property: "interviewComplete"
    }, complete);
  }
  /**
   * Serializes this CommandClass to be embedded in a message payload or another CC
   */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/require-await
  async serialize(ctx) {
    if (this.ccId === import_core.CommandClasses["No Operation"]) {
      return import_shared.Bytes.from([this.ccId]);
    } else if (this.ccCommand == void 0) {
      throw new import_core.ZWaveError("Cannot serialize a Command Class without a command", import_core.ZWaveErrorCodes.CC_Invalid);
    }
    const payloadLength = this.payload.length;
    const ccIdLength = this.isExtended() ? 2 : 1;
    const data = new import_shared.Bytes(ccIdLength + 1 + payloadLength);
    data.writeUIntBE(this.ccId, 0, ccIdLength);
    data[ccIdLength] = this.ccCommand;
    if (payloadLength > 0) {
      data.set(this.payload, 1 + ccIdLength);
    }
    return data;
  }
  prepareRetransmission() {
  }
  /**
   * Create an instance of the given CC without checking whether it is supported.
   * If the CC is implemented, this returns an instance of the given CC which is linked to the given endpoint.
   *
   * **INTERNAL:** Applications should not use this directly.
   */
  static createInstanceUnchecked(endpoint, cc) {
    const Constructor = typeof cc === "number" ? (0, import_CommandClassDecorators.getCCConstructor)(cc) : cc;
    if (Constructor) {
      return new Constructor({
        nodeId: endpoint.nodeId,
        endpointIndex: endpoint.index
      });
    }
  }
  /** Generates a representation of this CC for the log */
  toLogEntry(_ctx) {
    let tag = this.constructor.name;
    const message = {};
    if (this.constructor === CommandClass) {
      tag = `${(0, import_shared.getEnumMemberName)(import_core.CommandClasses, this.ccId)} CC (not implemented)`;
      if (this.ccCommand != void 0) {
        message.command = (0, import_shared.num2hex)(this.ccCommand);
      }
    }
    if (this.payload.length > 0) {
      message.payload = (0, import_shared.buffer2hex)(this.payload);
    }
    return {
      tags: [tag],
      message
    };
  }
  /** Generates the JSON representation of this CC */
  toJSON() {
    return this.toJSONInternal();
  }
  toJSONInternal() {
    const ret = {
      nodeId: this.nodeId,
      ccId: import_core.CommandClasses[this.ccId] || (0, import_shared.num2hex)(this.ccId)
    };
    if (this.ccCommand != void 0) {
      ret.ccCommand = (0, import_shared.num2hex)(this.ccCommand);
    }
    if (this.payload.length > 0) {
      ret.payload = (0, import_shared.buffer2hex)(this.payload);
    }
    return ret;
  }
  throwMissingCriticalInterviewResponse() {
    throw new import_core.ZWaveError(`The node did not respond to a critical interview query in time.`, import_core.ZWaveErrorCodes.Controller_NodeTimeout);
  }
  /**
   * Performs the interview procedure for this CC according to SDS14223
   */
  async interview(_ctx) {
  }
  /**
   * Refreshes all dynamic values of this CC
   */
  async refreshValues(_ctx) {
  }
  /**
   * Checks if the CC values need to be manually refreshed.
   * This should be called regularly and when sleeping nodes wake up
   */
  shouldRefreshValues(_ctx) {
    return false;
  }
  /** Determines which CC interviews must be performed before this CC can be interviewed */
  determineRequiredCCInterviews() {
    return [import_core.CommandClasses.Version];
  }
  /**
   * Whether the endpoint interview may be skipped by a CC. Can be overwritten by a subclass.
   */
  skipEndpointInterview() {
    return false;
  }
  /**
   * Maps a BasicCC value to a more specific CC implementation. Returns true if the value was mapped, false otherwise.
   * @param _value The value of the received BasicCC
   */
  setMappedBasicValue(_ctx, _value) {
    return false;
  }
  isSinglecast() {
    return (
      // received
      this.frameType === "singlecast" || this.frameType == void 0 && typeof this.nodeId === "number" && this.nodeId !== import_core.NODE_ID_BROADCAST && this.nodeId !== import_core.NODE_ID_BROADCAST_LR
    );
  }
  isMulticast() {
    return (
      // received
      this.frameType === "multicast" || this.frameType == void 0 && (0, import_typeguards.isArray)(this.nodeId)
    );
  }
  isBroadcast() {
    return (
      // received
      this.frameType === "broadcast" || this.frameType == void 0 && (this.nodeId === import_core.NODE_ID_BROADCAST || this.nodeId === import_core.NODE_ID_BROADCAST_LR)
    );
  }
  /**
   * Returns the node this CC is linked to. Throws if the controller is not yet ready.
   */
  getNode(ctx) {
    if (this.isSinglecast()) {
      return ctx.getNode(this.nodeId);
    }
  }
  /**
   * @internal
   * Returns the node this CC is linked to (or undefined if the node doesn't exist)
   */
  tryGetNode(ctx) {
    try {
      return this.getNode(ctx);
    } catch (e) {
      if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Driver_NotReady) {
        return void 0;
      }
      throw e;
    }
  }
  getEndpoint(ctx) {
    return this.getNode(ctx)?.getEndpoint(this.endpointIndex);
  }
  /** Returns the value DB for this CC's node */
  getValueDB(ctx) {
    if (this.isSinglecast()) {
      try {
        return ctx.getValueDB(this.nodeId);
      } catch {
        throw new import_core.ZWaveError("The node for this CC does not exist or the driver is not ready yet", import_core.ZWaveErrorCodes.Driver_NotReady);
      }
    }
    throw new import_core.ZWaveError("Cannot retrieve the value DB for non-singlecast CCs", import_core.ZWaveErrorCodes.CC_NoNodeID);
  }
  /**
   * Ensures that the metadata for the given CC value exists in the Value DB or creates it if it does not.
   * The endpoint index of the current CC instance is automatically taken into account.
   * @param meta Will be used in place of the predefined metadata when given
   */
  ensureMetadata(ctx, ccValue, meta) {
    const valueDB = this.getValueDB(ctx);
    const valueId = ccValue.endpoint(this.endpointIndex);
    if (!valueDB.hasMetadata(valueId)) {
      valueDB.setMetadata(valueId, meta ?? ccValue.meta);
    }
  }
  /**
   * Removes the metadata for the given CC value from the value DB.
   * The endpoint index of the current CC instance is automatically taken into account.
   */
  removeMetadata(ctx, ccValue) {
    const valueDB = this.getValueDB(ctx);
    const valueId = ccValue.endpoint(this.endpointIndex);
    valueDB.setMetadata(valueId, void 0);
  }
  /**
   * Writes the metadata for the given CC value into the Value DB.
   * The endpoint index of the current CC instance is automatically taken into account.
   * @param meta Will be used in place of the predefined metadata when given
   */
  setMetadata(ctx, ccValue, meta) {
    const valueDB = this.getValueDB(ctx);
    const valueId = ccValue.endpoint(this.endpointIndex);
    valueDB.setMetadata(valueId, meta ?? ccValue.meta);
  }
  /**
   * Reads the metadata for the given CC value from the Value DB.
   * The endpoint index of the current CC instance is automatically taken into account.
   */
  getMetadata(ctx, ccValue) {
    const valueDB = this.getValueDB(ctx);
    const valueId = ccValue.endpoint(this.endpointIndex);
    return valueDB.getMetadata(valueId);
  }
  /**
   * Stores the given value under the value ID for the given CC value in the value DB.
   * The endpoint index of the current CC instance is automatically taken into account.
   */
  setValue(ctx, ccValue, value) {
    const valueDB = this.getValueDB(ctx);
    const valueId = ccValue.endpoint(this.endpointIndex);
    valueDB.setValue(valueId, value);
  }
  /**
   * Removes the value for the given CC value from the value DB.
   * The endpoint index of the current CC instance is automatically taken into account.
   */
  removeValue(ctx, ccValue) {
    const valueDB = this.getValueDB(ctx);
    const valueId = ccValue.endpoint(this.endpointIndex);
    valueDB.removeValue(valueId);
  }
  /**
   * Reads the value stored for the value ID of the given CC value from the value DB.
   * The endpoint index of the current CC instance is automatically taken into account.
   */
  getValue(ctx, ccValue) {
    const valueDB = this.getValueDB(ctx);
    const valueId = ccValue.endpoint(this.endpointIndex);
    return valueDB.getValue(valueId);
  }
  /**
   * Reads when the value stored for the value ID of the given CC value was last updated in the value DB.
   * The endpoint index of the current CC instance is automatically taken into account.
   */
  getValueTimestamp(ctx, ccValue) {
    const valueDB = this.getValueDB(ctx);
    const valueId = ccValue.endpoint(this.endpointIndex);
    return valueDB.getTimestamp(valueId);
  }
  /** Returns the CC value definition for the current CC which matches the given value ID */
  getCCValue(valueId) {
    const ccValues = (0, import_CommandClassDecorators.getCCValues)(this);
    if (!ccValues)
      return;
    for (const value of Object.values(ccValues)) {
      if (value?.is(valueId)) {
        return value;
      }
    }
  }
  getAllCCValues() {
    return Object.values((0, import_CommandClassDecorators.getCCValues)(this) ?? {});
  }
  getCCValueForValueId(properties) {
    return this.getAllCCValues().find((value) => value.is({
      commandClass: this.ccId,
      ...properties
    }));
  }
  shouldAutoCreateValue(ctx, value) {
    return value.options.autoCreate === true || typeof value.options.autoCreate === "function" && value.options.autoCreate(ctx, {
      virtual: false,
      nodeId: this.nodeId,
      index: this.endpointIndex
    });
  }
  /** Returns a list of all value names that are defined for this CommandClass */
  getDefinedValueIDs(ctx, includeInternal = false) {
    const ret = /* @__PURE__ */ new Map();
    const addValueId = /* @__PURE__ */ __name((property, propertyKey) => {
      const valueId = {
        commandClass: this.ccId,
        endpoint: this.endpointIndex,
        property,
        propertyKey
      };
      const dbKey = (0, import_core.valueIdToString)(valueId);
      if (!ret.has(dbKey))
        ret.set(dbKey, valueId);
    }, "addValueId");
    const valueDB = this.getValueDB(ctx);
    const existingValueIds = [
      ...valueDB.getValues(this.ccId),
      ...valueDB.getAllMetadata(this.ccId)
    ];
    const supportedVersion = typeof this.nodeId === "number" && this.nodeId !== import_core.NODE_ID_BROADCAST && this.nodeId !== import_core.NODE_ID_BROADCAST_LR ? ctx.getSupportedCCVersion(this.ccId, this.nodeId, this.endpointIndex) : (0, import_CommandClassDecorators.getImplementedVersion)(this.ccId);
    for (const value of Object.values((0, import_CommandClassDecorators.getCCValues)(this) ?? {})) {
      if (!value || typeof value === "function")
        continue;
      if (value.options.minVersion != void 0 && value.options.minVersion > supportedVersion) {
        continue;
      }
      if (value.options.internal && !includeInternal)
        continue;
      if (!this.shouldAutoCreateValue(ctx, value))
        continue;
      existingValueIds.push(value.endpoint(this.endpointIndex));
    }
    const ccValues = this.getAllCCValues();
    for (const valueId of existingValueIds) {
      if ((valueId.endpoint ?? 0) !== this.endpointIndex)
        continue;
      if (valueId.property === "interviewComplete")
        continue;
      const ccValue = ccValues.find((value) => value.is(valueId));
      if (!ccValue || !ccValue.options.internal || includeInternal) {
        addValueId(valueId.property, valueId.propertyKey);
      }
    }
    return [...ret.values()];
  }
  /** Determines if the given value is an internal value */
  isInternalValue(properties) {
    if (properties.property === "interviewComplete")
      return true;
    const ccValue = this.getCCValueForValueId(properties);
    return ccValue?.options.internal ?? import_Values.defaultCCValueOptions.internal;
  }
  /** Determines if the given value is an secret value */
  isSecretValue(properties) {
    const ccValue = this.getCCValueForValueId(properties);
    return ccValue?.options.secret ?? import_Values.defaultCCValueOptions.secret;
  }
  /** Determines if the given value should be persisted or represents an event */
  isStatefulValue(properties) {
    const ccValue = this.getCCValueForValueId(properties);
    return ccValue?.options.stateful ?? import_Values.defaultCCValueOptions.stateful;
  }
  /**
   * Persists all values for this CC instance into the value DB which are annotated with @ccValue.
   * Returns `true` if the process succeeded, `false` if the value DB cannot be accessed.
   */
  persistValues(ctx) {
    let valueDB;
    try {
      valueDB = this.getValueDB(ctx);
    } catch {
      return false;
    }
    const supportedVersion = ctx.getSupportedCCVersion(
      this.ccId,
      // Values are only persisted for singlecast, so we know nodeId is a number
      this.nodeId,
      this.endpointIndex
    ) || 1;
    for (const [prop, _value] of (0, import_CommandClassDecorators.getCCValueProperties)(this)) {
      const value = typeof _value === "function" ? _value(this) : _value;
      if (value.options.minVersion != void 0 && value.options.minVersion > supportedVersion) {
        continue;
      }
      const valueId = value.endpoint(this.endpointIndex);
      const sourceValue = this[prop];
      const createMetadata = !value.options.internal && (sourceValue != void 0 || supportedVersion >= value.options.minVersion && this.shouldAutoCreateValue(ctx, value));
      if (createMetadata && !valueDB.hasMetadata(valueId)) {
        valueDB.setMetadata(valueId, value.meta);
      }
      if (sourceValue === void 0)
        continue;
      valueDB.setValue(valueId, sourceValue, {
        stateful: value.options.stateful
      });
    }
    return true;
  }
  /**
   * When a CC supports to be split into multiple partial CCs, this can be used to identify the
   * session the partial CCs belong to.
   * If a CC expects `mergePartialCCs` to be always called, you should return an empty object here.
   */
  getPartialCCSessionId() {
    return void 0;
  }
  /**
   * When a CC supports to be split into multiple partial CCs, this indicates that the last report hasn't been received yet.
   * @param _session The previously received set of messages received in this partial CC session
   */
  expectMoreMessages(_session) {
    return false;
  }
  /** Include previously received partial responses into a final CC */
  async mergePartialCCs(_partials, _ctx) {
  }
  /** Tests whether this CC expects at least one command in return */
  expectsCCResponse() {
    let expected = (0, import_CommandClassDecorators.getExpectedCCResponse)(this);
    if (typeof expected === "function" && !(0, import_shared.staticExtends)(expected, CommandClass)) {
      expected = expected(this);
    }
    if (expected === void 0)
      return false;
    if ((0, import_typeguards.isArray)(expected)) {
      return expected.every((cc) => (0, import_shared.staticExtends)(cc, CommandClass));
    } else {
      return (0, import_shared.staticExtends)(expected, CommandClass);
    }
  }
  isExpectedCCResponse(received) {
    if (received.nodeId !== this.nodeId)
      return false;
    let expected = (0, import_CommandClassDecorators.getExpectedCCResponse)(this);
    if (typeof expected === "function" && !(0, import_shared.staticExtends)(expected, CommandClass)) {
      expected = expected(this);
    }
    if (expected == void 0) {
      return false;
    } else if ((0, import_typeguards.isArray)(expected) && expected.every((cc) => (0, import_shared.staticExtends)(cc, CommandClass))) {
      if (expected.every((base) => !(received instanceof base))) {
        return false;
      }
    } else if ((0, import_shared.staticExtends)(expected, CommandClass)) {
      if (!(received instanceof expected))
        return false;
    }
    const predicate = (0, import_CommandClassDecorators.getCCResponsePredicate)(this);
    const ret = predicate?.(this, received) ?? true;
    if (ret === "checkEncapsulated") {
      if ((0, import_EncapsulatingCommandClass.isEncapsulatingCommandClass)(this) && (0, import_EncapsulatingCommandClass.isEncapsulatingCommandClass)(received)) {
        return this.encapsulated.isExpectedCCResponse(received.encapsulated);
      } else {
        return false;
      }
    }
    return ret;
  }
  /**
   * Translates a property identifier into a speaking name for use in an external API
   * @param property The property identifier that should be translated
   * @param _propertyKey The (optional) property key the translated name may depend on
   */
  translateProperty(_ctx, property, _propertyKey) {
    return property.toString();
  }
  /**
   * Translates a property key into a speaking name for use in an external API
   * @param _property The property the key in question belongs to
   * @param propertyKey The property key for which the speaking name should be retrieved
   */
  translatePropertyKey(_ctx, _property, propertyKey) {
    return propertyKey.toString();
  }
  /** Returns the number of bytes that are added to the payload by this CC */
  computeEncapsulationOverhead() {
    return (this.isExtended() ? 2 : 1) + 1;
  }
  /** Computes the maximum net payload size that can be transmitted inside this CC */
  getMaxPayloadLength(baseLength) {
    let ret = baseLength;
    let cur = this;
    while (cur) {
      ret -= cur.computeEncapsulationOverhead();
      cur = (0, import_EncapsulatingCommandClass.isEncapsulatingCommandClass)(cur) ? cur.encapsulated : void 0;
    }
    return ret;
  }
  /** Checks whether this CC is encapsulated with one that has the given CC id and (optionally) CC Command */
  isEncapsulatedWith(ccId, ccCommand) {
    let cc = this;
    while (cc.encapsulatingCC) {
      cc = cc.encapsulatingCC;
      if (cc.ccId === ccId && (ccCommand === void 0 || cc.ccCommand === ccCommand)) {
        return true;
      }
    }
    return false;
  }
  /** Traverses the encapsulation stack of this CC outwards and returns the one that has the given CC id and (optionally) CC Command if that exists. */
  getEncapsulatingCC(ccId, ccCommand) {
    let cc = this;
    while (cc.encapsulatingCC) {
      cc = cc.encapsulatingCC;
      if (cc.ccId === ccId && (ccCommand === void 0 || cc.ccCommand === ccCommand)) {
        return cc;
      }
    }
  }
  /** Traverses the encapsulation stack of this CC inwards and returns the one that has the given CC id and (optionally) CC Command if that exists. */
  getEncapsulatedCC(ccId, ccCommand) {
    const predicate = /* @__PURE__ */ __name((cc) => cc.ccId === ccId && (ccCommand === void 0 || cc.ccCommand === ccCommand), "predicate");
    if ((0, import_EncapsulatingCommandClass.isEncapsulatingCommandClass)(this)) {
      if (predicate(this.encapsulated))
        return this.encapsulated;
      return this.encapsulated.getEncapsulatedCC(ccId, ccCommand);
    } else if ((0, import_EncapsulatingCommandClass.isMultiEncapsulatingCommandClass)(this)) {
      for (const encapsulated of this.encapsulated) {
        if (predicate(encapsulated))
          return encapsulated;
        const ret = encapsulated.getEncapsulatedCC(ccId, ccCommand);
        if (ret)
          return ret;
      }
    }
  }
}
class InvalidCC extends CommandClass {
  static {
    __name(this, "InvalidCC");
  }
  constructor(options) {
    super(options);
    this._ccName = options.ccName;
    this.reason = options.reason;
  }
  _ccName;
  get ccName() {
    return this._ccName;
  }
  reason;
  toLogEntry(_ctx) {
    return {
      tags: [this.ccName, "INVALID"],
      message: this.reason != void 0 ? {
        error: typeof this.reason === "string" ? this.reason : (0, import_shared.getEnumMemberName)(import_core.ZWaveErrorCodes, this.reason)
      } : void 0
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CCRaw,
  CommandClass,
  InvalidCC,
  getEffectiveCCVersion
});
//# sourceMappingURL=CommandClass.js.map
