import * as v from "@zwave-js/core/validation";
export function validateArgs_VersionCCAPI_sendReport() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function sendReport(options) {
                v.assert(v.object({ kind: "parameter", name: "options" }, 'VersionCCReportOptions', { "libraryType": v.enum({ kind: "property", name: "libraryType" }, "ZWaveLibraryTypes"), "protocolVersion": v.primitive({ kind: "property", name: "protocolVersion" }, "string"), "firmwareVersions": v.array({ kind: "property", name: "firmwareVersions" }, 'string', v.primitive({ kind: "item", name: "firmwareVersions" }, "string")), "hardwareVersion": v.optional({ kind: "property", name: "hardwareVersion" }, v.primitive({ kind: "property", name: "hardwareVersion" }, "number")) })(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_VersionCCAPI_getCCVersion() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getCCVersion(requestedCC) {
                v.assert(v.enum({ kind: "parameter", name: "requestedCC" }, "CommandClasses")(requestedCC));
                return __decoratedMethod.call(this, requestedCC);
            };
        }
    };
}
export function validateArgs_VersionCCAPI_reportCCVersion() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportCCVersion(requestedCC, version) {
                v.assert(v.enum({ kind: "parameter", name: "requestedCC" }, "CommandClasses")(requestedCC), v.optional({ kind: "parameter", name: "version" }, v.primitive({ kind: "parameter", name: "version" }, "number"))(version));
                return __decoratedMethod.call(this, requestedCC, version);
            };
        }
    };
}
//# sourceMappingURL=VersionCC._validateArgs.js.map