"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var JsonTemplate_exports = {};
__export(JsonTemplate_exports, {
  clearTemplateCache: () => clearTemplateCache,
  readJsonWithTemplate: () => readJsonWithTemplate
});
module.exports = __toCommonJS(JsonTemplate_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_json5 = __toESM(require("json5"), 1);
var import_pathe = __toESM(require("pathe"), 1);
const IMPORT_KEY = "$import";
const importSpecifierRegex = /^(?<filename>(?:~\/)?[\w\d\/\\\._-]+\.json)?(?:#(?<selector>[\w\d\/\._-]+(?:\[0x[0-9a-fA-F]+\])?))?$/i;
const templateCache = /* @__PURE__ */ new Map();
function clearTemplateCache() {
  templateCache.clear();
}
__name(clearTemplateCache, "clearTemplateCache");
async function readJsonWithTemplate(fs, filename, rootDirs) {
  if (!await (0, import_shared.pathExists)(fs, filename)) {
    throw new import_core.ZWaveError(`Could not open config file ${filename}: not found!`, import_core.ZWaveErrorCodes.Config_NotFound);
  }
  if (typeof rootDirs === "string")
    rootDirs = [rootDirs];
  const fileCache = new Map(templateCache);
  const ret = await readJsonWithTemplateInternal(fs, filename, void 0, [], fileCache, rootDirs);
  for (const [filename2, cached] of fileCache) {
    if (/[\\/]templates[\\/]/.test(filename2)) {
      templateCache.set(filename2, cached);
    }
  }
  return ret;
}
__name(readJsonWithTemplate, "readJsonWithTemplate");
function assertImportSpecifier(val, source) {
  if (typeof val !== "string") {
    throw new import_core.ZWaveError(`Invalid import specifier ${String(val)}!${source != void 0 ? ` Source: ${source}` : ""}`, import_core.ZWaveErrorCodes.Config_Invalid);
  }
  if (!importSpecifierRegex.test(val)) {
    throw new import_core.ZWaveError(`Import specifier "${val}" is invalid!${source != void 0 ? ` Source: ${source}` : ""}`, import_core.ZWaveErrorCodes.Config_Invalid);
  }
}
__name(assertImportSpecifier, "assertImportSpecifier");
function getImportSpecifier(filename, selector) {
  let ret = filename;
  if (selector)
    ret += `#${selector}`;
  return ret;
}
__name(getImportSpecifier, "getImportSpecifier");
function select(obj, selector) {
  let ret = obj;
  const selectorParts = selector.split("/").filter((s) => !!s);
  for (const part of selectorParts) {
    if ((0, import_typeguards.isArray)(ret)) {
      const item = ret.find((r) => (0, import_typeguards.isObject)(r) && "#" in r && r["#"] === part);
      if (item != void 0) {
        const { ["#"]: _, ...rest } = item;
        ret = rest;
        continue;
      }
    }
    ret = ret[part];
  }
  if (!(0, import_typeguards.isObject)(ret)) {
    throw new import_core.ZWaveError(`The import target "${selector}" is not an object!`, import_core.ZWaveErrorCodes.Config_Invalid);
  }
  return ret;
}
__name(select, "select");
function getImportStack(visited, selector) {
  const source = [...visited, selector ? `#${selector}` : void 0].reverse().filter((s) => !!s);
  if (source.length > 0) {
    return `
Import stack: ${source.map((s) => `
  in ${s}`).join("")}`;
  }
  return "";
}
__name(getImportStack, "getImportStack");
async function readJsonWithTemplateInternal(fs, filename, selector, visited, fileCache, rootDirs) {
  filename = import_pathe.default.normalize(filename);
  if (rootDirs) {
    const outsideAllRootDirs = rootDirs.every((rootDir) => {
      const relativeToRoot = import_pathe.default.relative(rootDir, filename);
      return relativeToRoot.startsWith("..");
    });
    if (outsideAllRootDirs) {
      throw new import_core.ZWaveError(`Tried to import config file "${filename}" from outside all root directories: ${rootDirs.map((d) => `
\xB7 ${d}`).join("")}
${getImportStack(visited, selector)}`, import_core.ZWaveErrorCodes.Config_Invalid);
    }
  }
  const specifier = getImportSpecifier(filename, selector);
  if (visited.includes(specifier)) {
    const msg = `Circular $import in config files: ${[
      ...visited,
      specifier
    ].join(" -> ")}
`;
    throw new import_core.ZWaveError(msg, import_core.ZWaveErrorCodes.Config_CircularImport);
  }
  let json;
  if (fileCache.has(filename)) {
    json = fileCache.get(filename);
  } else {
    try {
      const fileContent = await (0, import_shared.readTextFile)(fs, filename, "utf8");
      json = import_json5.default.parse(fileContent);
      fileCache.set(filename, json);
    } catch (e) {
      throw new import_core.ZWaveError(`Could not parse config file ${filename}: ${(0, import_shared.getErrorMessage)(e)}${getImportStack(visited, selector)}`, import_core.ZWaveErrorCodes.Config_Invalid);
    }
  }
  return resolveJsonImports(fs, selector ? select(json, selector) : json, filename, [...visited, specifier], fileCache, rootDirs);
}
__name(readJsonWithTemplateInternal, "readJsonWithTemplateInternal");
async function resolveJsonImports(fs, json, filename, visited, fileCache, rootDirs) {
  const ret = {};
  for (const [prop, val] of Object.entries(json)) {
    if (prop === IMPORT_KEY) {
      assertImportSpecifier(val, visited.join(" -> "));
      const { filename: importFilename, selector } = importSpecifierRegex.exec(val).groups;
      let newFilename;
      if (importFilename) {
        if (importFilename.startsWith("~/")) {
          if (rootDirs) {
            for (const rootDir of rootDirs) {
              newFilename = import_pathe.default.join(rootDir, importFilename.slice(2));
              if (await (0, import_shared.pathExists)(fs, newFilename)) {
                break;
              } else {
                newFilename = void 0;
              }
            }
            if (!newFilename) {
              throw new import_core.ZWaveError(`Could not find the referenced file ${importFilename.slice(2)} in any of the root directories: ${rootDirs.map((d) => `
\xB7 ${d}`).join("")}
${getImportStack(visited, selector)}`, import_core.ZWaveErrorCodes.Config_Invalid);
            }
          } else {
            throw new import_core.ZWaveError(`An $import specifier cannot start with ~/ when no root directory is defined!${getImportStack(visited, selector)}`, import_core.ZWaveErrorCodes.Config_Invalid);
          }
        } else {
          newFilename = import_pathe.default.join(import_pathe.default.dirname(filename), importFilename);
        }
      } else {
        newFilename = filename;
      }
      const imported = await readJsonWithTemplateInternal(fs, newFilename, selector, visited, fileCache, rootDirs);
      Object.assign(ret, imported);
    } else if ((0, import_typeguards.isObject)(val)) {
      ret[prop] = await resolveJsonImports(fs, val, filename, visited, fileCache, rootDirs);
    } else if ((0, import_typeguards.isArray)(val)) {
      const vals = [];
      for (const v of val) {
        if ((0, import_typeguards.isObject)(v)) {
          vals.push(await resolveJsonImports(fs, v, filename, visited, fileCache, rootDirs));
        } else {
          vals.push(v);
        }
      }
      ret[prop] = vals;
    } else {
      ret[prop] = val;
    }
  }
  return ret;
}
__name(resolveJsonImports, "resolveJsonImports");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  clearTemplateCache,
  readJsonWithTemplate
});
//# sourceMappingURL=JsonTemplate.js.map
