import { type JSONObject } from "@zwave-js/shared";
import type { ReadFile, ReadFileSystemInfo } from "@zwave-js/shared/bindings";
import { type AssociationConfig, ConditionalAssociationConfig } from "./AssociationConfig.js";
import { type CompatConfig, ConditionalCompatConfig } from "./CompatConfig.js";
import { type ConditionalPrimitive } from "./ConditionalPrimitive.js";
import { ConditionalDeviceMetadata, type DeviceMetadata } from "./DeviceMetadata.js";
import { ConditionalEndpointConfig, type EndpointConfig } from "./EndpointConfig.js";
import { type ConditionalParamInfoMap, type ParamInfoMap } from "./ParamInformation.js";
import type { DeviceID, FirmwareVersionRange } from "./shared.js";
export interface DeviceConfigIndexEntry {
    manufacturerId: string;
    productType: string;
    productId: string;
    firmwareVersion: FirmwareVersionRange;
    preferred?: true;
    rootDir?: string;
    filename: string;
}
export interface FulltextDeviceConfigIndexEntry {
    manufacturerId: string;
    manufacturer: string;
    label: string;
    description: string;
    productType: string;
    productId: string;
    firmwareVersion: FirmwareVersionRange;
    preferred?: true;
    rootDir?: string;
    filename: string;
}
export declare const embeddedDevicesDir: string;
export declare function getDevicesPaths(configDir: string): {
    devicesDir: string;
    indexPath: string;
};
export type DeviceConfigIndex = DeviceConfigIndexEntry[];
export type FulltextDeviceConfigIndex = FulltextDeviceConfigIndexEntry[];
/** This class represents a device config entry whose conditional settings have not been evaluated yet */
export declare class ConditionalDeviceConfig {
    static from(fs: ReadFileSystemInfo & ReadFile, filename: string, isEmbedded: boolean, options: {
        rootDir: string;
        fallbackDirs?: string[];
        relative?: boolean;
    }): Promise<ConditionalDeviceConfig>;
    constructor(filename: string, isEmbedded: boolean, definition: JSONObject);
    readonly filename: string;
    readonly manufacturer: ConditionalPrimitive<string>;
    readonly manufacturerId: number;
    readonly label: ConditionalPrimitive<string>;
    readonly description: ConditionalPrimitive<string>;
    readonly devices: readonly {
        productType: number;
        productId: number;
    }[];
    readonly firmwareVersion: FirmwareVersionRange;
    /** Mark this configuration as preferred over other config files with an overlapping firmware range */
    readonly preferred: boolean;
    readonly endpoints?: ReadonlyMap<number, ConditionalEndpointConfig>;
    readonly associations?: ReadonlyMap<number, ConditionalAssociationConfig>;
    readonly paramInformation?: ConditionalParamInfoMap;
    /**
     * Contains manufacturer-specific support information for the
     * ManufacturerProprietary CC
     */
    readonly proprietary?: Record<string, unknown>;
    /** Contains compatibility options */
    readonly compat?: ConditionalCompatConfig | ConditionalCompatConfig[];
    /** Contains instructions and other metadata for the device */
    readonly metadata?: ConditionalDeviceMetadata;
    /** Whether this is an embedded configuration or not */
    readonly isEmbedded: boolean;
    evaluate(deviceId?: DeviceID): DeviceConfig;
}
export declare class DeviceConfig {
    static from(fs: ReadFileSystemInfo & ReadFile, filename: string, isEmbedded: boolean, options: {
        rootDir: string;
        fallbackDirs?: string[];
        relative?: boolean;
        deviceId?: DeviceID;
    }): Promise<DeviceConfig>;
    constructor(filename: string, isEmbedded: boolean, manufacturer: string, manufacturerId: number, label: string, description: string, devices: readonly {
        productType: number;
        productId: number;
    }[], firmwareVersion: FirmwareVersionRange, preferred: boolean, endpoints?: ReadonlyMap<number, EndpointConfig>, associations?: ReadonlyMap<number, AssociationConfig>, paramInformation?: ParamInfoMap, proprietary?: Record<string, unknown>, compat?: CompatConfig, metadata?: DeviceMetadata);
    readonly filename: string;
    /** Whether this is an embedded configuration or not */
    readonly isEmbedded: boolean;
    readonly manufacturer: string;
    readonly manufacturerId: number;
    readonly label: string;
    readonly description: string;
    readonly devices: readonly {
        productType: number;
        productId: number;
    }[];
    readonly firmwareVersion: FirmwareVersionRange;
    /** Mark this configuration as preferred over other config files with an overlapping firmware range */
    readonly preferred: boolean;
    readonly endpoints?: ReadonlyMap<number, EndpointConfig>;
    readonly associations?: ReadonlyMap<number, AssociationConfig>;
    readonly paramInformation?: ParamInfoMap;
    /**
     * Contains manufacturer-specific support information for the
     * ManufacturerProprietary CC
     */
    readonly proprietary?: Record<string, unknown>;
    /** Contains compatibility options */
    readonly compat?: CompatConfig;
    /** Contains instructions and other metadata for the device */
    readonly metadata?: DeviceMetadata;
    /** Returns the association config for a given endpoint */
    getAssociationConfigForEndpoint(endpointIndex: number, group: number): AssociationConfig | undefined;
    private getHashable;
    /**
     * Returns a hash code that can be used to check whether a device config has changed enough to require a re-interview.
     */
    getHash(version?: 0 | 1 | 2): Promise<Uint8Array>;
    static get maxHashVersion(): 2;
    static areHashesEqual(hash: Uint8Array, other: Uint8Array): boolean;
}
//# sourceMappingURL=DeviceConfig.d.ts.map