"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DeviceMetadata_exports = {};
__export(DeviceMetadata_exports, {
  ConditionalDeviceComment: () => ConditionalDeviceComment,
  ConditionalDeviceMetadata: () => ConditionalDeviceMetadata
});
module.exports = __toCommonJS(DeviceMetadata_exports);
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_utils_safe = require("../utils_safe.js");
var import_ConditionalItem = require("./ConditionalItem.js");
var import_ConditionalPrimitive = require("./ConditionalPrimitive.js");
class ConditionalDeviceMetadata {
  static {
    __name(this, "ConditionalDeviceMetadata");
  }
  constructor(filename, definition) {
    for (const prop of [
      "wakeup",
      "inclusion",
      "exclusion",
      "reset",
      "manual"
    ]) {
      if (prop in definition) {
        this[prop] = (0, import_ConditionalPrimitive.parseConditionalPrimitive)(filename, "string", prop, definition[prop], "The metadata entry ");
      }
    }
    if ("comments" in definition) {
      const value = definition.comments;
      const isComment = /* @__PURE__ */ __name((opt) => (0, import_typeguards.isObject)(opt) && typeof opt.level === "string" && typeof opt.text === "string", "isComment");
      if (isComment(value)) {
        this.comments = new ConditionalDeviceComment(value.level, value.text, value.$if);
      } else if ((0, import_typeguards.isArray)(value) && value.every(isComment)) {
        this.comments = value.map((c) => new ConditionalDeviceComment(c.level, c.text, c.$if));
      } else {
        (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${filename}:
The metadata entry comments is invalid!`);
      }
    }
  }
  condition;
  evaluateCondition(deviceId) {
    if (!(0, import_ConditionalItem.conditionApplies)(this, deviceId))
      return;
    const ret = {};
    for (const prop of [
      "wakeup",
      "inclusion",
      "exclusion",
      "reset",
      "manual"
    ]) {
      if (this[prop]) {
        const evaluated = (0, import_ConditionalItem.evaluateDeep)(this[prop], deviceId);
        if (evaluated)
          ret[prop] = evaluated;
      }
    }
    const comments = (0, import_ConditionalItem.evaluateDeep)(this.comments, deviceId, true);
    if (comments)
      ret.comments = comments;
    return ret;
  }
  /** How to wake up the device manually */
  wakeup;
  /** Inclusion instructions */
  inclusion;
  /** Exclusion instructions */
  exclusion;
  /** Instructions for resetting the device to factory defaults */
  reset;
  /** A link to the device manual */
  manual;
  /** Comments for this device */
  comments;
}
class ConditionalDeviceComment {
  static {
    __name(this, "ConditionalDeviceComment");
  }
  level;
  text;
  condition;
  constructor(level, text, condition) {
    this.level = level;
    this.text = text;
    this.condition = condition;
  }
  evaluateCondition(deviceId) {
    if (!(0, import_ConditionalItem.conditionApplies)(this, deviceId))
      return;
    return (0, import_shared.pick)(this, ["level", "text"]);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConditionalDeviceComment,
  ConditionalDeviceMetadata
});
//# sourceMappingURL=DeviceMetadata.js.map
