export interface FilePosition {
    offset: number;
    line: number;
    column: number;
}
export interface FileRange {
    start: FilePosition;
    end: FilePosition;
    source: string;
}
export interface LiteralExpectation {
    type: "literal";
    text: string;
    ignoreCase: boolean;
}
export interface ClassParts extends Array<string | ClassParts> {
}
export interface ClassExpectation {
    type: "class";
    parts: ClassParts;
    inverted: boolean;
    ignoreCase: boolean;
}
export interface AnyExpectation {
    type: "any";
}
export interface EndExpectation {
    type: "end";
}
export interface OtherExpectation {
    type: "other";
    description: string;
}
export type Expectation = LiteralExpectation | ClassExpectation | AnyExpectation | EndExpectation | OtherExpectation;
declare class _PeggySyntaxError extends Error {
    static buildMessage(expected: Expectation[], found: string | null): string;
    message: string;
    expected: Expectation[];
    found: string | null;
    location: FileRange;
    name: string;
    constructor(message: string, expected: Expectation[], found: string | null, location: FileRange);
    format(sources: {
        source?: any;
        text: string;
    }[]): string;
}
export interface TraceEvent {
    type: string;
    rule: string;
    result?: any;
    location: FileRange;
}
export interface ParseOptions {
    filename?: string;
    startRule?: "start";
    tracer?: any;
    [key: string]: any;
}
export type ParseFunction = <Options extends ParseOptions>(input: string, options?: Options) => Options extends {
    startRule: infer StartRule;
} ? StartRule extends "start" ? Start : Start : Start;
export declare const parse: ParseFunction;
export declare const PeggySyntaxError: typeof _PeggySyntaxError;
export type PeggySyntaxError = _PeggySyntaxError;
export type Start = Group | Or | And | Comparison;
export type Group = Or;
export type Or = {
    or: [And | Comparison, ...OrTails[]];
};
export type OrTails = And | Comparison;
export type And = {
    and: [Group | Comparison, ...AndTails[]];
};
export type AndTails = Group | Comparison;
export type Comparison = VerComparison | IntComparison;
export type IntComparison = {
    [x: string]: [Term, Term];
};
export type VerComparison = {
    [x: string]: [Term, Version];
};
export type Term = Const | String_1 | Hex | Integer;
export type Const = {
    var: string;
};
export type Integer = number;
export type Hex = number;
export type Version = string;
export type String_1 = string;
export type _ = string[];
export {};
//# sourceMappingURL=LogicParser.d.ts.map