"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var shared_exports = {};
__export(shared_exports, {
  BLOCK_SIZE: () => BLOCK_SIZE,
  decodeX25519KeyDER: () => decodeX25519KeyDER,
  encodeX25519KeyDERPKCS8: () => encodeX25519KeyDERPKCS8,
  encodeX25519KeyDERSPKI: () => encodeX25519KeyDERSPKI,
  increment: () => increment,
  leftShift1: () => leftShift1,
  xor: () => xor,
  zeroPad: () => zeroPad
});
module.exports = __toCommonJS(shared_exports);
var import_shared = require("@zwave-js/shared");
const BLOCK_SIZE = 16;
function zeroPad(input, blockSize) {
  const desiredLength = Math.ceil(input.length / blockSize) * blockSize;
  const ret = new Uint8Array(desiredLength);
  ret.set(input, 0);
  return {
    output: ret,
    paddingLength: ret.length - input.length
  };
}
__name(zeroPad, "zeroPad");
function leftShift1(input) {
  if (input.length === 0)
    return new Uint8Array();
  const ret = new Uint8Array(input.length);
  for (let i = 0; i < input.length - 1; i++) {
    ret[i] = (input[i] << 1) + (!!(input[i + 1] & 128) ? 1 : 0);
  }
  ret[ret.length - 1] = input.at(-1) << 1;
  return ret;
}
__name(leftShift1, "leftShift1");
function xor(b1, b2) {
  if (b1.length !== b2.length) {
    throw new Error("The buffers must have the same length");
  }
  const ret = new Uint8Array(b1.length);
  for (let i = 0; i < b1.length; i++) {
    ret[i] = b1[i] ^ b2[i];
  }
  return ret;
}
__name(xor, "xor");
function increment(buffer) {
  for (let i = buffer.length - 1; i >= 0; i--) {
    buffer[i] += 1;
    if (buffer[i] !== 0)
      break;
  }
}
__name(increment, "increment");
function decodeX25519KeyDER(key) {
  return key.subarray(-32);
}
__name(decodeX25519KeyDER, "decodeX25519KeyDER");
function encodeX25519KeyDERPKCS8(key) {
  return import_shared.Bytes.concat([
    import_shared.Bytes.from("302e020100300506032b656e04220420", "hex"),
    key
  ]);
}
__name(encodeX25519KeyDERPKCS8, "encodeX25519KeyDERPKCS8");
function encodeX25519KeyDERSPKI(key) {
  return import_shared.Bytes.concat([import_shared.Bytes.from("302a300506032b656e032100", "hex"), key]);
}
__name(encodeX25519KeyDERSPKI, "encodeX25519KeyDERSPKI");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BLOCK_SIZE,
  decodeX25519KeyDER,
  encodeX25519KeyDERPKCS8,
  encodeX25519KeyDERSPKI,
  increment,
  leftShift1,
  xor,
  zeroPad
});
//# sourceMappingURL=shared.js.map
