"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var RSSI_exports = {};
__export(RSSI_exports, {
  RssiError: () => RssiError,
  averageRSSI: () => averageRSSI,
  isRssiError: () => isRssiError,
  rssiToString: () => rssiToString
});
module.exports = __toCommonJS(RSSI_exports);
var RssiError;
(function(RssiError2) {
  RssiError2[RssiError2["NotAvailable"] = 127] = "NotAvailable";
  RssiError2[RssiError2["ReceiverSaturated"] = 126] = "ReceiverSaturated";
  RssiError2[RssiError2["NoSignalDetected"] = 125] = "NoSignalDetected";
})(RssiError || (RssiError = {}));
function isRssiError(rssi) {
  return rssi >= RssiError.NoSignalDetected;
}
__name(isRssiError, "isRssiError");
function averageRSSI(acc, rssi, weight) {
  if (isRssiError(rssi)) {
    switch (rssi) {
      case RssiError.NotAvailable:
        return acc ?? 0;
      case RssiError.ReceiverSaturated:
        rssi = 0;
        break;
      case RssiError.NoSignalDetected:
        rssi = -128;
        break;
    }
  }
  if (acc == void 0)
    return rssi;
  return Math.round(acc * weight + rssi * (1 - weight));
}
__name(averageRSSI, "averageRSSI");
function rssiToString(rssi) {
  switch (rssi) {
    case RssiError.NotAvailable:
      return "N/A";
    case RssiError.ReceiverSaturated:
      return "Receiver saturated";
    case RssiError.NoSignalDetected:
      return "No signal detected";
    default:
      return `${rssi} dBm`;
  }
}
__name(rssiToString, "rssiToString");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  RssiError,
  averageRSSI,
  isRssiError,
  rssiToString
});
//# sourceMappingURL=RSSI.js.map
