"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var dsk_exports = {};
__export(dsk_exports, {
  authHomeIdFromDSK: () => authHomeIdFromDSK,
  dskFromString: () => dskFromString,
  dskToString: () => dskToString,
  isValidDSK: () => isValidDSK,
  nwiHomeIdFromDSK: () => nwiHomeIdFromDSK,
  tryParseDSKFromQRCodeString: () => tryParseDSKFromQRCodeString
});
module.exports = __toCommonJS(dsk_exports);
var import_shared = require("@zwave-js/shared");
var import_ZWaveError = require("../error/ZWaveError.js");
function dskToString(dsk) {
  if (dsk.length !== 16) {
    throw new import_ZWaveError.ZWaveError(`DSK length must be 16 bytes, got ${dsk.length}`, import_ZWaveError.ZWaveErrorCodes.Argument_Invalid);
  }
  let ret = "";
  for (let i = 0; i < 16; i += 2) {
    if (i > 0)
      ret += "-";
    ret += import_shared.Bytes.view(dsk).readUInt16BE(i).toString(10).padStart(5, "0");
  }
  return ret;
}
__name(dskToString, "dskToString");
function dskFromString(dsk) {
  if (!isValidDSK(dsk)) {
    throw new import_ZWaveError.ZWaveError(`The DSK must be in the form "aaaaa-bbbbb-ccccc-ddddd-eeeee-fffff-11111-22222"`, import_ZWaveError.ZWaveErrorCodes.Argument_Invalid);
  }
  const ret = new Uint8Array(16);
  const view = import_shared.Bytes.view(ret);
  const parts = dsk.split("-");
  for (let i = 0; i < 8; i++) {
    const partAsNumber = parseInt(parts[i], 10);
    view.writeUInt16BE(partAsNumber, i * 2);
  }
  return ret;
}
__name(dskFromString, "dskFromString");
function nwiHomeIdFromDSK(dsk) {
  const ret = new Uint8Array(4);
  ret.set(dsk.subarray(8, 12), 0);
  ret[0] |= 192;
  ret[3] &= 254;
  return ret;
}
__name(nwiHomeIdFromDSK, "nwiHomeIdFromDSK");
function authHomeIdFromDSK(dsk) {
  const ret = new Uint8Array(4);
  ret.set(dsk.subarray(12, 16), 0);
  ret[0] &= 63;
  ret[3] |= 1;
  return ret;
}
__name(authHomeIdFromDSK, "authHomeIdFromDSK");
function tryParseDSKFromQRCodeString(qr) {
  qr = qr.trim();
  if (qr.startsWith("zws2dsk:")) {
    qr = qr.slice("zws2dsk:".length);
  }
  if (isValidDSK(qr)) {
    return qr;
  }
}
__name(tryParseDSKFromQRCodeString, "tryParseDSKFromQRCodeString");
function isValidDSK(dsk) {
  const patternMatches = /^(\d{5}-){7}\d{5}$/.test(dsk);
  if (!patternMatches)
    return false;
  return dsk.split("-").map((p) => parseInt(p, 10)).every((p) => p <= 65535);
}
__name(isValidDSK, "isValidDSK");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  authHomeIdFromDSK,
  dskFromString,
  dskToString,
  isValidDSK,
  nwiHomeIdFromDSK,
  tryParseDSKFromQRCodeString
});
//# sourceMappingURL=index.js.map
