"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DeviceClasses_exports = {};
__export(DeviceClasses_exports, {
  BasicDeviceClass: () => BasicDeviceClass,
  getAllDeviceClasses: () => getAllDeviceClasses,
  getGenericDeviceClass: () => getGenericDeviceClass,
  getSpecificDeviceClass: () => getSpecificDeviceClass
});
module.exports = __toCommonJS(DeviceClasses_exports);
var import_shared = require("@zwave-js/shared");
var BasicDeviceClass;
(function(BasicDeviceClass2) {
  BasicDeviceClass2[BasicDeviceClass2["Controller"] = 1] = "Controller";
  BasicDeviceClass2[BasicDeviceClass2["Static Controller"] = 2] = "Static Controller";
  BasicDeviceClass2[BasicDeviceClass2["End Node"] = 3] = "End Node";
  BasicDeviceClass2[BasicDeviceClass2["Routing End Node"] = 4] = "Routing End Node";
})(BasicDeviceClass || (BasicDeviceClass = {}));
const deviceClasses = Object.freeze({
  [1]: {
    label: "Remote Controller",
    maySupportBasicCC: false,
    specific: {
      [1]: {
        label: "Portable Remote Controller",
        zwavePlusDeviceType: "Remote Control - Multipurpose"
      },
      [2]: {
        label: "Portable Scene Controller"
      },
      [3]: {
        label: "Portable Installer Tool"
      },
      [4]: {
        label: "AV Remote Control",
        zwavePlusDeviceType: "Remote Control - AV"
      },
      [6]: {
        label: "Simple Remote Control",
        zwavePlusDeviceType: "Remote Control - Simple"
      }
    }
  },
  [2]: {
    label: "Static Controller",
    zwavePlusDeviceType: "Gateway",
    specific: {
      [1]: {
        label: "PC Controller",
        zwavePlusDeviceType: "Central Controller"
      },
      [2]: {
        label: "Scene Controller"
      },
      [3]: {
        label: "Static Installer Tool"
      },
      [4]: {
        label: "Set Top Box",
        zwavePlusDeviceType: "Set Top Box"
      },
      [5]: {
        label: "Sub System Controller",
        zwavePlusDeviceType: "Sub System Controller"
      },
      [6]: {
        label: "TV",
        zwavePlusDeviceType: "TV"
      },
      [7]: {
        label: "Gateway",
        zwavePlusDeviceType: "Gateway",
        maySupportBasicCC: false
      }
    }
  },
  [3]: {
    label: "AV Control Point",
    zwavePlusDeviceType: "AV Control Point",
    specific: {
      [1]: {
        label: "Sound Switch",
        zwavePlusDeviceType: "Sound Switch"
      },
      [4]: {
        label: "Satellite Receiver"
      },
      [17]: {
        label: "Satellite Receiver V2"
      },
      [18]: {
        label: "Doorbell"
      }
    }
  },
  [4]: {
    label: "Display",
    specific: {
      [1]: {
        label: "Simple Display",
        zwavePlusDeviceType: "Display - Simple"
      }
    }
  },
  [5]: {
    label: "Network Extender",
    specific: {
      [1]: {
        label: "Secure Extender"
      }
    }
  },
  [6]: {
    label: "Appliance",
    specific: {
      [1]: {
        label: "General Appliance"
      },
      [2]: {
        label: "Kitchen Appliance"
      },
      [3]: {
        label: "Laundry Appliance"
      }
    }
  },
  [7]: {
    label: "Notification Sensor",
    specific: {
      [1]: {
        label: "Notification Sensor",
        zwavePlusDeviceType: "Sensor - Notification",
        maySupportBasicCC: false
      }
    }
  },
  [8]: {
    label: "Thermostat",
    specific: {
      [1]: {
        label: "Heating Thermostat"
      },
      [2]: {
        label: "General Thermostat"
      },
      [3]: {
        label: "Setback Schedule Thermostat"
      },
      [4]: {
        label: "Setpoint Thermostat"
      },
      [5]: {
        label: "Setback Thermostat",
        zwavePlusDeviceType: "Thermostat - Setback"
      },
      [6]: {
        label: "General Thermostat V2",
        zwavePlusDeviceType: "Thermostat - HVAC"
      }
    }
  },
  [9]: {
    label: "Window Covering",
    specific: {
      [1]: {
        label: "Simple Window Covering Control"
      }
    }
  },
  [15]: {
    label: "Repeater Slave",
    specific: {
      [1]: {
        label: "Repeater Slave",
        zwavePlusDeviceType: "Repeater",
        maySupportBasicCC: false
      },
      [3]: {
        label: "IR Repeater",
        zwavePlusDeviceType: "IR Repeater",
        maySupportBasicCC: false
      }
    }
  },
  [16]: {
    label: "Binary Switch",
    specific: {
      [1]: {
        label: "Binary Power Switch",
        zwavePlusDeviceType: "On/Off Power Switch"
      },
      [2]: {
        label: "Tunable Color Switch",
        zwavePlusDeviceType: "Color Switch"
      },
      [3]: {
        label: "Binary Scene Switch"
      },
      [4]: {
        label: "Power Strip Switch",
        zwavePlusDeviceType: "Power Strip"
      },
      [5]: {
        label: "Siren",
        zwavePlusDeviceType: "Siren"
      },
      [6]: {
        label: "Valve",
        zwavePlusDeviceType: "Valve (open/close)"
      },
      [7]: {
        label: "Irrigation Control",
        zwavePlusDeviceType: "Irrigation Control"
      }
    }
  },
  [17]: {
    label: "Multilevel Switch",
    specific: {
      [1]: {
        label: "Multilevel Power Switch",
        zwavePlusDeviceType: "Light Dimmer Switch"
      },
      [2]: {
        label: "Tunable Color Switch",
        zwavePlusDeviceType: "Color Switch"
      },
      [3]: {
        label: "Multiposition Motor"
      },
      [4]: {
        label: "Multilevel Scene Switch"
      },
      [5]: {
        label: "Motor Control Class A",
        zwavePlusDeviceType: "Window Covering - No Position/Endpoint"
      },
      [6]: {
        label: "Motor Control Class B",
        zwavePlusDeviceType: "Window Covering - Endpoint Aware"
      },
      [7]: {
        label: "Motor Control Class C",
        zwavePlusDeviceType: "Window Covering - Position/Endpoint Aware"
      },
      [8]: {
        label: "Fan Switch",
        zwavePlusDeviceType: "Fan Switch"
      }
    }
  },
  [18]: {
    label: "Remote Switch",
    specific: {
      [1]: {
        label: "Binary Remote Switch"
      },
      [2]: {
        label: "Multilevel Remote Switch"
      },
      [3]: {
        label: "Binary Toggle Remote Switch"
      },
      [4]: {
        label: "Multilevel Toggle Remote Switch"
      }
    }
  },
  [19]: {
    label: "Toggle Switch",
    specific: {
      [1]: {
        label: "Binary Toggle Switch"
      },
      [2]: {
        label: "Multilevel Toggle Switch"
      }
    }
  },
  [21]: {
    label: "Z/IP Node",
    specific: {
      [1]: {
        label: "Z/IP TUN Node"
      },
      [2]: {
        label: "Z/IP ADV Node"
      }
    }
  },
  [22]: {
    label: "Ventilation",
    specific: {
      [1]: {
        label: "Residential Heat Recovery Ventilation"
      }
    }
  },
  [23]: {
    label: "Security Panel",
    specific: {
      [1]: {
        label: "Zoned Security Panel"
      }
    }
  },
  [24]: {
    label: "Wall Controller",
    specific: {
      [1]: {
        label: "Basic Wall Controller",
        zwavePlusDeviceType: "Wall Controller",
        maySupportBasicCC: false
      }
    }
  },
  [32]: {
    label: "Binary Sensor",
    specific: {
      [1]: {
        label: "Routing Binary Sensor"
      }
    }
  },
  [33]: {
    label: "Multilevel Sensor",
    specific: {
      [1]: {
        label: "Routing Multilevel Sensor",
        zwavePlusDeviceType: "Sensor - Multilevel",
        maySupportBasicCC: false
      }
    }
  },
  [48]: {
    label: "Pulse Meter",
    specific: {}
  },
  [49]: {
    label: "Meter",
    maySupportBasicCC: false,
    specific: {
      [1]: {
        label: "Simple Meter",
        zwavePlusDeviceType: "Sub Energy Meter"
      },
      [2]: {
        label: "Advanced Energy Control"
      },
      [3]: {
        label: "Simple Whole Home Meter",
        zwavePlusDeviceType: "Whole Home Meter - Simple"
      }
    }
  },
  [64]: {
    label: "Entry Control",
    specific: {
      [1]: {
        label: "Door Lock"
      },
      [2]: {
        label: "Advanced Door Lock"
      },
      [3]: {
        label: "Secure Keypad Door Lock",
        zwavePlusDeviceType: "Door Lock - Keypad",
        requiresSecurity: true
      },
      [5]: {
        label: "Secure Door",
        zwavePlusDeviceType: "Motorized Barrier - GDO",
        requiresSecurity: true
      },
      [6]: {
        label: "Secure Gate",
        zwavePlusDeviceType: "Motorized Barrier - Gate",
        requiresSecurity: true
      },
      [7]: {
        label: "Secure Barrier Add-on",
        zwavePlusDeviceType: "Motorized Barrier - Add-on",
        requiresSecurity: true
      },
      [8]: {
        label: "Secure Barrier Open only",
        zwavePlusDeviceType: "Motorized Barrier - Open only",
        requiresSecurity: true
      },
      [9]: {
        label: "Secure Barrier Close only",
        zwavePlusDeviceType: "Motorized Barrier - Close only",
        requiresSecurity: true
      },
      [10]: {
        label: "Lockbox",
        zwavePlusDeviceType: "Lockbox",
        requiresSecurity: true
      },
      [11]: {
        label: "Secure Keypad",
        zwavePlusDeviceType: "Entry Control Keypad",
        requiresSecurity: true,
        maySupportBasicCC: false
      }
    }
  },
  [80]: {
    label: "Semi-Interoperable",
    specific: {
      [1]: {
        label: "Energy Production"
      }
    }
  },
  [161]: {
    label: "Alarm Sensor",
    specific: {
      [1]: {
        label: "Basic Routing Alarm Sensor"
      },
      [2]: {
        label: "Routing Alarm Sensor"
      },
      [3]: {
        label: "Basic Zensor Net Alarm Sensor"
      },
      [4]: {
        label: "Zensor Net Alarm Sensor"
      },
      [5]: {
        label: "Advanced Zensor Net Alarm Sensor"
      },
      [6]: {
        label: "Basic Routing Smoke Sensor"
      },
      [7]: {
        label: "Routing Smoke Sensor"
      },
      [8]: {
        label: "Basic Zensor Net Smoke Sensor"
      },
      [9]: {
        label: "Zensor Net Smoke Sensor"
      },
      [10]: {
        label: "Advanced Zensor Net Smoke Sensor"
      }
    }
  },
  [255]: {
    label: "Non-Interoperable",
    specific: {}
  }
});
function getGenericDeviceClass(generic) {
  const genericClass = deviceClasses[generic];
  if (!genericClass)
    return getUnknownGenericDeviceClass(generic);
  return {
    key: generic,
    label: genericClass.label,
    zwavePlusDeviceType: genericClass.zwavePlusDeviceType,
    requiresSecurity: genericClass.requiresSecurity ?? false,
    maySupportBasicCC: genericClass.maySupportBasicCC ?? true
  };
}
__name(getGenericDeviceClass, "getGenericDeviceClass");
function getAllDeviceClasses() {
  const ret = [];
  const genericDeviceClassKeys = Object.keys(deviceClasses).map((k) => parseInt(k, 10));
  for (const generic of genericDeviceClassKeys) {
    const genericClass = getGenericDeviceClass(generic);
    const specificDeviceClassKeys = Object.keys(deviceClasses[generic].specific).map((k) => parseInt(k, 10));
    const specificClasses = specificDeviceClassKeys.map((specific) => getSpecificDeviceClass(generic, specific));
    ret.push({
      ...genericClass,
      specific: specificClasses
    });
  }
  return ret;
}
__name(getAllDeviceClasses, "getAllDeviceClasses");
function getUnknownGenericDeviceClass(key) {
  return {
    key,
    label: `UNKNOWN (${(0, import_shared.num2hex)(key)})`,
    requiresSecurity: false,
    maySupportBasicCC: true
  };
}
__name(getUnknownGenericDeviceClass, "getUnknownGenericDeviceClass");
function getSpecificDeviceClass(generic, specific) {
  const genericClass = deviceClasses[generic];
  if (!genericClass) {
    return getUnknownSpecificDeviceClass(getUnknownGenericDeviceClass(generic), specific);
  }
  const specificClass = genericClass.specific[specific];
  if (!specificClass) {
    return getUnknownSpecificDeviceClass(genericClass, specific);
  }
  return {
    key: specific,
    label: specificClass.label,
    zwavePlusDeviceType: specificClass.zwavePlusDeviceType ?? genericClass.zwavePlusDeviceType,
    requiresSecurity: specificClass.requiresSecurity ?? genericClass.requiresSecurity ?? false,
    maySupportBasicCC: specificClass.maySupportBasicCC ?? genericClass.maySupportBasicCC ?? true
  };
}
__name(getSpecificDeviceClass, "getSpecificDeviceClass");
function getUnknownSpecificDeviceClass(genericClass, specific) {
  if (specific === 0) {
    return {
      key: specific,
      label: "Unused",
      zwavePlusDeviceType: genericClass.zwavePlusDeviceType,
      requiresSecurity: genericClass.requiresSecurity ?? false,
      maySupportBasicCC: genericClass.maySupportBasicCC ?? true
    };
  } else {
    return {
      key: specific,
      label: `UNKNOWN (${(0, import_shared.num2hex)(specific)})`,
      zwavePlusDeviceType: genericClass.zwavePlusDeviceType,
      requiresSecurity: genericClass.requiresSecurity ?? false,
      maySupportBasicCC: genericClass.maySupportBasicCC ?? true
    };
  }
}
__name(getUnknownSpecificDeviceClass, "getUnknownSpecificDeviceClass");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BasicDeviceClass,
  getAllDeviceClasses,
  getGenericDeviceClass,
  getSpecificDeviceClass
});
//# sourceMappingURL=DeviceClasses.js.map
