"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Indicators_exports = {};
__export(Indicators_exports, {
  Indicator: () => Indicator,
  getAllIndicatorProperties: () => getAllIndicatorProperties,
  getIndicatorProperty: () => getIndicatorProperty
});
module.exports = __toCommonJS(Indicators_exports);
var Indicator;
(function(Indicator2) {
  Indicator2[Indicator2["Armed"] = 1] = "Armed";
  Indicator2[Indicator2["Not armed / disarmed"] = 2] = "Not armed / disarmed";
  Indicator2[Indicator2["Ready"] = 3] = "Ready";
  Indicator2[Indicator2["Fault"] = 4] = "Fault";
  Indicator2[Indicator2["Busy"] = 5] = "Busy";
  Indicator2[Indicator2["Enter ID"] = 6] = "Enter ID";
  Indicator2[Indicator2["Enter PIN"] = 7] = "Enter PIN";
  Indicator2[Indicator2["Code accepted"] = 8] = "Code accepted";
  Indicator2[Indicator2["Code not accepted"] = 9] = "Code not accepted";
  Indicator2[Indicator2["Armed Stay"] = 10] = "Armed Stay";
  Indicator2[Indicator2["Armed Away"] = 11] = "Armed Away";
  Indicator2[Indicator2["Alarming"] = 12] = "Alarming";
  Indicator2[Indicator2["Alarming: Burglar"] = 13] = "Alarming: Burglar";
  Indicator2[Indicator2["Alarming: Smoke / Fire"] = 14] = "Alarming: Smoke / Fire";
  Indicator2[Indicator2["Alarming: Carbon Monoxide"] = 15] = "Alarming: Carbon Monoxide";
  Indicator2[Indicator2["Bypass challenge"] = 16] = "Bypass challenge";
  Indicator2[Indicator2["Entry Delay"] = 17] = "Entry Delay";
  Indicator2[Indicator2["Exit Delay"] = 18] = "Exit Delay";
  Indicator2[Indicator2["Alarming: Medical"] = 19] = "Alarming: Medical";
  Indicator2[Indicator2["Alarming: Freeze warning"] = 20] = "Alarming: Freeze warning";
  Indicator2[Indicator2["Alarming: Water leak"] = 21] = "Alarming: Water leak";
  Indicator2[Indicator2["Alarming: Panic"] = 22] = "Alarming: Panic";
  Indicator2[Indicator2["Zone 1 armed"] = 32] = "Zone 1 armed";
  Indicator2[Indicator2["Zone 2 armed"] = 33] = "Zone 2 armed";
  Indicator2[Indicator2["Zone 3 armed"] = 34] = "Zone 3 armed";
  Indicator2[Indicator2["Zone 4 armed"] = 35] = "Zone 4 armed";
  Indicator2[Indicator2["Zone 5 armed"] = 36] = "Zone 5 armed";
  Indicator2[Indicator2["Zone 6 armed"] = 37] = "Zone 6 armed";
  Indicator2[Indicator2["Zone 7 armed"] = 38] = "Zone 7 armed";
  Indicator2[Indicator2["Zone 8 armed"] = 39] = "Zone 8 armed";
  Indicator2[Indicator2["LCD backlight"] = 48] = "LCD backlight";
  Indicator2[Indicator2["Button backlight letters"] = 64] = "Button backlight letters";
  Indicator2[Indicator2["Button backlight digits"] = 65] = "Button backlight digits";
  Indicator2[Indicator2["Button backlight command"] = 66] = "Button backlight command";
  Indicator2[Indicator2["Button 1 indication"] = 67] = "Button 1 indication";
  Indicator2[Indicator2["Button 2 indication"] = 68] = "Button 2 indication";
  Indicator2[Indicator2["Button 3 indication"] = 69] = "Button 3 indication";
  Indicator2[Indicator2["Button 4 indication"] = 70] = "Button 4 indication";
  Indicator2[Indicator2["Button 5 indication"] = 71] = "Button 5 indication";
  Indicator2[Indicator2["Button 6 indication"] = 72] = "Button 6 indication";
  Indicator2[Indicator2["Button 7 indication"] = 73] = "Button 7 indication";
  Indicator2[Indicator2["Button 8 indication"] = 74] = "Button 8 indication";
  Indicator2[Indicator2["Button 9 indication"] = 75] = "Button 9 indication";
  Indicator2[Indicator2["Button 10 indication"] = 76] = "Button 10 indication";
  Indicator2[Indicator2["Button 11 indication"] = 77] = "Button 11 indication";
  Indicator2[Indicator2["Button 12 indication"] = 78] = "Button 12 indication";
  Indicator2[Indicator2["Node Identify"] = 80] = "Node Identify";
  Indicator2[Indicator2["Generic event sound notification 1"] = 96] = "Generic event sound notification 1";
  Indicator2[Indicator2["Generic event sound notification 2"] = 97] = "Generic event sound notification 2";
  Indicator2[Indicator2["Generic event sound notification 3"] = 98] = "Generic event sound notification 3";
  Indicator2[Indicator2["Generic event sound notification 4"] = 99] = "Generic event sound notification 4";
  Indicator2[Indicator2["Generic event sound notification 5"] = 100] = "Generic event sound notification 5";
  Indicator2[Indicator2["Generic event sound notification 6"] = 101] = "Generic event sound notification 6";
  Indicator2[Indicator2["Generic event sound notification 7"] = 102] = "Generic event sound notification 7";
  Indicator2[Indicator2["Generic event sound notification 8"] = 103] = "Generic event sound notification 8";
  Indicator2[Indicator2["Generic event sound notification 9"] = 104] = "Generic event sound notification 9";
  Indicator2[Indicator2["Generic event sound notification 10"] = 105] = "Generic event sound notification 10";
  Indicator2[Indicator2["Generic event sound notification 11"] = 106] = "Generic event sound notification 11";
  Indicator2[Indicator2["Generic event sound notification 12"] = 107] = "Generic event sound notification 12";
  Indicator2[Indicator2["Generic event sound notification 13"] = 108] = "Generic event sound notification 13";
  Indicator2[Indicator2["Generic event sound notification 14"] = 109] = "Generic event sound notification 14";
  Indicator2[Indicator2["Generic event sound notification 15"] = 110] = "Generic event sound notification 15";
  Indicator2[Indicator2["Generic event sound notification 16"] = 111] = "Generic event sound notification 16";
  Indicator2[Indicator2["Generic event sound notification 17"] = 112] = "Generic event sound notification 17";
  Indicator2[Indicator2["Generic event sound notification 18"] = 113] = "Generic event sound notification 18";
  Indicator2[Indicator2["Generic event sound notification 19"] = 114] = "Generic event sound notification 19";
  Indicator2[Indicator2["Generic event sound notification 20"] = 115] = "Generic event sound notification 20";
  Indicator2[Indicator2["Generic event sound notification 21"] = 116] = "Generic event sound notification 21";
  Indicator2[Indicator2["Generic event sound notification 22"] = 117] = "Generic event sound notification 22";
  Indicator2[Indicator2["Generic event sound notification 23"] = 118] = "Generic event sound notification 23";
  Indicator2[Indicator2["Generic event sound notification 24"] = 119] = "Generic event sound notification 24";
  Indicator2[Indicator2["Generic event sound notification 25"] = 120] = "Generic event sound notification 25";
  Indicator2[Indicator2["Generic event sound notification 26"] = 121] = "Generic event sound notification 26";
  Indicator2[Indicator2["Generic event sound notification 27"] = 122] = "Generic event sound notification 27";
  Indicator2[Indicator2["Generic event sound notification 28"] = 123] = "Generic event sound notification 28";
  Indicator2[Indicator2["Generic event sound notification 29"] = 124] = "Generic event sound notification 29";
  Indicator2[Indicator2["Generic event sound notification 30"] = 125] = "Generic event sound notification 30";
  Indicator2[Indicator2["Generic event sound notification 31"] = 126] = "Generic event sound notification 31";
  Indicator2[Indicator2["Generic event sound notification 32"] = 127] = "Generic event sound notification 32";
  Indicator2[Indicator2["Manufacturer defined 1"] = 128] = "Manufacturer defined 1";
  Indicator2[Indicator2["Manufacturer defined 2"] = 129] = "Manufacturer defined 2";
  Indicator2[Indicator2["Manufacturer defined 3"] = 130] = "Manufacturer defined 3";
  Indicator2[Indicator2["Manufacturer defined 4"] = 131] = "Manufacturer defined 4";
  Indicator2[Indicator2["Manufacturer defined 5"] = 132] = "Manufacturer defined 5";
  Indicator2[Indicator2["Manufacturer defined 6"] = 133] = "Manufacturer defined 6";
  Indicator2[Indicator2["Manufacturer defined 7"] = 134] = "Manufacturer defined 7";
  Indicator2[Indicator2["Manufacturer defined 8"] = 135] = "Manufacturer defined 8";
  Indicator2[Indicator2["Manufacturer defined 9"] = 136] = "Manufacturer defined 9";
  Indicator2[Indicator2["Manufacturer defined 10"] = 137] = "Manufacturer defined 10";
  Indicator2[Indicator2["Manufacturer defined 11"] = 138] = "Manufacturer defined 11";
  Indicator2[Indicator2["Manufacturer defined 12"] = 139] = "Manufacturer defined 12";
  Indicator2[Indicator2["Manufacturer defined 13"] = 140] = "Manufacturer defined 13";
  Indicator2[Indicator2["Manufacturer defined 14"] = 141] = "Manufacturer defined 14";
  Indicator2[Indicator2["Manufacturer defined 15"] = 142] = "Manufacturer defined 15";
  Indicator2[Indicator2["Manufacturer defined 16"] = 143] = "Manufacturer defined 16";
  Indicator2[Indicator2["Manufacturer defined 17"] = 144] = "Manufacturer defined 17";
  Indicator2[Indicator2["Manufacturer defined 18"] = 145] = "Manufacturer defined 18";
  Indicator2[Indicator2["Manufacturer defined 19"] = 146] = "Manufacturer defined 19";
  Indicator2[Indicator2["Manufacturer defined 20"] = 147] = "Manufacturer defined 20";
  Indicator2[Indicator2["Manufacturer defined 21"] = 148] = "Manufacturer defined 21";
  Indicator2[Indicator2["Manufacturer defined 22"] = 149] = "Manufacturer defined 22";
  Indicator2[Indicator2["Manufacturer defined 23"] = 150] = "Manufacturer defined 23";
  Indicator2[Indicator2["Manufacturer defined 24"] = 151] = "Manufacturer defined 24";
  Indicator2[Indicator2["Manufacturer defined 25"] = 152] = "Manufacturer defined 25";
  Indicator2[Indicator2["Manufacturer defined 26"] = 153] = "Manufacturer defined 26";
  Indicator2[Indicator2["Manufacturer defined 27"] = 154] = "Manufacturer defined 27";
  Indicator2[Indicator2["Manufacturer defined 28"] = 155] = "Manufacturer defined 28";
  Indicator2[Indicator2["Manufacturer defined 29"] = 156] = "Manufacturer defined 29";
  Indicator2[Indicator2["Manufacturer defined 30"] = 157] = "Manufacturer defined 30";
  Indicator2[Indicator2["Manufacturer defined 31"] = 158] = "Manufacturer defined 31";
  Indicator2[Indicator2["Manufacturer defined 32"] = 159] = "Manufacturer defined 32";
  Indicator2[Indicator2["Buzzer"] = 240] = "Buzzer";
})(Indicator || (Indicator = {}));
const indicatorProperties = Object.freeze({
  [1]: {
    label: "Multilevel",
    exposeAsValue: true
  },
  [2]: {
    label: "Binary",
    type: "boolean",
    exposeAsValue: true
  },
  [3]: {
    label: "On/Off Period: Duration",
    description: 'Sets the duration of an on/off period in 1/10th seconds. Must be set together with "On/Off Cycle Count"'
  },
  [4]: {
    label: "On/Off Cycle Count",
    description: 'Sets the number of on/off periods. 0xff means infinite. Must be set together with "On/Off Period duration"'
  },
  [5]: {
    label: "On/Off Period: On time",
    description: "This property is used to set the length of the On time during an On/Off period. It allows asymmetric On/Off periods. The value 0x00 MUST represent symmetric On/Off period (On time equal to Off time)"
  },
  [10]: {
    label: "Timeout: Hours",
    description: "Turns the indicator of after this amount of hours. Can be used together with other timeout properties"
  },
  [6]: {
    label: "Timeout: Minutes",
    description: "Turns the indicator of after this amount of minutes. Can be used together with other timeout properties"
  },
  [7]: {
    label: "Timeout: Seconds",
    description: "Turns the indicator of after this amount of seconds. Can be used together with other timeout properties"
  },
  [8]: {
    label: "Timeout: 1/100th seconds",
    description: "Turns the indicator of after this amount of 1/100th seconds. Can be used together with other timeout properties"
  },
  [9]: {
    label: "Sound level",
    description: "This property is used to set the volume of a indicator. 0 means off/mute.",
    max: 100,
    exposeAsValue: true
  },
  [16]: {
    label: "Low power",
    description: "This property MAY be used to by a supporting node advertise that the indicator can continue working in sleep mode.",
    readonly: true,
    type: "boolean"
  }
});
function getIndicatorProperty(id) {
  const property = indicatorProperties[id];
  if (!property)
    return;
  return {
    id,
    ...property
  };
}
__name(getIndicatorProperty, "getIndicatorProperty");
function getAllIndicatorProperties() {
  return Object.entries(indicatorProperties).map(([id, value]) => ({ id: parseInt(id, 10), ...value }));
}
__name(getAllIndicatorProperties, "getAllIndicatorProperties");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Indicator,
  getAllIndicatorProperties,
  getIndicatorProperty
});
//# sourceMappingURL=Indicators.js.map
