"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Cache_exports = {};
__export(Cache_exports, {
  deserializeCacheValue: () => deserializeCacheValue,
  serializeCacheValue: () => serializeCacheValue
});
module.exports = __toCommonJS(Cache_exports);
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_Duration = require("./Duration.js");
const SPECIAL_TYPE_KEY = "$$type$$";
function serializeCacheValue(value) {
  if (value instanceof Map) {
    return {
      ...Object.fromEntries([...value.entries()].map(([k, v]) => [
        k,
        serializeCacheValue(v)
      ])),
      [SPECIAL_TYPE_KEY]: "map"
    };
  } else if (import_Duration.Duration.isDuration(value)) {
    const valueAsJSON = value.toJSON();
    return {
      ...typeof valueAsJSON === "string" ? { unit: valueAsJSON } : valueAsJSON,
      [SPECIAL_TYPE_KEY]: "duration"
    };
  } else if ((0, import_shared.isUint8Array)(value)) {
    return {
      [SPECIAL_TYPE_KEY]: "buffer",
      data: (0, import_shared.uint8ArrayToHex)(value)
    };
  } else if (typeof value === "number" || typeof value === "string" || typeof value === "boolean" || (0, import_typeguards.isObject)(value) || (0, import_typeguards.isArray)(value)) {
    return value;
  }
}
__name(serializeCacheValue, "serializeCacheValue");
function deserializeCacheValue(value) {
  if ((0, import_typeguards.isObject)(value)) {
    const specialType = value[SPECIAL_TYPE_KEY];
    if (specialType === "map") {
      const { [SPECIAL_TYPE_KEY]: _, ...rest } = value;
      return new Map(Object.entries(rest).map(([k, v]) => [/^\d+$/.test(k) ? parseInt(k, 10) : k, v]).map(([k, v]) => [k, deserializeCacheValue(v)]));
    } else if (specialType === "duration") {
      return new import_Duration.Duration(value.value ?? 1, value.unit);
    } else if (specialType === "buffer") {
      return (0, import_shared.hexToUint8Array)(value.data);
    }
  }
  return value;
}
__name(deserializeCacheValue, "deserializeCacheValue");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  deserializeCacheValue,
  serializeCacheValue
});
//# sourceMappingURL=Cache.js.map
