"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Metadata_exports = {};
__export(Metadata_exports, {
  ConfigValueFormat: () => ConfigValueFormat,
  ValueMetadata: () => ValueMetadata,
  enumValuesToMetadataStates: () => enumValuesToMetadataStates,
  getNumericEnumValues: () => getNumericEnumValues
});
module.exports = __toCommonJS(Metadata_exports);
var import_shared = require("@zwave-js/shared");
var import_Primitive = require("./Primitive.js");
const isIntegerRegex = /^\d+$/;
function getNumericEnumValues(enumeration) {
  return Object.keys(enumeration).filter((val) => isIntegerRegex.test(val)).map((val) => parseInt(val, 10));
}
__name(getNumericEnumValues, "getNumericEnumValues");
function enumValuesToMetadataStates(enumeration, values) {
  const ret = {};
  if (values == void 0)
    values = getNumericEnumValues(enumeration);
  for (const value of values) {
    ret[value] = (0, import_shared.getEnumMemberName)(enumeration, value);
  }
  return ret;
}
__name(enumValuesToMetadataStates, "enumValuesToMetadataStates");
const define = /* @__PURE__ */ __name(() => (
  // The chained function pattern is necessary for partial application of generic types
  (definition) => {
    return definition;
  }
), "define");
const defineAny = define();
const defineNumeric = define();
const defineBoolean = define();
const defineString = define();
const defineBuffer = define();
const defineDuration = define();
var ConfigValueFormat;
(function(ConfigValueFormat2) {
  ConfigValueFormat2[ConfigValueFormat2["SignedInteger"] = 0] = "SignedInteger";
  ConfigValueFormat2[ConfigValueFormat2["UnsignedInteger"] = 1] = "UnsignedInteger";
  ConfigValueFormat2[ConfigValueFormat2["Enumerated"] = 2] = "Enumerated";
  ConfigValueFormat2[ConfigValueFormat2["BitField"] = 3] = "BitField";
})(ConfigValueFormat || (ConfigValueFormat = {}));
const _default = defineAny({
  type: "any",
  readable: true,
  writeable: true
});
const _readonly = {
  writeable: false
};
const _writeonly = {
  readable: false
};
const Any = defineAny({
  ..._default
});
const ReadOnly = defineAny({
  ..._default,
  ..._readonly
});
const WriteOnly = defineAny({
  ..._default,
  ..._writeonly
});
const Boolean = defineBoolean({
  ..._default,
  type: "boolean"
});
const ReadOnlyBoolean = defineBoolean({
  ...Boolean,
  ..._readonly
});
const WriteOnlyBoolean = defineBoolean({
  ...Boolean,
  ..._writeonly
});
const Number = defineNumeric({
  ..._default,
  type: "number"
});
const ReadOnlyNumber = defineNumeric({
  ...Number,
  ..._readonly
});
const WriteOnlyNumber = defineNumeric({
  ...Number,
  ..._writeonly
});
const UInt8 = defineNumeric({
  ..._default,
  type: "number",
  ...import_Primitive.IntegerLimits.UInt8
});
const ReadOnlyUInt8 = defineNumeric({
  ...UInt8,
  ..._readonly
});
const WriteOnlyUInt8 = defineNumeric({
  ...UInt8,
  ..._writeonly
});
const UInt16 = defineNumeric({
  ..._default,
  type: "number",
  ...import_Primitive.IntegerLimits.UInt16
});
const ReadOnlyUInt16 = defineNumeric({
  ...UInt16,
  ..._readonly
});
const WriteOnlyUInt16 = defineNumeric({
  ...UInt16,
  ..._writeonly
});
const UInt24 = defineNumeric({
  ..._default,
  type: "number",
  ...import_Primitive.IntegerLimits.UInt24
});
const ReadOnlyUInt24 = defineNumeric({
  ...UInt24,
  ..._readonly
});
const WriteOnlyUInt24 = defineNumeric({
  ...UInt24,
  ..._writeonly
});
const UInt32 = defineNumeric({
  ..._default,
  type: "number",
  ...import_Primitive.IntegerLimits.UInt32
});
const ReadOnlyUInt32 = defineNumeric({
  ...UInt32,
  ..._readonly
});
const WriteOnlyUInt32 = defineNumeric({
  ...UInt32,
  ..._writeonly
});
const Int8 = defineNumeric({
  ..._default,
  type: "number",
  ...import_Primitive.IntegerLimits.Int8
});
const ReadOnlyInt8 = defineNumeric({
  ...Int8,
  ..._readonly
});
const WriteOnlyInt8 = defineNumeric({
  ...Int8,
  ..._writeonly
});
const Int16 = defineNumeric({
  ..._default,
  type: "number",
  ...import_Primitive.IntegerLimits.Int16
});
const ReadOnlyInt16 = defineNumeric({
  ...Int16,
  ..._readonly
});
const WriteOnlyInt16 = defineNumeric({
  ...Int16,
  ..._writeonly
});
const Int24 = defineNumeric({
  ..._default,
  type: "number",
  ...import_Primitive.IntegerLimits.Int24
});
const ReadOnlyInt24 = defineNumeric({
  ...Int24,
  ..._readonly
});
const WriteOnlyInt24 = defineNumeric({
  ...Int24,
  ..._writeonly
});
const Int32 = defineNumeric({
  ..._default,
  type: "number",
  ...import_Primitive.IntegerLimits.Int32
});
const ReadOnlyInt32 = defineNumeric({
  ...Int32,
  ..._readonly
});
const WriteOnlyInt32 = defineNumeric({
  ...Int32,
  ..._writeonly
});
const String = defineString({
  ..._default,
  type: "string"
});
const ReadOnlyString = defineString({
  ...String,
  ..._readonly
});
const WriteOnlyString = defineString({
  ...String,
  ..._writeonly
});
const Color = defineString({
  ...String,
  type: "color"
});
const ReadOnlyColor = defineString({
  ...Color,
  ..._readonly
});
const WriteOnlyColor = defineString({
  ...Color,
  ..._writeonly
});
const Level = defineNumeric({
  ...UInt8,
  max: 99
});
const ReadOnlyLevel = defineNumeric({
  ...Level,
  ..._readonly
});
const WriteOnlyLevel = defineNumeric({
  ...Level,
  ..._writeonly
});
const _Duration = defineDuration({
  ..._default,
  type: "duration"
});
const ReadOnlyDuration = defineDuration({
  ..._Duration,
  ..._readonly
});
const WriteOnlyDuration = defineDuration({
  ..._Duration,
  ..._writeonly
});
const _Buffer = defineBuffer({
  ..._default,
  type: "buffer"
});
const ReadOnlyBuffer = defineBuffer({
  ..._Buffer,
  ..._readonly
});
const WriteOnlyBuffer = defineBuffer({
  ..._Buffer,
  ..._writeonly
});
const ValueMetadata = {
  /** The default value for metadata: readable and writeable */
  Any: Object.freeze(Any),
  /** The default value for readonly metadata */
  ReadOnly: Object.freeze(ReadOnly),
  /** The default value for writeonly metadata */
  WriteOnly: Object.freeze(WriteOnly),
  /** A numeric value */
  Number: Object.freeze(Number),
  /** A numeric value (readonly) */
  ReadOnlyNumber: Object.freeze(ReadOnlyNumber),
  /** A numeric value (writeonly) */
  WriteOnlyNumber: Object.freeze(WriteOnlyNumber),
  /** Unsigned 8-bit integer */
  UInt8: Object.freeze(UInt8),
  /** Unsigned 16-bit integer */
  UInt16: Object.freeze(UInt16),
  /** Unsigned 24-bit integer */
  UInt24: Object.freeze(UInt24),
  /** Unsigned 32-bit integer */
  UInt32: Object.freeze(UInt32),
  /** Signed 8-bit integer */
  Int8: Object.freeze(Int8),
  /** Signed 16-bit integer */
  Int16: Object.freeze(Int16),
  /** Signed 24-bit integer */
  Int24: Object.freeze(Int24),
  /** Signed 32-bit integer */
  Int32: Object.freeze(Int32),
  /** Unsigned 8-bit integer (readonly) */
  ReadOnlyUInt8: Object.freeze(ReadOnlyUInt8),
  /** Unsigned 16-bit integer (readonly) */
  ReadOnlyUInt16: Object.freeze(ReadOnlyUInt16),
  /** Unsigned 24-bit integer (readonly) */
  ReadOnlyUInt24: Object.freeze(ReadOnlyUInt24),
  /** Unsigned 32-bit integer (readonly) */
  ReadOnlyUInt32: Object.freeze(ReadOnlyUInt32),
  /** Signed 8-bit integer (readonly) */
  ReadOnlyInt8: Object.freeze(ReadOnlyInt8),
  /** Signed 16-bit integer (readonly) */
  ReadOnlyInt16: Object.freeze(ReadOnlyInt16),
  /** Signed 24-bit integer (readonly) */
  ReadOnlyInt24: Object.freeze(ReadOnlyInt24),
  /** Signed 32-bit integer (readonly) */
  ReadOnlyInt32: Object.freeze(ReadOnlyInt32),
  /** Unsigned 8-bit integer (writeonly) */
  WriteOnlyUInt8: Object.freeze(WriteOnlyUInt8),
  /** Unsigned 16-bit integer (writeonly) */
  WriteOnlyUInt16: Object.freeze(WriteOnlyUInt16),
  /** Unsigned 24-bit integer (writeonly) */
  WriteOnlyUInt24: Object.freeze(WriteOnlyUInt24),
  /** Unsigned 32-bit integer (writeonly) */
  WriteOnlyUInt32: Object.freeze(WriteOnlyUInt32),
  /** Signed 8-bit integer (writeonly) */
  WriteOnlyInt8: Object.freeze(WriteOnlyInt8),
  /** Signed 16-bit integer (writeonly) */
  WriteOnlyInt16: Object.freeze(WriteOnlyInt16),
  /** Signed 24-bit integer (writeonly) */
  WriteOnlyInt24: Object.freeze(WriteOnlyInt24),
  /** Signed 32-bit integer (writeonly) */
  WriteOnlyInt32: Object.freeze(WriteOnlyInt32),
  /** The level of a Switch (0-99) */
  Level: Object.freeze(Level),
  /** The level of a Switch (0-99, readonly) */
  ReadOnlyLevel: Object.freeze(ReadOnlyLevel),
  /** The level of a Switch (0-99, writeonly) */
  WriteOnlyLevel: Object.freeze(WriteOnlyLevel),
  /** A boolean value */
  Boolean: Object.freeze(Boolean),
  /** A boolean value (readonly) */
  ReadOnlyBoolean: Object.freeze(ReadOnlyBoolean),
  /** A boolean value (writeonly) */
  WriteOnlyBoolean: Object.freeze(WriteOnlyBoolean),
  /** A string */
  String: Object.freeze(String),
  /** A string (readonly) */
  ReadOnlyString: Object.freeze(ReadOnlyString),
  /** A string (writeonly) */
  WriteOnlyString: Object.freeze(WriteOnlyString),
  /** A (hex) string that represents a color */
  Color: Object.freeze(Color),
  /** A (hex) string that represents a color (readonly) */
  ReadOnlyColor: Object.freeze(ReadOnlyColor),
  /** A (hex) string that represents a color (writeonly) */
  WriteOnlyColor: Object.freeze(WriteOnlyColor),
  /** A duration value */
  Duration: Object.freeze(_Duration),
  /** A duration value (readonly) */
  ReadOnlyDuration: Object.freeze(ReadOnlyDuration),
  /** A duration value (writeonly) */
  WriteOnlyDuration: Object.freeze(WriteOnlyDuration),
  /** A buffer */
  Buffer: Object.freeze(_Buffer),
  /** A buffer (readonly) */
  ReadOnlyBuffer: Object.freeze(ReadOnlyBuffer),
  /** A buffer (writeonly) */
  WriteOnlyBuffer: Object.freeze(WriteOnlyBuffer)
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConfigValueFormat,
  ValueMetadata,
  enumValuesToMetadataStates,
  getNumericEnumValues
});
//# sourceMappingURL=Metadata.js.map
