import type { GetDeviceConfig } from "@zwave-js/config";
import { type ControlsCC, type EndpointId, type GetAllNodes, type GetEndpoint, type GetNode, type GetSupportedCCVersion, type GetValueDB, type HostIDs, type IsCCSecure, type ListenBehavior, type LogNode, type NodeId, type QuerySecurityClasses, type SetSecurityClass, type SupportsCC } from "@zwave-js/core";
export interface CreateTestingHostOptions extends HostIDs, GetDeviceConfig {
}
export type BaseTestEndpoint = EndpointId & SupportsCC & ControlsCC & IsCCSecure;
export type BaseTestNode = BaseTestEndpoint & NodeId & ListenBehavior & QuerySecurityClasses & SetSecurityClass & SupportsCC & ControlsCC & IsCCSecure & GetEndpoint<BaseTestEndpoint>;
export interface TestingHost extends HostIDs, GetValueDB, GetSupportedCCVersion, GetAllNodes<BaseTestNode>, GetNode<BaseTestNode>, GetDeviceConfig, LogNode {
    setNode(nodeId: number, node: BaseTestNode): void;
}
/** Creates a {@link TestingHost} that can be used instead of a real driver instance in tests */
export declare function createTestingHost(options?: Partial<CreateTestingHostOptions>): TestingHost;
//# sourceMappingURL=mocks.d.ts.map