"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BufferedNVMReader_exports = {};
__export(BufferedNVMReader_exports, {
  BufferedNVMReader: () => BufferedNVMReader
});
module.exports = __toCommonJS(BufferedNVMReader_exports);
var import_shared = require("@zwave-js/shared");
class BufferedNVMReader {
  static {
    __name(this, "BufferedNVMReader");
  }
  constructor(inner) {
    this._inner = inner;
  }
  _inner;
  // Already-read chunks. There are a few rules to follow:
  // - Offsets MUST be multiples of the chunk size
  // - The size of each chunk must be exactly the chunk size
  _buffer = [];
  open(access) {
    return this._inner.open(access);
  }
  get size() {
    return this._inner.size;
  }
  get accessMode() {
    return this._inner.accessMode;
  }
  determineChunkSize() {
    return this._inner.determineChunkSize();
  }
  async readBuffered(alignedOffset, chunkSize) {
    let buffered = this._buffer.find((chunk) => chunk.offset === alignedOffset);
    if (!buffered) {
      const { buffer: data } = await this._inner.read(alignedOffset, chunkSize);
      buffered = { data, offset: alignedOffset };
      this._buffer.push(buffered);
    }
    return buffered.data;
  }
  async read(offset, length) {
    const chunkSize = await this.determineChunkSize();
    length = Math.min(length, chunkSize);
    const firstChunkStart = offset - offset % chunkSize;
    const secondChunkStart = offset + length - (offset + length) % chunkSize;
    const chunks = [];
    chunks.push(await this.readBuffered(firstChunkStart, chunkSize));
    if (secondChunkStart > firstChunkStart) {
      chunks.push(await this.readBuffered(secondChunkStart, chunkSize));
    }
    const alignedBuffer = import_shared.Bytes.concat(chunks);
    const endOfFile = offset + length >= this.size;
    const buffer = alignedBuffer.subarray(offset - firstChunkStart, offset - firstChunkStart + length);
    return {
      buffer,
      endOfFile
    };
  }
  async write(offset, data) {
    const ret = await this._inner.write(offset, data);
    const chunkSize = await this.determineChunkSize();
    const firstChunkStart = offset - offset % chunkSize;
    const lastChunkStart = offset + ret.bytesWritten - (offset + ret.bytesWritten) % chunkSize;
    for (let i = firstChunkStart; i <= lastChunkStart; i += chunkSize) {
      const index = this._buffer.findIndex((chunk) => chunk.offset === i);
      if (index !== -1) {
        this._buffer.splice(index, 1);
      }
    }
    return ret;
  }
  close() {
    return this._inner.close();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BufferedNVMReader
});
//# sourceMappingURL=BufferedNVMReader.js.map
