import { Bytes } from "@zwave-js/shared";
import type { NVM3Object } from "../object.js";
import { NVMFile, type NVMFileCreationOptions, type NVMFileDeserializationOptions } from "./NVMFile.js";
export type ControllerInfoFileOptions = NVMFileCreationOptions & {
    homeId: Uint8Array;
    nodeId: number;
    lastNodeId: number;
    staticControllerNodeId: number;
    sucLastIndex: number;
    controllerConfiguration: number;
    maxNodeId: number;
    reservedId: number;
    systemState: number;
} & ({
    sucAwarenessPushNeeded: number;
} | {
    lastNodeIdLR: number;
    maxNodeIdLR: number;
    reservedIdLR: number;
    primaryLongRangeChannelId: number;
    dcdcConfig: number;
});
export declare const ControllerInfoFileID = 327684;
export declare class ControllerInfoFile extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | ControllerInfoFileOptions);
    homeId: Uint8Array;
    nodeId: number;
    lastNodeId: number;
    staticControllerNodeId: number;
    sucLastIndex: number;
    controllerConfiguration: number;
    sucAwarenessPushNeeded?: number;
    maxNodeId: number;
    reservedId: number;
    systemState: number;
    lastNodeIdLR?: number;
    maxNodeIdLR?: number;
    reservedIdLR?: number;
    primaryLongRangeChannelId?: number;
    dcdcConfig?: number;
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): Record<string, string | number>;
}
//# sourceMappingURL=ControllerInfoFile.d.ts.map