"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var utils_exports = {};
__export(utils_exports, {
  computeBergerCode: () => computeBergerCode,
  computeBergerCodeMulti: () => computeBergerCodeMulti,
  dumpNVM: () => dumpNVM,
  mapToObject: () => mapToObject,
  validateBergerCode: () => validateBergerCode,
  validateBergerCodeMulti: () => validateBergerCodeMulti
});
module.exports = __toCommonJS(utils_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_consts = require("./consts.js");
var import_NVMFile = require("./files/NVMFile.js");
function computeBergerCode(word, numBits = 32) {
  let ret = word;
  if (numBits < 32) {
    ret &= (1 << numBits) - 1;
  }
  ret = ret - (ret >> 1 & 1431655765);
  ret = (ret & 858993459) + (ret >> 2 & 858993459);
  ret = (ret + (ret >> 4) & 252645135) * 16843009 >> 24;
  return numBits - ret;
}
__name(computeBergerCode, "computeBergerCode");
function validateBergerCode(word, code, numBits = 32) {
  if (computeBergerCode(word, numBits) !== code) {
    throw new import_core.ZWaveError("Berger Code validation failed!", import_core.ZWaveErrorCodes.NVM_InvalidFormat);
  }
}
__name(validateBergerCode, "validateBergerCode");
function computeBergerCodeMulti(words, numBits) {
  let ret = 0;
  for (const word of words) {
    ret += computeBergerCode(word, Math.min(numBits, 32));
    if (numBits < 32)
      break;
    numBits -= 32;
  }
  return ret;
}
__name(computeBergerCodeMulti, "computeBergerCodeMulti");
function validateBergerCodeMulti(words, numBits) {
  let actual = 0;
  let expected;
  for (const word of words) {
    actual += computeBergerCode(word, Math.min(numBits, 32));
    if (numBits < 32) {
      const maskSize = 32 - numBits;
      const mask = (1 << maskSize) - 1;
      expected = word >>> numBits & mask;
      break;
    }
    numBits -= 32;
  }
  if (actual !== expected) {
    throw new import_core.ZWaveError("Berger Code validation failed!", import_core.ZWaveErrorCodes.NVM_InvalidFormat);
  }
}
__name(validateBergerCodeMulti, "validateBergerCodeMulti");
function mapToObject(map) {
  const obj = {};
  for (const [key, value] of map) {
    obj[key] = value;
  }
  return obj;
}
__name(mapToObject, "mapToObject");
function dumpObject(obj, json = false) {
  try {
    if (json) {
      const file = import_NVMFile.NVMFile.from(obj.key, obj.data, "7.0.0");
      console.log(JSON.stringify({
        offset: (0, import_shared.num2hex)(obj.offset),
        ...file.toJSON()
      }, null, 2));
      console.log();
      return;
    }
  } catch {
  }
  const prefix = json ? "" : "  ";
  console.log(`${prefix}\xB7 offset: ${(0, import_shared.num2hex)(obj.offset)}`);
  console.log(`${prefix}  key: 0x${obj.key.toString(16)}`);
  console.log(`${prefix}  type: ${import_consts.ObjectType[obj.type]}`);
  console.log(`${prefix}  fragment type: ${import_consts.FragmentType[obj.fragmentType]}`);
  if (obj.data) {
    console.log(`${prefix}  data: ${(0, import_shared.buffer2hex)(obj.data)} (${obj.data.length} bytes)`);
  }
  console.log();
}
__name(dumpObject, "dumpObject");
async function dumpNVM(nvm) {
  for (const [name, section] of Object.entries(nvm.info.sections)) {
    console.log(`NVM section: ${name}`);
    for (const page of section.pages) {
      console.log("");
      console.log(`page (offset 0x${page.offset.toString(16)}):`);
      console.log(`  version: ${page.version}`);
      console.log(`  eraseCount: ${page.eraseCount}`);
      console.log(`  status: ${import_consts.PageStatus[page.status]}`);
      console.log(`  encrypted: ${page.encrypted}`);
      console.log(`  pageSize: ${page.pageSize}`);
      console.log(`  writeSize: ${page.writeSize}`);
      console.log(`  memoryMapped: ${page.memoryMapped}`);
      console.log(`  deviceFamily: ${page.deviceFamily}`);
      console.log("");
      if (page.objects.length) {
        console.log(`  raw objects:`);
        for (const objectHeader of page.objects) {
          const objectData = objectHeader.type !== import_consts.ObjectType.Deleted ? await nvm.readObjectData(objectHeader) : void 0;
          dumpObject({
            offset: objectHeader.offset,
            key: objectHeader.key,
            type: objectHeader.type,
            fragmentType: objectHeader.fragmentType,
            data: objectData
          }, false);
        }
      }
    }
    console.log();
    console.log();
  }
  for (const [name, section] of Object.entries(nvm.info.sections)) {
    console.log(`${name} objects:`);
    for (const [fileId, pageIndex] of section.objectLocations) {
      const page = section.pages[pageIndex];
      const objectHeader = page.objects.findLast((o) => o.key === fileId);
      if (!objectHeader)
        continue;
      const objectData = await nvm.get(fileId);
      dumpObject({
        offset: objectHeader.offset,
        key: fileId,
        type: objectHeader.type,
        fragmentType: import_consts.FragmentType.None,
        data: objectData
      }, true);
    }
    console.log();
  }
}
__name(dumpNVM, "dumpNVM");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  computeBergerCode,
  computeBergerCodeMulti,
  dumpNVM,
  mapToObject,
  validateBergerCode,
  validateBergerCodeMulti
});
//# sourceMappingURL=utils.js.map
