var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { CommandClasses } from "@zwave-js/core";
import { Bytes } from "@zwave-js/shared";
import { NVMFile, gotDeserializationOptions, nvmFileID, nvmSection, } from "./NVMFile.js";
const MAX_CCs = 35;
export const ApplicationCCsFileID = 103;
let ApplicationCCsFile = (() => {
    let _classDecorators = [nvmFileID(ApplicationCCsFileID), nvmSection("application")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = NVMFile;
    var ApplicationCCsFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ApplicationCCsFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (gotDeserializationOptions(options)) {
                let offset = 0;
                let numCCs = this.payload[offset];
                this.includedInsecurely = [
                    ...this.payload.subarray(offset + 1, offset + 1 + numCCs),
                ];
                offset += MAX_CCs;
                numCCs = this.payload[offset];
                this.includedSecurelyInsecureCCs = [
                    ...this.payload.subarray(offset + 1, offset + 1 + numCCs),
                ];
                offset += MAX_CCs;
                numCCs = this.payload[offset];
                this.includedSecurelySecureCCs = [
                    ...this.payload.subarray(offset + 1, offset + 1 + numCCs),
                ];
            }
            else {
                this.includedInsecurely = options.includedInsecurely;
                this.includedSecurelyInsecureCCs =
                    options.includedSecurelyInsecureCCs;
                this.includedSecurelySecureCCs = options.includedSecurelySecureCCs;
            }
        }
        includedInsecurely;
        includedSecurelyInsecureCCs;
        includedSecurelySecureCCs;
        serialize() {
            this.payload = new Bytes((1 + MAX_CCs) * 3);
            let offset = 0;
            for (const array of [
                this.includedInsecurely,
                this.includedSecurelyInsecureCCs,
                this.includedSecurelySecureCCs,
            ]) {
                this.payload[offset] = array.length;
                this.payload.set(array, offset + 1);
                offset += 1 + MAX_CCs;
            }
            return super.serialize();
        }
        // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
        toJSON() {
            return {
                ...super.toJSON(),
                "included insecurely": this.includedInsecurely
                    .map((cc) => CommandClasses[cc])
                    .join(", "),
                "included securely (insecure)": this.includedSecurelyInsecureCCs
                    .map((cc) => CommandClasses[cc])
                    .join(", "),
                "included securely (secure)": this.includedSecurelySecureCCs
                    .map((cc) => CommandClasses[cc])
                    .join(", "),
            };
        }
    };
    return ApplicationCCsFile = _classThis;
})();
export { ApplicationCCsFile };
//# sourceMappingURL=ApplicationCCsFile.js.map