import { type NodeProtocolInfo } from "@zwave-js/core";
import { Bytes } from "@zwave-js/shared";
import type { NVM3Object } from "../object.js";
import { NVMFile, type NVMFileCreationOptions, type NVMFileDeserializationOptions } from "./NVMFile.js";
export declare const NODEINFOS_PER_FILE_V1 = 4;
export declare const LR_NODEINFOS_PER_FILE_V5 = 50;
export interface NodeInfo extends Omit<NodeProtocolInfo, "hasSpecificDeviceClass"> {
    nodeId: number;
    genericDeviceClass: number;
    specificDeviceClass?: number | null;
    neighbors: number[];
    sucUpdateIndex: number;
}
export interface LRNodeInfo extends Omit<NodeProtocolInfo, "hasSpecificDeviceClass"> {
    nodeId: number;
    genericDeviceClass: number;
    specificDeviceClass?: number | null;
}
export interface NodeInfoFileV0Options extends NVMFileCreationOptions {
    nodeInfo: NodeInfo;
}
export declare const NodeInfoFileV0IDBase = 327936;
export declare function nodeIdToNodeInfoFileIDV0(nodeId: number): number;
export declare class NodeInfoFileV0 extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | NodeInfoFileV0Options);
    nodeInfo: NodeInfo;
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        nodeInfo: NodeInfo;
    };
}
export interface NodeInfoFileV1Options extends NVMFileCreationOptions {
    nodeInfos: NodeInfo[];
}
export declare const NodeInfoFileV1IDBase = 328192;
export declare function nodeIdToNodeInfoFileIDV1(nodeId: number): number;
export declare class NodeInfoFileV1 extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | NodeInfoFileV1Options);
    nodeInfos: NodeInfo[];
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        "node infos": NodeInfo[];
    };
}
export interface LRNodeInfoFileV5Options extends NVMFileCreationOptions {
    nodeInfos: LRNodeInfo[];
}
export declare const LRNodeInfoFileV5IDBase = 329728;
export declare function nodeIdToLRNodeInfoFileIDV5(nodeId: number): number;
export declare class LRNodeInfoFileV5 extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | LRNodeInfoFileV5Options);
    nodeInfos: LRNodeInfo[];
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        "node infos": LRNodeInfo[];
    };
}
//# sourceMappingURL=NodeInfoFiles.d.ts.map