import { type PageStatus, type PageWriteSize } from "./consts.js";
import type { NVM3Object } from "./object.js";
export interface NVM3PageHeader {
    offset: number;
    version: number;
    eraseCount: number;
    status: PageStatus;
    encrypted: boolean;
    pageSize: number;
    writeSize: PageWriteSize;
    memoryMapped: boolean;
    deviceFamily: number;
}
export interface NVM3Page {
    header: NVM3PageHeader;
    objects: NVM3Object[];
}
export declare function pageSizeToBits(pageSize: number): number;
export declare function pageSizeFromBits(bits: number): number;
export declare function serializePageHeader(header: Omit<NVM3PageHeader, "offset">): Uint8Array;
//# sourceMappingURL=page.d.ts.map