"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var node_exports = {};
__export(node_exports, {
  serial: () => serial
});
module.exports = __toCommonJS(node_exports);
var import_promises = __toESM(require("node:fs/promises"), 1);
var import_node_os = __toESM(require("node:os"), 1);
var import_node_path = __toESM(require("node:path"), 1);
var import_serialport = require("serialport");
var import_NodeSerialPort = require("../serialport/NodeSerialPort.js");
var import_NodeSocket = require("../serialport/NodeSocket.js");
const serial = {
  createFactoryByPath(path2) {
    if (path2.startsWith("tcp://")) {
      const url = new URL(path2);
      return Promise.resolve((0, import_NodeSocket.createNodeSocketFactory)({
        host: url.hostname,
        port: parseInt(url.port)
      }));
    } else {
      return Promise.resolve((0, import_NodeSerialPort.createNodeSerialPortFactory)(path2));
    }
  },
  async list() {
    const ret = [];
    if (import_node_os.default.platform() === "linux") {
      const dir = "/dev/serial/by-id";
      const symlinks = await import_promises.default.readdir(dir).catch(() => []);
      for (const l of symlinks) {
        try {
          const fullPath = import_node_path.default.join(dir, l);
          const target = import_node_path.default.join(dir, await import_promises.default.readlink(fullPath));
          if (!target.startsWith("/dev/tty"))
            continue;
          ret.push({
            type: "link",
            path: fullPath
          });
        } catch {
        }
      }
    }
    const ports = await import_serialport.SerialPort.list();
    ret.push(...ports.map((port) => ({
      type: "tty",
      path: port.path
    })));
    return ret;
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  serial
});
//# sourceMappingURL=node.js.map
