"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZnifferMessages_exports = {};
__export(ZnifferMessages_exports, {
  ZnifferDataMessage: () => ZnifferDataMessage,
  ZnifferGetFrequenciesRequest: () => ZnifferGetFrequenciesRequest,
  ZnifferGetFrequenciesResponse: () => ZnifferGetFrequenciesResponse,
  ZnifferGetFrequencyInfoRequest: () => ZnifferGetFrequencyInfoRequest,
  ZnifferGetFrequencyInfoResponse: () => ZnifferGetFrequencyInfoResponse,
  ZnifferGetLRChannelConfigInfoRequest: () => ZnifferGetLRChannelConfigInfoRequest,
  ZnifferGetLRChannelConfigInfoResponse: () => ZnifferGetLRChannelConfigInfoResponse,
  ZnifferGetLRChannelConfigsRequest: () => ZnifferGetLRChannelConfigsRequest,
  ZnifferGetLRChannelConfigsResponse: () => ZnifferGetLRChannelConfigsResponse,
  ZnifferGetLRRegionsRequest: () => ZnifferGetLRRegionsRequest,
  ZnifferGetLRRegionsResponse: () => ZnifferGetLRRegionsResponse,
  ZnifferGetVersionRequest: () => ZnifferGetVersionRequest,
  ZnifferGetVersionResponse: () => ZnifferGetVersionResponse,
  ZnifferMessage: () => ZnifferMessage,
  ZnifferMessageRaw: () => ZnifferMessageRaw,
  ZnifferSetBaudRateRequest: () => ZnifferSetBaudRateRequest,
  ZnifferSetBaudRateResponse: () => ZnifferSetBaudRateResponse,
  ZnifferSetFrequencyRequest: () => ZnifferSetFrequencyRequest,
  ZnifferSetFrequencyResponse: () => ZnifferSetFrequencyResponse,
  ZnifferSetLRChannelConfigRequest: () => ZnifferSetLRChannelConfigRequest,
  ZnifferSetLRChannelConfigResponse: () => ZnifferSetLRChannelConfigResponse,
  ZnifferStartRequest: () => ZnifferStartRequest,
  ZnifferStartResponse: () => ZnifferStartResponse,
  ZnifferStopRequest: () => ZnifferStopRequest,
  ZnifferStopResponse: () => ZnifferStopResponse
});
module.exports = __toCommonJS(ZnifferMessages_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_Constants = require("./Constants.js");
class ZnifferMessageRaw {
  static {
    __name(this, "ZnifferMessageRaw");
  }
  type;
  functionType;
  payload;
  constructor(type, functionType, payload) {
    this.type = type;
    this.functionType = functionType;
    this.payload = payload;
  }
  static parse(data) {
    if (data.length < 3) {
      throw new import_core.ZWaveError("Incomplete Zniffer message", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
    }
    const type = data[0];
    if (type === import_Constants.ZnifferMessageType.Command) {
      const functionType = data[1];
      const length = data[2];
      const payload = import_shared.Bytes.view(data.subarray(3, 3 + length));
      return new ZnifferMessageRaw(type, functionType, payload);
    } else if (type === import_Constants.ZnifferMessageType.Data) {
      const payload = import_shared.Bytes.view(data.subarray(1));
      return new ZnifferMessageRaw(type, void 0, payload);
    } else {
      throw new import_core.ZWaveError(`Invalid Zniffer message type ${type}`, import_core.ZWaveErrorCodes.PacketFormat_InvalidPayload);
    }
  }
  withPayload(payload) {
    return new ZnifferMessageRaw(this.type, this.functionType, payload);
  }
}
function getZnifferMessageConstructor(raw) {
  if (raw.type === import_Constants.ZnifferMessageType.Command) {
    switch (raw.functionType) {
      case import_Constants.ZnifferFunctionType.GetVersion:
        return ZnifferGetVersionResponse;
      case import_Constants.ZnifferFunctionType.SetFrequency:
        return ZnifferSetFrequencyResponse;
      case import_Constants.ZnifferFunctionType.GetFrequencies:
        return ZnifferGetFrequenciesResponse;
      case import_Constants.ZnifferFunctionType.Start:
        return ZnifferStartResponse;
      case import_Constants.ZnifferFunctionType.Stop:
        return ZnifferStopResponse;
      case import_Constants.ZnifferFunctionType.SetLRChannelConfig:
        return ZnifferSetLRChannelConfigResponse;
      case import_Constants.ZnifferFunctionType.GetLRChannelConfigs:
        return ZnifferGetLRChannelConfigsResponse;
      case import_Constants.ZnifferFunctionType.GetLRRegions:
        return ZnifferGetLRRegionsResponse;
      case import_Constants.ZnifferFunctionType.SetBaudRate:
        return ZnifferSetBaudRateResponse;
      case import_Constants.ZnifferFunctionType.GetFrequencyInfo:
        return ZnifferGetFrequencyInfoResponse;
      default:
        return ZnifferMessage;
    }
  } else if (raw.type === import_Constants.ZnifferMessageType.Data) {
    return ZnifferDataMessage;
  } else {
    return ZnifferMessage;
  }
}
__name(getZnifferMessageConstructor, "getZnifferMessageConstructor");
class ZnifferMessage {
  static {
    __name(this, "ZnifferMessage");
  }
  constructor(options) {
    this.type = options.type;
    this.functionType = options.functionType;
    this.payload = options.payload || new import_shared.Bytes();
  }
  static parse(data) {
    const raw = ZnifferMessageRaw.parse(data);
    const Constructor = getZnifferMessageConstructor(raw);
    return Constructor.from(raw);
  }
  /** Creates an instance of the message that is serialized in the given buffer */
  static from(raw) {
    return new this({
      type: raw.type,
      functionType: raw.functionType,
      payload: raw.payload
    });
  }
  type;
  functionType;
  payload;
  /** Serializes this message into a Buffer */
  serialize() {
    if (this.type === import_Constants.ZnifferMessageType.Command) {
      return import_shared.Bytes.concat([
        import_shared.Bytes.from([
          this.type,
          this.functionType,
          this.payload.length
        ]),
        this.payload
      ]);
    } else if (this.type === import_Constants.ZnifferMessageType.Data) {
      const ret = import_shared.Bytes.concat([
        [this.type],
        this.payload
      ]);
      ret[9] = this.payload.length - 10;
      return ret;
    } else {
      throw new import_core.ZWaveError(`Invalid Zniffer message type ${this.type}`, import_core.ZWaveErrorCodes.PacketFormat_InvalidPayload);
    }
  }
}
function computeChecksumXOR(buffer) {
  let ret = 255;
  for (let i = 0; i < buffer.length; i++) {
    ret ^= buffer[i];
  }
  return ret;
}
__name(computeChecksumXOR, "computeChecksumXOR");
class ZnifferDataMessage extends ZnifferMessage {
  static {
    __name(this, "ZnifferDataMessage");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Data,
      payload: options.payload
    });
    this.frameType = options.frameType;
    this.channel = options.channel;
    this.protocolDataRate = options.protocolDataRate;
    this.region = options.region;
    this.rssiRaw = options.rssiRaw;
    this.checksumOK = options.checksumOK;
  }
  static from(raw) {
    if (raw.payload.length < 6) {
      throw new import_core.ZWaveError("Incomplete Zniffer message", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
    }
    const frameType = raw.payload[0];
    const channel = raw.payload[3] >>> 5;
    const protocolDataRate = raw.payload[3] & 31;
    const checksumLength = protocolDataRate >= import_core.ZnifferProtocolDataRate.ZWave_100k ? 2 : 1;
    const region = raw.payload[4];
    const rssiRaw = raw.payload[5];
    let checksumOK;
    let payload;
    if (frameType === import_Constants.ZnifferFrameType.Data) {
      if (raw.payload.length < 9 + checksumLength) {
        throw new import_core.ZWaveError("Incomplete Zniffer message", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
      }
      import_core.validatePayload.withReason(`ZnifferDataMessage[6] = ${raw.payload[6]}`)(raw.payload[6] === 33);
      import_core.validatePayload.withReason(`ZnifferDataMessage[7] = ${raw.payload[7]}`)(raw.payload[7] === 3);
      const remainingLength = raw.payload[8];
      const mpduOffset = 9;
      if (raw.payload.length < mpduOffset + remainingLength) {
        throw new import_core.ZWaveError("Incomplete Zniffer message", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
      }
      const mpdu = raw.payload.subarray(mpduOffset, mpduOffset + remainingLength - checksumLength);
      const checksum = raw.payload.readUIntBE(mpduOffset + remainingLength - checksumLength, checksumLength);
      const expectedChecksum = checksumLength === 1 ? computeChecksumXOR(mpdu) : (0, import_core.CRC16_CCITT)(mpdu);
      checksumOK = checksum === expectedChecksum;
      payload = mpdu;
    } else if (frameType === import_Constants.ZnifferFrameType.BeamStart) {
      if (raw.payload.length < 7) {
        throw new import_core.ZWaveError("Incomplete Zniffer message", import_core.ZWaveErrorCodes.PacketFormat_Truncated);
      }
      import_core.validatePayload.withReason(`ZnifferDataMessage[6] = ${raw.payload[6]}`)(raw.payload[6] === 85);
      checksumOK = true;
      payload = raw.payload.subarray(6);
    } else if (frameType === import_Constants.ZnifferFrameType.BeamStop) {
      checksumOK = true;
      payload = new import_shared.Bytes();
    } else {
      import_core.validatePayload.fail(`Unsupported frame type ${(0, import_shared.getEnumMemberName)(import_Constants.ZnifferFrameType, frameType)}`);
    }
    return new this({
      frameType,
      channel,
      protocolDataRate,
      region,
      rssiRaw,
      payload,
      checksumOK
    });
  }
  frameType;
  channel;
  protocolDataRate;
  region;
  rssiRaw;
  checksumOK;
}
class ZnifferGetVersionRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetVersionRequest");
  }
  constructor() {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetVersion
    });
  }
}
class ZnifferGetVersionResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetVersionResponse");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetVersion
    });
    this.chipType = options.chipType;
    this.majorVersion = options.majorVersion;
    this.minorVersion = options.minorVersion;
  }
  static from(raw) {
    const chipType = (0, import_core.getZWaveChipType)(raw.payload[0], raw.payload[1]);
    const majorVersion = raw.payload[2];
    const minorVersion = raw.payload[3];
    return new this({
      chipType,
      majorVersion,
      minorVersion
    });
  }
  chipType;
  majorVersion;
  minorVersion;
}
class ZnifferSetFrequencyRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferSetFrequencyRequest");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.SetFrequency
    });
    this.frequency = options.frequency;
  }
  frequency;
  serialize() {
    this.payload = import_shared.Bytes.from([this.frequency]);
    return super.serialize();
  }
}
class ZnifferSetFrequencyResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferSetFrequencyResponse");
  }
}
class ZnifferGetFrequenciesRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetFrequenciesRequest");
  }
  constructor() {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetFrequencies
    });
  }
}
class ZnifferGetFrequenciesResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetFrequenciesResponse");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetFrequencies
    });
    this.currentFrequency = options.currentFrequency;
    this.supportedFrequencies = options.supportedFrequencies;
  }
  static from(raw) {
    const currentFrequency = raw.payload[0];
    const supportedFrequencies = [
      ...raw.payload.subarray(1)
    ];
    return new this({
      currentFrequency,
      supportedFrequencies
    });
  }
  currentFrequency;
  supportedFrequencies;
}
class ZnifferStartRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferStartRequest");
  }
  constructor() {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.Start
    });
  }
}
class ZnifferStartResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferStartResponse");
  }
}
class ZnifferStopRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferStopRequest");
  }
  constructor() {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.Stop
    });
  }
}
class ZnifferStopResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferStopResponse");
  }
}
class ZnifferSetLRChannelConfigRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferSetLRChannelConfigRequest");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.SetLRChannelConfig
    });
    this.channelConfig = options.channelConfig;
  }
  channelConfig;
  serialize() {
    this.payload = import_shared.Bytes.from([this.channelConfig]);
    return super.serialize();
  }
}
class ZnifferSetLRChannelConfigResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferSetLRChannelConfigResponse");
  }
}
class ZnifferGetLRChannelConfigsRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetLRChannelConfigsRequest");
  }
  constructor() {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetLRChannelConfigs
    });
  }
}
class ZnifferGetLRChannelConfigsResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetLRChannelConfigsResponse");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetLRChannelConfigs
    });
    this.currentConfig = options.currentConfig;
    this.supportedConfigs = options.supportedConfigs;
  }
  static from(raw) {
    const currentConfig = raw.payload[0];
    const supportedConfigs = [
      ...raw.payload.subarray(1)
    ];
    return new this({
      currentConfig,
      supportedConfigs
    });
  }
  currentConfig;
  supportedConfigs;
}
class ZnifferGetLRRegionsRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetLRRegionsRequest");
  }
  constructor() {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetLRRegions
    });
  }
}
class ZnifferGetLRRegionsResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetLRRegionsResponse");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetLRRegions
    });
    this.regions = options.regions;
  }
  static from(raw) {
    return new this({
      regions: [...raw.payload]
    });
  }
  regions;
}
class ZnifferSetBaudRateRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferSetBaudRateRequest");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.SetBaudRate
    });
    this.baudrate = options.baudrate;
  }
  baudrate;
  serialize() {
    this.payload = import_shared.Bytes.from([this.baudrate]);
    return super.serialize();
  }
}
class ZnifferSetBaudRateResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferSetBaudRateResponse");
  }
}
class ZnifferGetFrequencyInfoRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetFrequencyInfoRequest");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetFrequencyInfo
    });
    this.frequency = options.frequency;
  }
  frequency;
  serialize() {
    this.payload = import_shared.Bytes.from([this.frequency]);
    return super.serialize();
  }
}
class ZnifferGetFrequencyInfoResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetFrequencyInfoResponse");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetFrequencyInfo
    });
    this.frequency = options.frequency;
    this.numChannels = options.numChannels;
    this.frequencyName = options.frequencyName;
  }
  static from(raw) {
    const frequency = raw.payload[0];
    const numChannels = raw.payload[1];
    const frequencyName = raw.payload.subarray(2).toString("ascii");
    return new this({
      frequency,
      numChannels,
      frequencyName
    });
  }
  frequency;
  numChannels;
  frequencyName;
}
class ZnifferGetLRChannelConfigInfoRequest extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetLRChannelConfigInfoRequest");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetLRChannelConfigInfo
    });
    this.channelConfig = options.channelConfig;
  }
  channelConfig;
  serialize() {
    this.payload = import_shared.Bytes.from([this.channelConfig]);
    return super.serialize();
  }
}
class ZnifferGetLRChannelConfigInfoResponse extends ZnifferMessage {
  static {
    __name(this, "ZnifferGetLRChannelConfigInfoResponse");
  }
  constructor(options) {
    super({
      type: import_Constants.ZnifferMessageType.Command,
      functionType: import_Constants.ZnifferFunctionType.GetLRChannelConfigInfo
    });
    this.channelConfig = options.channelConfig;
    this.numChannels = options.numChannels;
    this.configName = options.configName;
  }
  static from(raw) {
    const channelConfig = raw.payload[0];
    const numChannels = raw.payload[1];
    const configName = raw.payload.subarray(2).toString("ascii");
    return new this({
      channelConfig,
      numChannels,
      configName
    });
  }
  channelConfig;
  numChannels;
  configName;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZnifferDataMessage,
  ZnifferGetFrequenciesRequest,
  ZnifferGetFrequenciesResponse,
  ZnifferGetFrequencyInfoRequest,
  ZnifferGetFrequencyInfoResponse,
  ZnifferGetLRChannelConfigInfoRequest,
  ZnifferGetLRChannelConfigInfoResponse,
  ZnifferGetLRChannelConfigsRequest,
  ZnifferGetLRChannelConfigsResponse,
  ZnifferGetLRRegionsRequest,
  ZnifferGetLRRegionsResponse,
  ZnifferGetVersionRequest,
  ZnifferGetVersionResponse,
  ZnifferMessage,
  ZnifferMessageRaw,
  ZnifferSetBaudRateRequest,
  ZnifferSetBaudRateResponse,
  ZnifferSetFrequencyRequest,
  ZnifferSetFrequencyResponse,
  ZnifferSetLRChannelConfigRequest,
  ZnifferSetLRChannelConfigResponse,
  ZnifferStartRequest,
  ZnifferStartResponse,
  ZnifferStopRequest,
  ZnifferStopResponse
});
//# sourceMappingURL=ZnifferMessages.js.map
