import type { CCEncodingContext, CommandClass } from "@zwave-js/cc";
import { type FrameType, type MessageOrCCLogEntry, type RSSI } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
import type { MessageWithCC } from "../utils.js";
export type BridgeApplicationCommandRequestOptions = ({
    command: CommandClass;
} | {
    nodeId: number;
    serializedCC: Uint8Array;
}) & {
    routedBusy: boolean;
    frameType: FrameType;
    isExploreFrame: boolean;
    isForeignFrame: boolean;
    fromForeignHomeId: boolean;
    ownNodeId: number;
    targetNodeId: number | number[];
    rssi?: number;
};
export declare class BridgeApplicationCommandRequest extends Message implements MessageWithCC {
    constructor(options: BridgeApplicationCommandRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): BridgeApplicationCommandRequest;
    readonly routedBusy: boolean;
    readonly frameType: FrameType;
    readonly targetNodeId: number | number[];
    readonly isExploreFrame: boolean;
    readonly isForeignFrame: boolean;
    readonly fromForeignHomeId: boolean;
    readonly rssi?: RSSI;
    readonly ownNodeId: number;
    serializedCC: Uint8Array | undefined;
    serializeCC(ctx: CCEncodingContext): Promise<Uint8Array>;
    command: CommandClass | undefined;
    private _nodeId;
    getNodeId(): number | undefined;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=BridgeApplicationCommandRequest.d.ts.map