import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare enum RemoveFailedNodeStartFlags {
    OK = 0,
    /** The removing process was aborted because the controller  is not the primary one */
    NotPrimaryController = 2,
    /** The removing process was aborted because no call back function is used */
    NoCallbackFunction = 4,
    /** The removing process aborted because the node was node found */
    NodeNotFound = 8,
    /** The removing process is busy */
    RemoveProcessBusy = 16,
    /** The removing process could not be started*/
    RemoveFailed = 32
}
export declare enum RemoveFailedNodeStatus {
    /** The node is working properly (removed from the failed nodes list ) */
    NodeOK = 0,
    /** The failed node was removed from the failed nodes list */
    NodeRemoved = 1,
    /** The failed node was not removed from the failing nodes list */
    NodeNotRemoved = 2
}
export declare class RemoveFailedNodeRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): RemoveFailedNodeRequestBase;
}
export interface RemoveFailedNodeRequestOptions {
    failedNodeId: number;
}
export declare class RemoveFailedNodeRequest extends RemoveFailedNodeRequestBase {
    constructor(options: RemoveFailedNodeRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): RemoveFailedNodeRequest;
    /** The node that should be removed */
    failedNodeId: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
export interface RemoveFailedNodeRequestStatusReportOptions {
    removeStatus: RemoveFailedNodeStatus;
}
export declare class RemoveFailedNodeRequestStatusReport extends RemoveFailedNodeRequestBase implements SuccessIndicator {
    constructor(options: RemoveFailedNodeRequestStatusReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): RemoveFailedNodeRequestStatusReport;
    removeStatus: RemoveFailedNodeStatus;
    isOK(): boolean;
}
export interface RemoveFailedNodeResponseOptions {
    removeStatus: RemoveFailedNodeStartFlags;
}
export declare class RemoveFailedNodeResponse extends Message implements SuccessIndicator {
    constructor(options: RemoveFailedNodeResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): RemoveFailedNodeResponse;
    removeStatus: RemoveFailedNodeStartFlags;
    isOK(): boolean;
}
//# sourceMappingURL=RemoveFailedNodeMessages.d.ts.map