"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var RemoveFailedNodeMessages_exports = {};
__export(RemoveFailedNodeMessages_exports, {
  RemoveFailedNodeRequest: () => RemoveFailedNodeRequest,
  RemoveFailedNodeRequestBase: () => RemoveFailedNodeRequestBase,
  RemoveFailedNodeRequestStatusReport: () => RemoveFailedNodeRequestStatusReport,
  RemoveFailedNodeResponse: () => RemoveFailedNodeResponse,
  RemoveFailedNodeStartFlags: () => RemoveFailedNodeStartFlags,
  RemoveFailedNodeStatus: () => RemoveFailedNodeStatus
});
module.exports = __toCommonJS(RemoveFailedNodeMessages_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var RemoveFailedNodeStartFlags;
(function(RemoveFailedNodeStartFlags2) {
  RemoveFailedNodeStartFlags2[RemoveFailedNodeStartFlags2["OK"] = 0] = "OK";
  RemoveFailedNodeStartFlags2[RemoveFailedNodeStartFlags2["NotPrimaryController"] = 2] = "NotPrimaryController";
  RemoveFailedNodeStartFlags2[RemoveFailedNodeStartFlags2["NoCallbackFunction"] = 4] = "NoCallbackFunction";
  RemoveFailedNodeStartFlags2[RemoveFailedNodeStartFlags2["NodeNotFound"] = 8] = "NodeNotFound";
  RemoveFailedNodeStartFlags2[RemoveFailedNodeStartFlags2["RemoveProcessBusy"] = 16] = "RemoveProcessBusy";
  RemoveFailedNodeStartFlags2[RemoveFailedNodeStartFlags2["RemoveFailed"] = 32] = "RemoveFailed";
})(RemoveFailedNodeStartFlags || (RemoveFailedNodeStartFlags = {}));
var RemoveFailedNodeStatus;
(function(RemoveFailedNodeStatus2) {
  RemoveFailedNodeStatus2[RemoveFailedNodeStatus2["NodeOK"] = 0] = "NodeOK";
  RemoveFailedNodeStatus2[RemoveFailedNodeStatus2["NodeRemoved"] = 1] = "NodeRemoved";
  RemoveFailedNodeStatus2[RemoveFailedNodeStatus2["NodeNotRemoved"] = 2] = "NodeNotRemoved";
})(RemoveFailedNodeStatus || (RemoveFailedNodeStatus = {}));
let RemoveFailedNodeRequestBase = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.RemoveFailedNode), (0, import_serial.priority)(import_core.MessagePriority.Controller)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var RemoveFailedNodeRequestBase2 = class extends _classSuper {
    static {
      __name(this, "RemoveFailedNodeRequestBase");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      RemoveFailedNodeRequestBase2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      if (ctx.origin === import_serial.MessageOrigin.Host) {
        return RemoveFailedNodeRequest.from(raw, ctx);
      } else {
        return RemoveFailedNodeRequestStatusReport.from(raw, ctx);
      }
    }
  };
  return RemoveFailedNodeRequestBase2 = _classThis;
})();
let RemoveFailedNodeRequest = (() => {
  let _classDecorators = [(0, import_serial.expectedResponse)(import_serial.FunctionType.RemoveFailedNode), (0, import_serial.expectedCallback)(import_serial.FunctionType.RemoveFailedNode)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = RemoveFailedNodeRequestBase;
  var RemoveFailedNodeRequest2 = class extends _classSuper {
    static {
      __name(this, "RemoveFailedNodeRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      RemoveFailedNodeRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.failedNodeId = options.failedNodeId;
    }
    static from(raw, ctx) {
      const { nodeId: failedNodeId, bytesRead } = (0, import_core.parseNodeID)(raw.payload, ctx.nodeIdType);
      const callbackId = raw.payload[bytesRead];
      return new this({
        failedNodeId,
        callbackId
      });
    }
    // This must not be called nodeId or rejectAllTransactions may reject the request
    /** The node that should be removed */
    failedNodeId;
    serialize(ctx) {
      this.assertCallbackId();
      const nodeId = (0, import_core.encodeNodeID)(this.failedNodeId, ctx.nodeIdType);
      this.payload = import_shared.Bytes.concat([nodeId, import_shared.Bytes.from([this.callbackId])]);
      return super.serialize(ctx);
    }
  };
  return RemoveFailedNodeRequest2 = _classThis;
})();
class RemoveFailedNodeRequestStatusReport extends RemoveFailedNodeRequestBase {
  static {
    __name(this, "RemoveFailedNodeRequestStatusReport");
  }
  constructor(options) {
    super(options);
    this.callbackId = options.callbackId;
    this.removeStatus = options.removeStatus;
  }
  static from(raw, _ctx) {
    const callbackId = raw.payload[0];
    const removeStatus = raw.payload[1];
    return new this({
      callbackId,
      removeStatus
    });
  }
  removeStatus;
  isOK() {
    return this.removeStatus === RemoveFailedNodeStatus.NodeRemoved;
  }
}
let RemoveFailedNodeResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.RemoveFailedNode)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var RemoveFailedNodeResponse2 = class extends _classSuper {
    static {
      __name(this, "RemoveFailedNodeResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      RemoveFailedNodeResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.removeStatus = options.removeStatus;
    }
    static from(raw, _ctx) {
      const removeStatus = raw.payload[0];
      return new this({
        removeStatus
      });
    }
    removeStatus;
    isOK() {
      return this.removeStatus === RemoveFailedNodeStartFlags.OK;
    }
  };
  return RemoveFailedNodeResponse2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  RemoveFailedNodeRequest,
  RemoveFailedNodeRequestBase,
  RemoveFailedNodeRequestStatusReport,
  RemoveFailedNodeResponse,
  RemoveFailedNodeStartFlags,
  RemoveFailedNodeStatus
});
//# sourceMappingURL=RemoveFailedNodeMessages.js.map
