"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ReplaceFailedNodeRequest_exports = {};
__export(ReplaceFailedNodeRequest_exports, {
  ReplaceFailedNodeRequest: () => ReplaceFailedNodeRequest,
  ReplaceFailedNodeRequestBase: () => ReplaceFailedNodeRequestBase,
  ReplaceFailedNodeRequestStatusReport: () => ReplaceFailedNodeRequestStatusReport,
  ReplaceFailedNodeResponse: () => ReplaceFailedNodeResponse,
  ReplaceFailedNodeStartFlags: () => ReplaceFailedNodeStartFlags,
  ReplaceFailedNodeStatus: () => ReplaceFailedNodeStatus
});
module.exports = __toCommonJS(ReplaceFailedNodeRequest_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var ReplaceFailedNodeStartFlags;
(function(ReplaceFailedNodeStartFlags2) {
  ReplaceFailedNodeStartFlags2[ReplaceFailedNodeStartFlags2["OK"] = 0] = "OK";
  ReplaceFailedNodeStartFlags2[ReplaceFailedNodeStartFlags2["NotPrimaryController"] = 2] = "NotPrimaryController";
  ReplaceFailedNodeStartFlags2[ReplaceFailedNodeStartFlags2["NoCallbackFunction"] = 4] = "NoCallbackFunction";
  ReplaceFailedNodeStartFlags2[ReplaceFailedNodeStartFlags2["NodeNotFound"] = 8] = "NodeNotFound";
  ReplaceFailedNodeStartFlags2[ReplaceFailedNodeStartFlags2["ReplaceProcessBusy"] = 16] = "ReplaceProcessBusy";
  ReplaceFailedNodeStartFlags2[ReplaceFailedNodeStartFlags2["ReplaceFailed"] = 32] = "ReplaceFailed";
})(ReplaceFailedNodeStartFlags || (ReplaceFailedNodeStartFlags = {}));
var ReplaceFailedNodeStatus;
(function(ReplaceFailedNodeStatus2) {
  ReplaceFailedNodeStatus2[ReplaceFailedNodeStatus2["NodeOK"] = 0] = "NodeOK";
  ReplaceFailedNodeStatus2[ReplaceFailedNodeStatus2["FailedNodeReplace"] = 3] = "FailedNodeReplace";
  ReplaceFailedNodeStatus2[ReplaceFailedNodeStatus2["FailedNodeReplaceDone"] = 4] = "FailedNodeReplaceDone";
  ReplaceFailedNodeStatus2[ReplaceFailedNodeStatus2["FailedNodeReplaceFailed"] = 5] = "FailedNodeReplaceFailed";
})(ReplaceFailedNodeStatus || (ReplaceFailedNodeStatus = {}));
let ReplaceFailedNodeRequestBase = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.ReplaceFailedNode), (0, import_serial.priority)(import_core.MessagePriority.Controller)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var ReplaceFailedNodeRequestBase2 = class extends _classSuper {
    static {
      __name(this, "ReplaceFailedNodeRequestBase");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ReplaceFailedNodeRequestBase2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      if (ctx.origin === import_serial.MessageOrigin.Host) {
        return ReplaceFailedNodeRequest.from(raw, ctx);
      } else {
        return ReplaceFailedNodeRequestStatusReport.from(raw, ctx);
      }
    }
  };
  return ReplaceFailedNodeRequestBase2 = _classThis;
})();
let ReplaceFailedNodeRequest = (() => {
  let _classDecorators = [(0, import_serial.expectedResponse)(import_serial.FunctionType.ReplaceFailedNode)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ReplaceFailedNodeRequestBase;
  var ReplaceFailedNodeRequest2 = class extends _classSuper {
    static {
      __name(this, "ReplaceFailedNodeRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ReplaceFailedNodeRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.failedNodeId = options.failedNodeId;
    }
    // This must not be called nodeId or rejectAllTransactions may reject the request
    /** The node that should be removed */
    failedNodeId;
    serialize(ctx) {
      this.assertCallbackId();
      const nodeId = (0, import_core.encodeNodeID)(this.failedNodeId, ctx.nodeIdType);
      this.payload = import_shared.Bytes.concat([nodeId, import_shared.Bytes.from([this.callbackId])]);
      return super.serialize(ctx);
    }
  };
  return ReplaceFailedNodeRequest2 = _classThis;
})();
let ReplaceFailedNodeResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.ReplaceFailedNode)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var ReplaceFailedNodeResponse2 = class extends _classSuper {
    static {
      __name(this, "ReplaceFailedNodeResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ReplaceFailedNodeResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.replaceStatus = options.replaceStatus;
    }
    static from(raw, _ctx) {
      const replaceStatus = raw.payload[0];
      return new this({
        replaceStatus
      });
    }
    replaceStatus;
    isOK() {
      return this.replaceStatus === ReplaceFailedNodeStartFlags.OK;
    }
  };
  return ReplaceFailedNodeResponse2 = _classThis;
})();
class ReplaceFailedNodeRequestStatusReport extends ReplaceFailedNodeRequestBase {
  static {
    __name(this, "ReplaceFailedNodeRequestStatusReport");
  }
  constructor(options) {
    super(options);
    this.callbackId = options.callbackId;
    this.replaceStatus = options.replaceStatus;
  }
  static from(raw, _ctx) {
    const callbackId = raw.payload[0];
    const replaceStatus = raw.payload[1];
    return new this({
      callbackId,
      replaceStatus
    });
  }
  replaceStatus;
  isOK() {
    return this.replaceStatus === ReplaceFailedNodeStatus.FailedNodeReplaceDone;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ReplaceFailedNodeRequest,
  ReplaceFailedNodeRequestBase,
  ReplaceFailedNodeRequestStatusReport,
  ReplaceFailedNodeResponse,
  ReplaceFailedNodeStartFlags,
  ReplaceFailedNodeStatus
});
//# sourceMappingURL=ReplaceFailedNodeRequest.js.map
