import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare enum LearnModeIntent {
    LegacyStop = 0,
    LegacyInclusionExclusion = 1,
    LegacyNetworkWideInclusion = 2,
    LegacyNetworkWideExclusion = 3,
    Stop = 128,
    Inclusion = 129,
    DirectExclusion = 130,
    NetworkWideExclusion = 131,
    SmartStart = 132
}
export declare enum LearnModeStatus {
    Started = 1,
    ProtocolDone = 5,// Not specified, but used in firmware
    Completed = 6,
    Failed = 7
}
export declare class SetLearnModeRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): SetLearnModeRequestBase;
}
export interface SetLearnModeRequestOptions {
    intent: LearnModeIntent;
}
export declare class SetLearnModeRequest extends SetLearnModeRequestBase {
    constructor(options: SetLearnModeRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): SetLearnModeRequest;
    intent: LearnModeIntent;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SetLearnModeResponseOptions {
    success: boolean;
}
export declare class SetLearnModeResponse extends Message implements SuccessIndicator {
    constructor(options: SetLearnModeResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SetLearnModeResponse;
    readonly success: boolean;
    isOK(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SetLearnModeCallbackOptions {
    status: LearnModeStatus;
    assignedNodeId: number;
    statusMessage?: Uint8Array;
}
export declare class SetLearnModeCallback extends SetLearnModeRequestBase implements SuccessIndicator {
    constructor(options: SetLearnModeCallbackOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SetLearnModeCallback;
    readonly status: LearnModeStatus;
    readonly assignedNodeId: number;
    readonly statusMessage?: Uint8Array;
    isOK(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=SetLearnModeMessages.d.ts.map