import { type MessageOrCCLogEntry, ZWaveDataRate } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { type AllOrNone, Bytes } from "@zwave-js/shared";
export type SetPriorityRouteRequestOptions = {
    destinationNodeId: number;
} & AllOrNone<{
    repeaters: number[];
    routeSpeed: ZWaveDataRate;
}>;
export declare class SetPriorityRouteRequest extends Message {
    constructor(options: SetPriorityRouteRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): SetPriorityRouteRequest;
    destinationNodeId: number;
    repeaters: number[] | undefined;
    routeSpeed: ZWaveDataRate | undefined;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SetPriorityRouteResponseOptions {
    success: boolean;
}
export declare class SetPriorityRouteResponse extends Message implements SuccessIndicator {
    constructor(options: SetPriorityRouteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): SetPriorityRouteResponse;
    isOK(): boolean;
    readonly success: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=SetPriorityRouteMessages.d.ts.map