"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var LegacyBindingWrapper_exports = {};
__export(LegacyBindingWrapper_exports, {
  wrapLegacySerialBinding: () => wrapLegacySerialBinding
});
module.exports = __toCommonJS(LegacyBindingWrapper_exports);
var import_core = require("@zwave-js/core");
function wrapLegacySerialBinding(legacy) {
  return async function() {
    const instance = legacy.create();
    await legacy.open(instance);
    let isOpen = true;
    async function close() {
      if (isOpen) {
        await legacy.close(instance);
      }
    }
    __name(close, "close");
    const sink = {
      start(controller) {
        instance.on("error", (err) => controller.error(err));
      },
      write(data, controller) {
        if (!isOpen) {
          controller.error(new Error("The serial port is not open!"));
        }
        return new Promise((resolve, reject) => {
          instance.write(data, (err) => {
            if (err)
              reject(err);
            else
              resolve();
          });
        });
      },
      close() {
        return close();
      },
      abort(_reason) {
        return close();
      }
    };
    const source = {
      start(controller) {
        instance.on("data", (data) => controller.enqueue(data));
        instance.on("close", () => {
          isOpen = false;
          controller.error(new import_core.ZWaveError(`The serial port closed unexpectedly!`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
        });
      },
      cancel() {
        instance.removeAllListeners();
      }
    };
    return { source, sink };
  };
}
__name(wrapLegacySerialBinding, "wrapLegacySerialBinding");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  wrapLegacySerialBinding
});
//# sourceMappingURL=LegacyBindingWrapper.js.map
