"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NodeSocket_exports = {};
__export(NodeSocket_exports, {
  createNodeSocketFactory: () => createNodeSocketFactory
});
module.exports = __toCommonJS(NodeSocket_exports);
var import_core = require("@zwave-js/core");
var import_node_net = __toESM(require("node:net"), 1);
function createNodeSocketFactory(socketOptions) {
  return async function() {
    const socket = new import_node_net.default.Socket();
    function removeListeners() {
      socket.removeAllListeners("close");
      socket.removeAllListeners("error");
      socket.removeAllListeners("open");
    }
    __name(removeListeners, "removeListeners");
    function open() {
      return new Promise((resolve, reject) => {
        const onClose = /* @__PURE__ */ __name(() => {
          reject(new import_core.ZWaveError(`The socket closed unexpectedly!`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
        }, "onClose");
        const onError = /* @__PURE__ */ __name((err) => {
          removeListeners();
          reject(err);
        }, "onError");
        const onConnect = /* @__PURE__ */ __name(() => {
          socket.setKeepAlive(true, 1e3);
          removeListeners();
          resolve();
        }, "onConnect");
        socket.once("close", onClose);
        socket.once("error", onError);
        socket.once("connect", onConnect);
        socket.connect(socketOptions);
      });
    }
    __name(open, "open");
    function close() {
      return new Promise((resolve) => {
        removeListeners();
        if (socket.destroyed) {
          resolve();
        } else {
          socket.once("close", () => resolve()).destroy();
        }
      });
    }
    __name(close, "close");
    await open();
    let isOpen = true;
    const sink = {
      write(data, controller) {
        if (!isOpen) {
          controller.error(new Error("The serial port is not open!"));
        }
        return new Promise((resolve, reject) => {
          socket.write(data, (err) => {
            if (err)
              reject(err);
            else
              resolve();
          });
        });
      },
      close() {
        return close();
      },
      abort(_reason) {
        return close();
      }
    };
    const source = {
      start(controller) {
        socket.on("data", (data) => controller.enqueue(data));
        socket.on("close", () => {
          isOpen = false;
          controller.error(new import_core.ZWaveError(`The serial port closed unexpectedly!`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
        });
        socket.on("error", (_e) => {
          isOpen = false;
          controller.error(new import_core.ZWaveError(`The serial port closed unexpectedly!`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
        });
      },
      cancel() {
        socket.removeAllListeners();
      }
    };
    return { source, sink };
  };
}
__name(createNodeSocketFactory, "createNodeSocketFactory");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createNodeSocketFactory
});
//# sourceMappingURL=NodeSocket.js.map
