/** Indicates the type of a data message */
export var MessageType;
(function (MessageType) {
    MessageType[MessageType["Request"] = 0] = "Request";
    MessageType[MessageType["Response"] = 1] = "Response";
})(MessageType || (MessageType = {}));
/**
 * Complete list of function IDs for data messages.
 * IDs starting with FUNC_ID are straight from OZW and not implemented here yet.
 * IDs starting with UNKNOWN_FUNC are taken from openhab-zwave and not implemented here yet.
 * IDs starting with UNKNOWN_FUNC are also taken from https://github.com/yepher/RaZBerry/blob/master/README.md and not implemented yet
 * IDs ending with UNKNOWN_<hex-code> are reported by the stick but we don't know what they mean.
 */
export var FunctionType;
(function (FunctionType) {
    FunctionType[FunctionType["GetSerialApiInitData"] = 2] = "GetSerialApiInitData";
    FunctionType[FunctionType["SetApplicationNodeInformation"] = 3] = "SetApplicationNodeInformation";
    FunctionType[FunctionType["ApplicationCommand"] = 4] = "ApplicationCommand";
    FunctionType[FunctionType["GetControllerCapabilities"] = 5] = "GetControllerCapabilities";
    FunctionType[FunctionType["SetSerialApiTimeouts"] = 6] = "SetSerialApiTimeouts";
    FunctionType[FunctionType["GetSerialApiCapabilities"] = 7] = "GetSerialApiCapabilities";
    FunctionType[FunctionType["SoftReset"] = 8] = "SoftReset";
    FunctionType[FunctionType["GetProtocolVersion"] = 9] = "GetProtocolVersion";
    FunctionType[FunctionType["SerialAPIStarted"] = 10] = "SerialAPIStarted";
    FunctionType[FunctionType["SerialAPISetup"] = 11] = "SerialAPISetup";
    FunctionType[FunctionType["SetRFReceiveMode"] = 16] = "SetRFReceiveMode";
    FunctionType[FunctionType["UNKNOWN_FUNC_SET_SLEEP_MODE"] = 17] = "UNKNOWN_FUNC_SET_SLEEP_MODE";
    FunctionType[FunctionType["SendNodeInformation"] = 18] = "SendNodeInformation";
    FunctionType[FunctionType["SendData"] = 19] = "SendData";
    FunctionType[FunctionType["SendDataMulticast"] = 20] = "SendDataMulticast";
    FunctionType[FunctionType["GetControllerVersion"] = 21] = "GetControllerVersion";
    FunctionType[FunctionType["SendDataAbort"] = 22] = "SendDataAbort";
    FunctionType[FunctionType["FUNC_ID_ZW_R_F_POWER_LEVEL_SET"] = 23] = "FUNC_ID_ZW_R_F_POWER_LEVEL_SET";
    FunctionType[FunctionType["UNKNOWN_FUNC_SEND_DATA_META"] = 24] = "UNKNOWN_FUNC_SEND_DATA_META";
    FunctionType[FunctionType["FUNC_ID_ZW_GET_RANDOM"] = 28] = "FUNC_ID_ZW_GET_RANDOM";
    FunctionType[FunctionType["GetControllerId"] = 32] = "GetControllerId";
    FunctionType[FunctionType["UNKNOWN_FUNC_MEMORY_GET_BYTE"] = 33] = "UNKNOWN_FUNC_MEMORY_GET_BYTE";
    FunctionType[FunctionType["UNKNOWN_FUNC_MEMORY_PUT_BYTE"] = 34] = "UNKNOWN_FUNC_MEMORY_PUT_BYTE";
    FunctionType[FunctionType["UNKNOWN_FUNC_MEMORY_GET_BUFFER"] = 35] = "UNKNOWN_FUNC_MEMORY_GET_BUFFER";
    FunctionType[FunctionType["UNKNOWN_FUNC_MEMORY_PUT_BUFFER"] = 36] = "UNKNOWN_FUNC_MEMORY_PUT_BUFFER";
    FunctionType[FunctionType["EnterBootloader"] = 39] = "EnterBootloader";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x28"] = 40] = "UNKNOWN_FUNC_UNKNOWN_0x28";
    FunctionType[FunctionType["GetNVMId"] = 41] = "GetNVMId";
    FunctionType[FunctionType["ExtNVMReadLongBuffer"] = 42] = "ExtNVMReadLongBuffer";
    FunctionType[FunctionType["ExtNVMWriteLongBuffer"] = 43] = "ExtNVMWriteLongBuffer";
    FunctionType[FunctionType["ExtNVMReadLongByte"] = 44] = "ExtNVMReadLongByte";
    FunctionType[FunctionType["ExtExtWriteLongByte"] = 45] = "ExtExtWriteLongByte";
    FunctionType[FunctionType["NVMOperations"] = 46] = "NVMOperations";
    FunctionType[FunctionType["UNKNOWN_FUNC_CLOCK_SET"] = 48] = "UNKNOWN_FUNC_CLOCK_SET";
    FunctionType[FunctionType["UNKNOWN_FUNC_CLOCK_GET"] = 49] = "UNKNOWN_FUNC_CLOCK_GET";
    FunctionType[FunctionType["UNKNOWN_FUNC_CLOCK_COMPARE"] = 50] = "UNKNOWN_FUNC_CLOCK_COMPARE";
    FunctionType[FunctionType["UNKNOWN_FUNC_RTC_TIMER_CREATE"] = 51] = "UNKNOWN_FUNC_RTC_TIMER_CREATE";
    FunctionType[FunctionType["UNKNOWN_FUNC_RTC_TIMER_READ"] = 52] = "UNKNOWN_FUNC_RTC_TIMER_READ";
    FunctionType[FunctionType["UNKNOWN_FUNC_RTC_TIMER_DELETE"] = 53] = "UNKNOWN_FUNC_RTC_TIMER_DELETE";
    FunctionType[FunctionType["UNKNOWN_FUNC_RTC_TIMER_CALL"] = 54] = "UNKNOWN_FUNC_RTC_TIMER_CALL";
    FunctionType[FunctionType["ClearTxTimers"] = 55] = "ClearTxTimers";
    FunctionType[FunctionType["GetTxTimers"] = 56] = "GetTxTimers";
    FunctionType[FunctionType["ClearNetworkStats"] = 57] = "ClearNetworkStats";
    FunctionType[FunctionType["GetNetworkStats"] = 58] = "GetNetworkStats";
    FunctionType[FunctionType["GetBackgroundRSSI"] = 59] = "GetBackgroundRSSI";
    FunctionType[FunctionType["SetListenBeforeTalkThreshold"] = 60] = "SetListenBeforeTalkThreshold";
    FunctionType[FunctionType["ExtendedNVMOperations"] = 61] = "ExtendedNVMOperations";
    FunctionType[FunctionType["RemoveSpecificNodeIdFromNetwork"] = 63] = "RemoveSpecificNodeIdFromNetwork";
    FunctionType[FunctionType["FUNC_ID_ZW_SET_LEARN_NODE_STATE"] = 64] = "FUNC_ID_ZW_SET_LEARN_NODE_STATE";
    FunctionType[FunctionType["GetNodeProtocolInfo"] = 65] = "GetNodeProtocolInfo";
    FunctionType[FunctionType["HardReset"] = 66] = "HardReset";
    FunctionType[FunctionType["FUNC_ID_ZW_NEW_CONTROLLER"] = 67] = "FUNC_ID_ZW_NEW_CONTROLLER";
    FunctionType[FunctionType["FUNC_ID_ZW_REPLICATION_COMMAND_COMPLETE"] = 68] = "FUNC_ID_ZW_REPLICATION_COMMAND_COMPLETE";
    FunctionType[FunctionType["FUNC_ID_ZW_REPLICATION_SEND_DATA"] = 69] = "FUNC_ID_ZW_REPLICATION_SEND_DATA";
    FunctionType[FunctionType["AssignReturnRoute"] = 70] = "AssignReturnRoute";
    FunctionType[FunctionType["DeleteReturnRoute"] = 71] = "DeleteReturnRoute";
    FunctionType[FunctionType["RequestNodeNeighborUpdate"] = 72] = "RequestNodeNeighborUpdate";
    FunctionType[FunctionType["ApplicationUpdateRequest"] = 73] = "ApplicationUpdateRequest";
    FunctionType[FunctionType["AddNodeToNetwork"] = 74] = "AddNodeToNetwork";
    FunctionType[FunctionType["RemoveNodeFromNetwork"] = 75] = "RemoveNodeFromNetwork";
    FunctionType[FunctionType["AddControllerAndAssignPrimary"] = 76] = "AddControllerAndAssignPrimary";
    FunctionType[FunctionType["AddPrimaryController"] = 77] = "AddPrimaryController";
    FunctionType[FunctionType["AssignPriorityReturnRoute"] = 79] = "AssignPriorityReturnRoute";
    FunctionType[FunctionType["SetLearnMode"] = 80] = "SetLearnMode";
    FunctionType[FunctionType["AssignSUCReturnRoute"] = 81] = "AssignSUCReturnRoute";
    FunctionType[FunctionType["FUNC_ID_ZW_ENABLE_SUC"] = 82] = "FUNC_ID_ZW_ENABLE_SUC";
    FunctionType[FunctionType["RequestNetworkUpdate"] = 83] = "RequestNetworkUpdate";
    FunctionType[FunctionType["SetSUCNodeId"] = 84] = "SetSUCNodeId";
    FunctionType[FunctionType["DeleteSUCReturnRoute"] = 85] = "DeleteSUCReturnRoute";
    FunctionType[FunctionType["GetSUCNodeId"] = 86] = "GetSUCNodeId";
    FunctionType[FunctionType["SendSUCNodeId"] = 87] = "SendSUCNodeId";
    FunctionType[FunctionType["AssignPrioritySUCReturnRoute"] = 88] = "AssignPrioritySUCReturnRoute";
    FunctionType[FunctionType["UNKNOWN_FUNC_REDISCOVERY_NEEDED"] = 89] = "UNKNOWN_FUNC_REDISCOVERY_NEEDED";
    FunctionType[FunctionType["FUNC_ID_ZW_REQUEST_NODE_NEIGHBOR_UPDATE_OPTIONS"] = 90] = "FUNC_ID_ZW_REQUEST_NODE_NEIGHBOR_UPDATE_OPTIONS";
    FunctionType[FunctionType["ExploreRequestInclusion"] = 94] = "ExploreRequestInclusion";
    FunctionType[FunctionType["ExploreRequestExclusion"] = 95] = "ExploreRequestExclusion";
    FunctionType[FunctionType["RequestNodeInfo"] = 96] = "RequestNodeInfo";
    FunctionType[FunctionType["RemoveFailedNode"] = 97] = "RemoveFailedNode";
    FunctionType[FunctionType["IsFailedNode"] = 98] = "IsFailedNode";
    FunctionType[FunctionType["ReplaceFailedNode"] = 99] = "ReplaceFailedNode";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x66"] = 102] = "UNKNOWN_FUNC_UNKNOWN_0x66";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x67"] = 103] = "UNKNOWN_FUNC_UNKNOWN_0x67";
    FunctionType[FunctionType["RequestProtocolCCEncryption"] = 104] = "RequestProtocolCCEncryption";
    FunctionType[FunctionType["UNKNOWN_FUNC_TIMER_START"] = 112] = "UNKNOWN_FUNC_TIMER_START";
    FunctionType[FunctionType["UNKNOWN_FUNC_TIMER_RESTART"] = 113] = "UNKNOWN_FUNC_TIMER_RESTART";
    FunctionType[FunctionType["UNKNOWN_FUNC_TIMER_CANCEL"] = 114] = "UNKNOWN_FUNC_TIMER_CANCEL";
    FunctionType[FunctionType["UNKNOWN_FUNC_TIMER_CALL"] = 115] = "UNKNOWN_FUNC_TIMER_CALL";
    FunctionType[FunctionType["FirmwareUpdateNVM"] = 120] = "FirmwareUpdateNVM";
    FunctionType[FunctionType["GetRoutingInfo"] = 128] = "GetRoutingInfo";
    FunctionType[FunctionType["UNKNOWN_FUNC_GetTXCounter"] = 129] = "UNKNOWN_FUNC_GetTXCounter";
    FunctionType[FunctionType["UNKNOWN_FUNC_ResetTXCounter"] = 130] = "UNKNOWN_FUNC_ResetTXCounter";
    FunctionType[FunctionType["UNKNOWN_FUNC_StoreNodeInfo"] = 131] = "UNKNOWN_FUNC_StoreNodeInfo";
    FunctionType[FunctionType["UNKNOWN_FUNC_StoreHomeId"] = 132] = "UNKNOWN_FUNC_StoreHomeId";
    FunctionType[FunctionType["LockUnlockLastRoute"] = 144] = "LockUnlockLastRoute";
    FunctionType[FunctionType["UNKNOWN_FUNC_SEND_DATA_ROUTE_DEMO"] = 145] = "UNKNOWN_FUNC_SEND_DATA_ROUTE_DEMO";
    FunctionType[FunctionType["GetPriorityRoute"] = 146] = "GetPriorityRoute";
    FunctionType[FunctionType["SetPriorityRoute"] = 147] = "SetPriorityRoute";
    FunctionType[FunctionType["UNKNOWN_FUNC_SERIAL_API_TEST"] = 149] = "UNKNOWN_FUNC_SERIAL_API_TEST";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x98"] = 152] = "UNKNOWN_FUNC_UNKNOWN_0x98";
    FunctionType[FunctionType["VirtualNodeSetNodeInfo"] = 160] = "VirtualNodeSetNodeInfo";
    FunctionType[FunctionType["FUNC_ID_APPLICATION_SLAVE_COMMAND_HANDLER"] = 161] = "FUNC_ID_APPLICATION_SLAVE_COMMAND_HANDLER";
    FunctionType[FunctionType["VirtualNodeSendNodeInfo"] = 162] = "VirtualNodeSendNodeInfo";
    FunctionType[FunctionType["FUNC_ID_ZW_SEND_SLAVE_DATA"] = 163] = "FUNC_ID_ZW_SEND_SLAVE_DATA";
    FunctionType[FunctionType["VirtualNodeSetLearnMode"] = 164] = "VirtualNodeSetLearnMode";
    FunctionType[FunctionType["GetVirtualNodes"] = 165] = "GetVirtualNodes";
    FunctionType[FunctionType["IsVirtualNode"] = 166] = "IsVirtualNode";
    FunctionType[FunctionType["BridgeApplicationCommand"] = 168] = "BridgeApplicationCommand";
    FunctionType[FunctionType["SendDataBridge"] = 169] = "SendDataBridge";
    FunctionType[FunctionType["SendDataMulticastBridge"] = 171] = "SendDataMulticastBridge";
    FunctionType[FunctionType["EnableWatchdog500"] = 182] = "EnableWatchdog500";
    FunctionType[FunctionType["DisableWatchdog500"] = 183] = "DisableWatchdog500";
    FunctionType[FunctionType["KickWatchdog500"] = 184] = "KickWatchdog500";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0xB9"] = 185] = "UNKNOWN_FUNC_UNKNOWN_0xB9";
    FunctionType[FunctionType["UNKNOWN_FUNC_RF_POWERLEVEL_GET"] = 186] = "UNKNOWN_FUNC_RF_POWERLEVEL_GET";
    FunctionType[FunctionType["GetLibrary"] = 189] = "GetLibrary";
    FunctionType[FunctionType["SendTestFrame"] = 190] = "SendTestFrame";
    FunctionType[FunctionType["GetProtocolStatus"] = 191] = "GetProtocolStatus";
    FunctionType[FunctionType["FUNC_ID_ZW_SET_PROMISCUOUS_MODE"] = 208] = "FUNC_ID_ZW_SET_PROMISCUOUS_MODE";
    FunctionType[FunctionType["FUNC_ID_PROMISCUOUS_APPLICATION_COMMAND_HANDLER"] = 209] = "FUNC_ID_PROMISCUOUS_APPLICATION_COMMAND_HANDLER";
    FunctionType[FunctionType["StartWatchdog"] = 210] = "StartWatchdog";
    FunctionType[FunctionType["StopWatchdog"] = 211] = "StopWatchdog";
    FunctionType[FunctionType["SetMaximumRoutingAttempts"] = 212] = "SetMaximumRoutingAttempts";
    FunctionType[FunctionType["SetMaxSmartStartInclusionRequestInterval"] = 214] = "SetMaxSmartStartInclusionRequestInterval";
    FunctionType[FunctionType["Shutdown"] = 217] = "Shutdown";
    // Long range controller support
    FunctionType[FunctionType["GetLongRangeNodes"] = 218] = "GetLongRangeNodes";
    FunctionType[FunctionType["GetLongRangeChannel"] = 219] = "GetLongRangeChannel";
    FunctionType[FunctionType["SetLongRangeChannel"] = 220] = "SetLongRangeChannel";
    FunctionType[FunctionType["SetLongRangeShadowNodeIDs"] = 221] = "SetLongRangeShadowNodeIDs";
    // Proprietary commands:
    FunctionType[FunctionType["Proprietary_DE"] = 222] = "Proprietary_DE";
    FunctionType[FunctionType["Proprietary_DF"] = 223] = "Proprietary_DF";
    FunctionType[FunctionType["Proprietary_E7"] = 231] = "Proprietary_E7";
    FunctionType[FunctionType["Proprietary_E8"] = 232] = "Proprietary_E8";
    FunctionType[FunctionType["Proprietary_F0"] = 240] = "Proprietary_F0";
    FunctionType[FunctionType["Proprietary_F1"] = 241] = "Proprietary_F1";
    FunctionType[FunctionType["Proprietary_F2"] = 242] = "Proprietary_F2";
    FunctionType[FunctionType["Proprietary_F3"] = 243] = "Proprietary_F3";
    FunctionType[FunctionType["Proprietary_F4"] = 244] = "Proprietary_F4";
    FunctionType[FunctionType["Proprietary_F5"] = 245] = "Proprietary_F5";
    FunctionType[FunctionType["Proprietary_F6"] = 246] = "Proprietary_F6";
    FunctionType[FunctionType["Proprietary_F7"] = 247] = "Proprietary_F7";
    FunctionType[FunctionType["Proprietary_F8"] = 248] = "Proprietary_F8";
    FunctionType[FunctionType["Proprietary_F9"] = 249] = "Proprietary_F9";
    FunctionType[FunctionType["Proprietary_FA"] = 250] = "Proprietary_FA";
    FunctionType[FunctionType["Proprietary_FB"] = 251] = "Proprietary_FB";
    FunctionType[FunctionType["Proprietary_FC"] = 252] = "Proprietary_FC";
    FunctionType[FunctionType["Proprietary_FD"] = 253] = "Proprietary_FD";
    FunctionType[FunctionType["Proprietary_FE"] = 254] = "Proprietary_FE";
})(FunctionType || (FunctionType = {}));
export var ZnifferFunctionType;
(function (ZnifferFunctionType) {
    ZnifferFunctionType[ZnifferFunctionType["GetVersion"] = 1] = "GetVersion";
    ZnifferFunctionType[ZnifferFunctionType["SetFrequency"] = 2] = "SetFrequency";
    ZnifferFunctionType[ZnifferFunctionType["GetFrequencies"] = 3] = "GetFrequencies";
    ZnifferFunctionType[ZnifferFunctionType["Start"] = 4] = "Start";
    ZnifferFunctionType[ZnifferFunctionType["Stop"] = 5] = "Stop";
    ZnifferFunctionType[ZnifferFunctionType["SetLRChannelConfig"] = 6] = "SetLRChannelConfig";
    ZnifferFunctionType[ZnifferFunctionType["GetLRChannelConfigs"] = 7] = "GetLRChannelConfigs";
    ZnifferFunctionType[ZnifferFunctionType["GetLRRegions"] = 8] = "GetLRRegions";
    ZnifferFunctionType[ZnifferFunctionType["SetBaudRate"] = 14] = "SetBaudRate";
    ZnifferFunctionType[ZnifferFunctionType["GetFrequencyInfo"] = 19] = "GetFrequencyInfo";
    ZnifferFunctionType[ZnifferFunctionType["GetLRChannelConfigInfo"] = 20] = "GetLRChannelConfigInfo";
})(ZnifferFunctionType || (ZnifferFunctionType = {}));
export var ZnifferMessageType;
(function (ZnifferMessageType) {
    ZnifferMessageType[ZnifferMessageType["Command"] = 35] = "Command";
    ZnifferMessageType[ZnifferMessageType["Data"] = 33] = "Data";
})(ZnifferMessageType || (ZnifferMessageType = {}));
export var ZnifferFrameType;
(function (ZnifferFrameType) {
    ZnifferFrameType[ZnifferFrameType["Command"] = 0] = "Command";
    ZnifferFrameType[ZnifferFrameType["Data"] = 1] = "Data";
    ZnifferFrameType[ZnifferFrameType["BeamFrame"] = 2] = "BeamFrame";
    ZnifferFrameType[ZnifferFrameType["BeamStart"] = 4] = "BeamStart";
    ZnifferFrameType[ZnifferFrameType["BeamStop"] = 5] = "BeamStop";
})(ZnifferFrameType || (ZnifferFrameType = {}));
//# sourceMappingURL=Constants.js.map